/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.oidc.lr62;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.BaseAutoLogin;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.PwdGenerator;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gcube.oidc.OIDCToSitesAndRolesMapper;
import org.gcube.oidc.URLEncodedContextMapper;
import org.gcube.oidc.rest.JWTToken;
import org.gcube.oidc.rest.OpenIdConnectRESTHelper;
import org.gcube.portal.oidc.lr62.JWTTokenUtil;
import org.gcube.portal.oidc.lr62.LiferayOpenIdConnectConfiguration;
import org.gcube.portal.oidc.lr62.UserSitesToGroupsAndRolesMapper;

/*
 * Exception performing whole class analysis ignored.
 */
public class OpenIdConnectAutoLogin
extends BaseAutoLogin {
    private static final Log log = LogFactoryUtil.getLog(OpenIdConnectAutoLogin.class);

    public String[] doLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String portalURL;
        long groupId;
        JWTToken token;
        if (log.isTraceEnabled() && request.getSession(false) != null) {
            log.trace((Object)("Session details: id=" + request.getSession(false).getId() + ", instance=" + request.getSession(false)));
        }
        if ((token = JWTTokenUtil.getOIDCFromRequest((HttpServletRequest)request)) == null) {
            if (log.isTraceEnabled() && request.getSession(false) != null) {
                log.trace((Object)"OIDC token is null. Can't perform auto login");
            }
            return null;
        }
        LiferayOpenIdConnectConfiguration configuration = LiferayOpenIdConnectConfiguration.getConfiguration((HttpServletRequest)request);
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        User user = OpenIdConnectAutoLogin.createOrUpdateUser((JWTToken)token, (long)companyId, (long)(groupId = PortalUtil.getScopeGroupId((HttpServletRequest)request)), (String)(portalURL = PortalUtil.getPortalURL((HttpServletRequest)request, (boolean)true)), (LiferayOpenIdConnectConfiguration)configuration);
        if (user != null) {
            log.info((Object)"Applying sites and roles strategy");
            try {
                UserSitesToGroupsAndRolesMapper mapper = new UserSitesToGroupsAndRolesMapper(user, (OIDCToSitesAndRolesMapper)new URLEncodedContextMapper(token.getResourceNameToAccessRolesMap(Arrays.asList("account"))));
                mapper.map();
            }
            catch (Throwable t) {
                log.error((Object)"Applying strategy", t);
            }
            log.debug((Object)"Returning logged in user's info");
            return new String[]{String.valueOf(user.getUserId()), UUID.randomUUID().toString(), "false"};
        }
        log.warn((Object)"User is null");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static User createOrUpdateUser(JWTToken token, long companyId, long groupId, String portalURL, LiferayOpenIdConnectConfiguration configuration) throws Exception {
        String email = token.getEmail();
        String given = token.getGiven();
        String family = token.getFamily();
        String subject = token.getSub();
        String username = token.getUserName();
        User user = null;
        try {
            byte[] userAvatar;
            boolean updateUser = false;
            user = UserLocalServiceUtil.fetchUserByEmailAddress((long)companyId, (String)email);
            if (user == null) {
                log.debug((Object)("No Liferay user found with email address=" + email + ", trying with openId"));
                user = UserLocalServiceUtil.fetchUserByOpenId((long)companyId, (String)subject);
                if (user == null) {
                    log.debug((Object)("No Liferay user found with openid=" + subject + " and email address=" + email));
                    if (!configuration.createUnexistingUser()) {
                        log.info((Object)"User will not be created according to configuration");
                        return null;
                    }
                    log.info((Object)"A new user will be created");
                    user = OpenIdConnectAutoLogin.addUser((long)companyId, (long)groupId, (String)portalURL, (String)email, (String)given, (String)family, (String)subject, (String)username);
                } else {
                    log.info((Object)"User found by its openId, the email will be updated");
                    updateUser = true;
                }
            }
            if (user != null) {
                log.debug((Object)"User found, updating name details with info from userinfo if changed");
                if (given != user.getFirstName()) {
                    user.setFirstName(given);
                    updateUser = true;
                }
                if (family != user.getLastName()) {
                    user.setLastName(family);
                    updateUser = true;
                }
                if (email != user.getEmailAddress()) {
                    user.setEmailAddress(email);
                    updateUser = true;
                }
            }
            if (updateUser) {
                UserLocalServiceUtil.updateUser((User)user);
            }
            if ((userAvatar = OpenIdConnectRESTHelper.getUserAvatar((URL)configuration.getAvatarURL(), (JWTToken)token)) != null) {
                log.debug((Object)"Saving the retrieved avatar as user's portrait");
                UserLocalServiceUtil.updatePortrait((long)user.getUserId(), (byte[])userAvatar);
                return user;
            }
            log.debug((Object)"Deleting the user's portrait since no avatar has been found for the user");
            UserLocalServiceUtil.deletePortrait((long)user.getUserId());
            return user;
        }
        catch (PortalException | SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public static User addUser(long companyId, long groupId, String portalURL, String emailAddress, String firstName, String lastName, String openid, String username) throws SystemException, PortalException {
        String password1;
        Locale locale = LocaleUtil.getMostRelevantLocale();
        long creatorUserId = 0L;
        boolean autoPassword = false;
        String password2 = password1 = PwdGenerator.getPassword();
        boolean autoScreenName = username == null;
        String screenName = "";
        if (!autoScreenName) {
            screenName = username;
        }
        long facebookId = 0L;
        String openId = openid;
        String middleName = "";
        int prefixId = 0;
        int suffixId = 0;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = "";
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        long[] userGroupIds = null;
        boolean sendEmail = false;
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(groupId);
        serviceContext.setPortalURL(portalURL);
        User user = UserLocalServiceUtil.addUser((long)creatorUserId, (long)companyId, (boolean)autoPassword, (String)password1, (String)password2, (boolean)autoScreenName, (String)screenName, (String)emailAddress, (long)facebookId, (String)openId, (Locale)locale, (String)firstName, (String)middleName, (String)lastName, (int)prefixId, (int)suffixId, (boolean)male, (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)jobTitle, groupIds, organizationIds, roleIds, userGroupIds, (boolean)sendEmail, (ServiceContext)serviceContext);
        user.setPasswordReset(false);
        user.setEmailAddressVerified(true);
        user.setReminderQueryQuestion("x");
        user.setReminderQueryAnswer("y");
        UserLocalServiceUtil.updateUser((User)user);
        return user;
    }
}

