/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.oidc.lr62;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BaseFilter;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;
import java.net.URL;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gcube.oidc.rest.JWTToken;
import org.gcube.oidc.rest.OpenIdConnectRESTHelper;
import org.gcube.portal.oidc.lr62.JWTTokenUtil;
import org.gcube.portal.oidc.lr62.LiferayOpenIdConnectConfiguration;

public class OpenIdConnectLoginFilter
extends BaseFilter {
    protected static final Log log = LogFactoryUtil.getLog(OpenIdConnectLoginFilter.class);
    public static final String REDIRECT_ATTRIBUTE = "redirect-after-login-to";

    public OpenIdConnectLoginFilter() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Filter created");
        }
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        User user;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Getting user via portal utils");
            }
            user = PortalUtil.getUser((HttpServletRequest)request);
        }
        catch (PortalException | SystemException e) {
            throw new ServletException("Getting user using utils", e);
        }
        HttpSession session = request.getSession(false);
        JWTToken token = null;
        if (user == null) {
            String uri = request.getRequestURI();
            if (log.isDebugEnabled()) {
                log.debug((Object)("No user logged in " + uri));
            }
            String sessionId = session.getId();
            LiferayOpenIdConnectConfiguration configuration = LiferayOpenIdConnectConfiguration.getConfiguration((HttpServletRequest)request);
            if (request.getParameter("state") != null && request.getParameter("state").equals(sessionId)) {
                try {
                    token = OpenIdConnectRESTHelper.queryToken((String)request.getServerName(), (URL)configuration.getTokenURL(), (String)request.getParameter("code"), (String)configuration.getScope(), (String)request.getRequestURL().toString());
                }
                catch (Exception e) {
                    throw new ServletException("Querying token from OIDC server", (Throwable)e);
                }
                JWTTokenUtil.putOIDCInRequest((JWTToken)token, (HttpServletRequest)request);
                String redirect = (String)session.getAttribute(REDIRECT_ATTRIBUTE);
                if (redirect != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Moving existing redirect attribute from session to the request object");
                    }
                    request.setAttribute(REDIRECT_ATTRIBUTE, (Object)redirect);
                    session.removeAttribute(REDIRECT_ATTRIBUTE);
                } else if (log.isTraceEnabled()) {
                    log.trace((Object)"No redirect attribute is set in session object");
                }
            } else {
                String redirect = this.getRedirect(request);
                if (redirect != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Setting orginal requested URI in session: " + redirect));
                    }
                    session.setAttribute(REDIRECT_ATTRIBUTE, (Object)redirect);
                }
                String oidcRedirectURL = OpenIdConnectRESTHelper.buildLoginRequestURL((URL)configuration.getAuthorizationURL(), (String)request.getServerName(), (String)sessionId, (String)request.getRequestURL().toString());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Redirecting to OIDC server login URL: " + oidcRedirectURL));
                }
                response.sendRedirect(oidcRedirectURL);
                return;
            }
        }
        this.processFilter(this.getClass(), request, response, filterChain);
    }

    private String getRedirect(HttpServletRequest request) {
        String redirect;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Getting redirect parameter");
        }
        if ((redirect = request.getParameter("redirect")) == null) {
            String ppId;
            if (log.isTraceEnabled()) {
                log.trace((Object)"Redirect parameter is null, trying with p_p_id and related redirect parameter");
            }
            if ((ppId = request.getParameter("p_p_id")) != null) {
                String redirectParamName = "_" + ppId + "_";
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Getting numbered redirect parameter: " + redirectParamName));
                }
                redirect = request.getParameter(redirectParamName);
            }
        }
        return redirect;
    }

    protected Log getLog() {
        return log;
    }
}

