/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.plugins;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalService;
import com.liferay.portal.service.UserLocalServiceWrapper;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.provider.UmaJWTProvider;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.storagehub.client.plugins.AbstractPlugin;
import org.gcube.common.storagehub.client.proxies.GroupManagerClient;
import org.gcube.portal.oidc.lr62.OIDCUmaUtil;
import org.gcube.portal.plugins.thread.CheckShareLatexUserThread;
import org.gcube.portal.plugins.thread.RemoveUserTokenFromVREThread;
import org.gcube.portal.plugins.thread.UpdateUserToLDAPGroupThread;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;
import org.gcube.vomanagement.usermanagement.model.GatewayRolesNames;

/*
 * Exception performing whole class analysis ignored.
 */
public class GCubeHookUserLocalService
extends UserLocalServiceWrapper {
    private static Log _log = LogFactoryUtil.getLog(GCubeHookUserLocalService.class);

    public GCubeHookUserLocalService(UserLocalService userLocalService) {
        super(userLocalService);
        System.out.println("GCubeHookUserLocalService hook is UP & Listening ...");
    }

    public void addGroupUser(long groupId, long userId) throws SystemException {
        super.addGroupUser(groupId, userId);
        this.addUserToVRERelatedServices(groupId, userId);
    }

    public void addGroupUser(long groupId, User user) throws SystemException {
        super.addGroupUser(groupId, user.getUserId());
        this.addUserToVRERelatedServices(groupId, user.getUserId());
    }

    public void addGroupUsers(long groupId, long[] userIds) throws PortalException, SystemException {
        super.addGroupUsers(groupId, userIds);
        this.addUsersToVRERelatedServices(groupId, userIds);
    }

    public void addGroupUsers(long groupId, List<User> Users) throws PortalException, SystemException {
        super.addGroupUsers(groupId, Users);
        for (User user : Users) {
            this.addUserToVRERelatedServices(groupId, user.getUserId());
        }
    }

    public void unsetGroupUsers(long groupId, long[] userIds, ServiceContext serviceContext) throws PortalException, SystemException {
        super.unsetGroupUsers(groupId, userIds, serviceContext);
        this.removeUsersFromVRERelatedServices(groupId, userIds);
    }

    public void deleteGroupUser(long groupId, long userId) throws SystemException {
        super.deleteGroupUser(groupId, userId);
        this.removeUserFromVREReleatedServices(groupId, userId);
    }

    public void deleteGroupUser(long groupId, User user) throws SystemException {
        super.deleteGroupUser(groupId, user);
        this.removeUserFromVREReleatedServices(groupId, user.getUserId());
    }

    public void deleteGroupUsers(long groupId, long[] userIds) throws SystemException {
        super.deleteGroupUsers(groupId, userIds);
        this.removeUsersFromVRERelatedServices(groupId, userIds);
    }

    public void deleteGroupUsers(long groupId, List<User> Users) throws SystemException {
        super.deleteGroupUsers(groupId, Users);
        for (User user : Users) {
            this.removeUserFromVREReleatedServices(groupId, user.getUserId());
        }
    }

    private void addUsersToVRERelatedServices(long groupId, long[] userId) {
        int i = 0;
        while (i < userId.length) {
            this.addUserToVRERelatedServices(groupId, userId[i]);
            ++i;
        }
    }

    private void addUserToVRERelatedServices(long groupId, long userId) {
        _log.debug((Object)"GCube VRE Folder hook addGroupUser intercepted, trying to add user to VRE Folder");
        LiferayGroupManager gm = new LiferayGroupManager();
        String currScope = ScopeProvider.instance.get();
        String scopeToset = "/" + PortalContext.getConfiguration().getInfrastructureName();
        ScopeProvider.instance.set(scopeToset);
        try {
            if (gm.isVRE(groupId).booleanValue()) {
                _log.debug((Object)"Group is a VRE, proceeding with association ...");
                String scope = gm.getInfrastructureScope(groupId);
                LiferayUserManager um = new LiferayUserManager();
                String username = um.getUserById(userId).getUsername();
                Thread tLdap = new Thread((Runnable)new UpdateUserToLDAPGroupThread(username, scope, groupId, false));
                tLdap.start();
                Thread t = new Thread((Runnable)new CheckShareLatexUserThread(username, scope));
                t.start();
                this.setUser2VREFolder((GroupManager)gm, (UserManager)um, username, scope, true);
            } else {
                _log.debug((Object)"Group is not a VRE, SKIP adding");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ScopeProvider.instance.set(currScope);
    }

    private boolean setUser2VREFolder(GroupManager gm, UserManager uMan, String username2Add, String context, boolean add) throws Exception {
        String previousToken = SecurityTokenProvider.instance.get();
        String infraContext = "/" + PortalContext.getConfiguration().getInfrastructureName();
        long rootgroupId = gm.getGroupIdFromInfrastructureScope(infraContext);
        User theAdmin = LiferayUserManager.getRandomUserWithRole((long)rootgroupId, (GatewayRolesNames)GatewayRolesNames.INFRASTRUCTURE_MANAGER);
        if (theAdmin == null) {
            _log.warn((Object)("Cannot add the user as VRE Folder admin: there is no user having role " + GatewayRolesNames.INFRASTRUCTURE_MANAGER));
            return false;
        }
        LiferayRoleManager rm = new LiferayRoleManager();
        String adminUsername = theAdmin.getScreenName();
        _log.info((Object)("Got the super user: " + adminUsername));
        String theAdminToken = PortalContext.getConfiguration().getCurrentUserToken(infraContext, adminUsername);
        ArrayList<String> rolesString = new ArrayList<String>();
        List theAdminRoles = rm.listRolesByUserAndGroup(theAdmin.getUserId(), rootgroupId);
        for (GCubeRole gCubeRole : theAdminRoles) {
            rolesString.add(gCubeRole.getRoleName());
        }
        rolesString.add(GatewayRolesNames.INFRASTRUCTURE_MANAGER.getRoleName());
        _log.info((Object)("authorizationService().setTokenRoles(theAdminToken, rolesString);" + theAdminToken));
        Constants.authorizationService().setTokenRoles(theAdminToken, rolesString);
        SecurityTokenProvider.instance.set(theAdminToken);
        String previousUmaToken = UmaJWTProvider.instance.get();
        OIDCUmaUtil.provideConfiguredPortalClientUMATokenInThreadLocal((String)infraContext);
        GroupManagerClient client = (GroupManagerClient)AbstractPlugin.groups().build();
        if (add) {
            client.addUserToGroup(username2Add, GCubeHookUserLocalService.getVREFolderNameFromContext((String)context));
        } else {
            client.removeUserFromGroup(username2Add, GCubeHookUserLocalService.getVREFolderNameFromContext((String)context));
        }
        SecurityTokenProvider.instance.set(previousToken);
        if (previousUmaToken != null) {
            UmaJWTProvider.instance.set(previousUmaToken);
        }
        return true;
    }

    private static String getVREFolderNameFromContext(String context) {
        if (context.startsWith("/")) {
            return context.substring(1).replace("/", "-");
        }
        return null;
    }

    private void removeUsersFromVRERelatedServices(long groupId, long[] userId) {
        int i = 0;
        while (i < userId.length) {
            this.removeUserFromVREReleatedServices(groupId, userId[i]);
            ++i;
        }
    }

    private void removeUserFromVREReleatedServices(long groupId, long userId) {
        _log.debug((Object)"GCube VRE Folder hook removeUserFromHLVREFolder intercepted, trying to remove user from VRE Folder");
        LiferayGroupManager gm = new LiferayGroupManager();
        String currScope = ScopeProvider.instance.get();
        String scopeToset = "/" + PortalContext.getConfiguration().getInfrastructureName();
        ScopeProvider.instance.set(scopeToset);
        try {
            if (gm.isVRE(groupId).booleanValue()) {
                _log.debug((Object)"Group is a VRE, proceeding with removal ...");
                String scope = gm.getInfrastructureScope(groupId);
                LiferayUserManager um = new LiferayUserManager();
                String username = um.getUserById(userId).getUsername();
                Thread tLdap = new Thread((Runnable)new UpdateUserToLDAPGroupThread(username, scope, groupId, true));
                tLdap.start();
                this.setUser2VREFolder((GroupManager)gm, (UserManager)um, username, scope, false);
                Thread tToken = new Thread((Runnable)new RemoveUserTokenFromVREThread(username, scope));
                tToken.start();
            } else {
                _log.debug((Object)"Group is not a VRE, SKIP removal");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ScopeProvider.instance.set(currScope);
    }
}

