package org.gcube.portal.plugins;

import static org.gcube.common.authorization.client.Constants.authorizationService;

import java.util.ArrayList;
import java.util.List;

import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.provider.UmaJWTProvider;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.common.storagehub.client.dsl.Util;
import org.gcube.common.storagehub.client.dsl.VREFolderManager;
import org.gcube.portal.oidc.lr62.OIDCUmaUtil;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.RoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;
import org.gcube.vomanagement.usermanagement.model.GatewayRolesNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserGroupRoleLocalService;
import com.liferay.portal.service.UserGroupRoleLocalServiceWrapper;
import com.liferay.portal.service.UserLocalServiceUtil;

public class GCubeHookSiteRoleLocalService extends UserGroupRoleLocalServiceWrapper {
    /**
     * logger
     */
    private static final Logger _log = LoggerFactory.getLogger(GCubeHookSiteRoleLocalService.class);
    private GroupManager gm;
    private LiferayUserManager uMan;

    public GCubeHookSiteRoleLocalService(UserGroupRoleLocalService userGroupRoleLocalService) {
        super(userGroupRoleLocalService);
        gm = new LiferayGroupManager();
        uMan = new LiferayUserManager();
        System.out.println("GCubeHookSiteRoleLocalService hook is UP & Listening ...");
    }

    //TODO: as soon as Feature https://support.d4science.org/issues/17726 is delivered take care of this also 
    @Override
    public java.util.List<com.liferay.portal.model.UserGroupRole> addUserGroupRoles(long[] userIds, long groupId,
            long roleId) throws com.liferay.portal.kernel.exception.SystemException {
        List<UserGroupRole> toReturn = super.addUserGroupRoles(userIds, groupId, roleId);
        return toReturn;
    }

    @Override
    public java.util.List<com.liferay.portal.model.UserGroupRole> addUserGroupRoles(long userId, long groupId,
            long[] roleIds) throws com.liferay.portal.kernel.exception.SystemException {
        List<UserGroupRole> toReturn = super.addUserGroupRoles(userId, groupId, roleIds);
        try {
            String context = gm.getInfrastructureScope(groupId);
            String username = UserLocalServiceUtil.getUser(userId).getScreenName();
            /* Check this part CAREFULLY as when the user is just created it fails*/
            String userToken = authorizationService().resolveTokenByUserAndContext(username, context);
            List<String> userRoles = getUserRoles(roleIds);
            authorizationService().setTokenRoles(userToken, userRoles);
            _log.debug("Check if addUserGroupRoles is done in a VRE");
            if (gm.isVRE(groupId)) {
                _log.debug("addUserGroupRoles performed in a VRE, groupId=" + groupId);
                boolean vreManagerRolePresent = false;
                for (int i = 0; i < roleIds.length; i++) {
                    Role role = RoleLocalServiceUtil.getRole(roleIds[i]);
                    if (role.getName().compareTo(GCubeRole.VRE_MANAGER_LABEL) == 0) {
                        _log.info("User is being promoted (or was) as VREFolder Administrator, userId=" + userId
                                + " on Site groupId=" + groupId);
                        vreManagerRolePresent = true;
                        break;
                    }
                }
                setVREFolderAdministrator(userId, groupId, vreManagerRolePresent);
            } else {
                _log.debug("addUserGroupRoles NOT done in a VRE, groupId=" + groupId);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private List<String> getUserRoles(long[] roleIds) throws PortalException, SystemException {
        List<String> toReturn = new ArrayList<>();
        for (int i = 0; i < roleIds.length; i++) {
            Role role = RoleLocalServiceUtil.getRole(roleIds[i]);
            toReturn.add(role.getName());
        }
        return toReturn;
    }

    private boolean setVREFolderAdministrator(long userId, long groupId, boolean enable) throws Exception {
        String context = gm.getInfrastructureScope(groupId);
        ScopeProvider.instance.set(context);
        String vreFolderTitle = Util.getVREGroupFromContext(context);
        _log.info("The vreFolderTitle on which the VREFolder role is being {} is {}", enable, vreFolderTitle);
        _log.info("Before StorageHubClient shc = new StorageHubClient();");
        StorageHubClient shc = new StorageHubClient();
        _log.info("Before shc.getVreFolderManager(vreFolderTitle);");
        VREFolderManager vreFolderManager = shc.getVreFolderManager(vreFolderTitle);

        String previousToken = SecurityTokenProvider.instance.get();

        //get the super user
        _log.info("//get the super user");

        String infraContext = "/" + PortalContext.getConfiguration().getInfrastructureName();
        long rootgroupId = gm.getGroupIdFromInfrastructureScope(infraContext);
        User theAdmin = LiferayUserManager.getRandomUserWithRole(rootgroupId, GatewayRolesNames.INFRASTRUCTURE_MANAGER);
        if (theAdmin == null) {
            _log.warn("Cannot add the user as VRE Folder admin: there is no user having role "
                    + GatewayRolesNames.INFRASTRUCTURE_MANAGER);
            return false;
        } else {
            RoleManager rm = new LiferayRoleManager();
            String adminUsername = theAdmin.getScreenName();
            _log.info("Got the super user: " + adminUsername);
            String theAdminToken = PortalContext.getConfiguration().getCurrentUserToken(infraContext, adminUsername);
            List<String> rolesString = new ArrayList<String>();
            List<GCubeRole> theAdminRoles = rm.listRolesByUserAndGroup(theAdmin.getUserId(), rootgroupId);
            for (GCubeRole gCubeRole : theAdminRoles) {
                rolesString.add(gCubeRole.getRoleName());
            }
            rolesString.add(GatewayRolesNames.INFRASTRUCTURE_MANAGER.getRoleName());
            _log.info("authorizationService().setTokenRoles(theAdminToken, rolesString);" + theAdminToken);
            authorizationService().setTokenRoles(theAdminToken, rolesString);
            SecurityTokenProvider.instance.set(theAdminToken);

            String previousUmaToken = UmaJWTProvider.instance.get();
            OIDCUmaUtil.provideConfiguredPortalClientUMATokenInThreadLocal(infraContext);

            String theUserToPromoteOrDeclass = uMan.getUserById(userId).getUsername();
            _log.info("The {} is being promoted? {} ", theUserToPromoteOrDeclass, enable);
            if (enable)
                vreFolderManager.setAdmin(theUserToPromoteOrDeclass);
            else
                vreFolderManager.removeAdmin(theUserToPromoteOrDeclass);
            SecurityTokenProvider.instance.set(previousToken);

            if (previousUmaToken != null) {
                UmaJWTProvider.instance.set(previousUmaToken);
            }

            return true;
        }
    }

}
