package org.gcube.portal.plugins;

import static org.gcube.common.authorization.client.Constants.authorizationService;

import java.util.ArrayList;
import java.util.List;

import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.provider.UmaJWTProvider;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.storagehub.client.plugins.AbstractPlugin;
import org.gcube.common.storagehub.client.proxies.GroupManagerClient;
import org.gcube.portal.oidc.lr62.OIDCUmaUtil;
import org.gcube.portal.plugins.thread.CheckShareLatexUserThread;
import org.gcube.portal.plugins.thread.RemoveUserTokenFromVREThread;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.RoleManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;
import org.gcube.vomanagement.usermanagement.model.GatewayRolesNames;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalService;
import com.liferay.portal.service.UserLocalServiceWrapper;
/**
 * 
 * @author Massimiliano Assante, CNR-ISTI
 *
 */
public class GCubeHookUserLocalService extends UserLocalServiceWrapper {

	/**
	 * logger
	 */
	private static Log _log = LogFactoryUtil.getLog(GCubeHookUserLocalService.class);
	/* (non-Java-doc)
	 * @see com.liferay.portal.service.UserLocalServiceWrapper#UserLocalServiceWrapper(UserLocalService userLocalService)
	 */
	public GCubeHookUserLocalService(UserLocalService userLocalService) {
		super(userLocalService);
		System.out.println("GCubeHookUserLocalService hook is UP & Listening ...");
	}
	/** USERS ADD TO GROUP **/
	@Override
	public void addGroupUser(long groupId, long userId)	throws com.liferay.portal.kernel.exception.SystemException {
		super.addGroupUser(groupId, userId);
		addUserToVRERelatedServices(groupId, userId);
	}
	@Override
	public void addGroupUser(long groupId, com.liferay.portal.model.User user)	throws com.liferay.portal.kernel.exception.SystemException {
		super.addGroupUser(groupId, user.getUserId());
		addUserToVRERelatedServices(groupId, user.getUserId());
	}
	@Override
	public void addGroupUsers(long groupId, long[] userIds) throws com.liferay.portal.kernel.exception.PortalException,	com.liferay.portal.kernel.exception.SystemException {
		super.addGroupUsers(groupId, userIds);
		addUsersToVRERelatedServices(groupId, userIds);
	}	
	@Override
	public void addGroupUsers(long groupId,	java.util.List<com.liferay.portal.model.User> Users) throws com.liferay.portal.kernel.exception.PortalException, com.liferay.portal.kernel.exception.SystemException {
		super.addGroupUsers(groupId, Users);
		for (User user : Users) {
			addUserToVRERelatedServices(groupId, user.getUserId());
		}
	}



	/** USERS REMOVAL FROM GROUP  **/
	/**
	 * this is the method used from Liferay Sites Membership Admin
	 */
	@Override
	public void unsetGroupUsers(long groupId, long[] userIds, com.liferay.portal.service.ServiceContext serviceContext)	throws com.liferay.portal.kernel.exception.PortalException, SystemException {
		super.unsetGroupUsers(groupId, userIds, serviceContext);
		removeUsersFromVRERelatedServices(groupId, userIds);
	}

	@Override
	public  void deleteGroupUser(long groupId, long userId)	throws com.liferay.portal.kernel.exception.SystemException {
		super.deleteGroupUser(groupId, userId);
		removeUserFromVREReleatedServices(groupId, userId);
	}	
	@Override
	public  void deleteGroupUser(long groupId, com.liferay.portal.model.User user)	throws com.liferay.portal.kernel.exception.SystemException {
		super.deleteGroupUser(groupId, user);
		removeUserFromVREReleatedServices(groupId, user.getUserId());
	}	
	@Override
	public void deleteGroupUsers(long groupId, long[] userIds)	throws com.liferay.portal.kernel.exception.SystemException {
		super.deleteGroupUsers(groupId, userIds);
		removeUsersFromVRERelatedServices(groupId, userIds);
	}	
	@Override
	public void deleteGroupUsers(long groupId, 	java.util.List<com.liferay.portal.model.User> Users)	throws com.liferay.portal.kernel.exception.SystemException {
		super.deleteGroupUsers(groupId, Users);
		for (User user : Users) {
			removeUserFromVREReleatedServices(groupId, user.getUserId());
		}		
	}		

	//		
	/**
	 * 
	 * @param groupId
	 * @param userId
	 */
	private void addUsersToVRERelatedServices(long groupId, long[] userId)  {
		for (int i = 0; i < userId.length; i++) {
			addUserToVRERelatedServices(groupId, userId[i]);
		}
	}
	/**
	 * this method add the user joiing a VRE to all the related services she was associated (VREFolder, LDAP Group, SecurityToken is not necessary in thi case)
	 * @param groupId
	 * @param userId
	 */
	private void addUserToVRERelatedServices(long groupId, long userId) {
		_log.debug("GCube VRE Folder hook addGroupUser intercepted, trying to add user to VRE Folder");
		GroupManager gm = new LiferayGroupManager();
		String currScope = ScopeProvider.instance.get();
		String scopeToset = "/"+PortalContext.getConfiguration().getInfrastructureName();
		ScopeProvider.instance.set(scopeToset);
		try {
			if (gm.isVRE(groupId)) {
				_log.debug("Group is a VRE, proceeding with association ...");
				String scope = gm.getInfrastructureScope(groupId);
				org.gcube.vomanagement.usermanagement.UserManager um = new LiferayUserManager();
				String username = um.getUserById(userId).getUsername();
				//add the user to shareLatex
				Thread t = new Thread(new CheckShareLatexUserThread(username, scope));
				t.start();
				setUser2VREFolder(gm, um, username, scope, true);
			} else {
				_log.debug("Group is not a VRE, SKIP adding");
			}
		}		
		catch (Exception e) {
			e.printStackTrace();
		}
		ScopeProvider.instance.set(currScope);
	}

	private boolean setUser2VREFolder(GroupManager gm, UserManager uMan, String username2Add, String context, boolean add) throws Exception {
		String previousToken = SecurityTokenProvider.instance.get();
		//get the super user
		String infraContext = "/"+PortalContext.getConfiguration().getInfrastructureName();
		long rootgroupId = gm.getGroupIdFromInfrastructureScope(infraContext);
		User theAdmin = LiferayUserManager.getRandomUserWithRole(rootgroupId, GatewayRolesNames.INFRASTRUCTURE_MANAGER);
		if (theAdmin == null) {
			_log.warn("Cannot add the user as VRE Folder admin: there is no user having role " + GatewayRolesNames.INFRASTRUCTURE_MANAGER);
			return false;
		}
		else {
			RoleManager rm = new LiferayRoleManager();
			String adminUsername = theAdmin.getScreenName();
			_log.info("Got the super user: " +adminUsername);
			String theAdminToken = PortalContext.getConfiguration().getCurrentUserToken(infraContext, adminUsername);
			List<String> rolesString = new ArrayList<String>();
			List<GCubeRole> theAdminRoles = rm.listRolesByUserAndGroup(theAdmin.getUserId(), rootgroupId);			
			for (GCubeRole gCubeRole : theAdminRoles) {
				rolesString.add(gCubeRole.getRoleName());
			}
			rolesString.add(GatewayRolesNames.INFRASTRUCTURE_MANAGER.getRoleName());
			_log.info("authorizationService().setTokenRoles(theAdminToken, rolesString);" +theAdminToken);
			authorizationService().setTokenRoles(theAdminToken, rolesString);
			SecurityTokenProvider.instance.set(theAdminToken);

			String previousUmaToken = UmaJWTProvider.instance.get();
			OIDCUmaUtil.provideConfiguredPortalClientUMATokenInThreadLocal(infraContext);
			GroupManagerClient client = AbstractPlugin.groups().build();
			if (add)
				client.addUserToGroup(username2Add, getVREFolderNameFromContext(context));
			else 
				client.removeUserFromGroup(username2Add, getVREFolderNameFromContext(context));
			SecurityTokenProvider.instance.set(previousToken);

            if (previousUmaToken != null) {
                UmaJWTProvider.instance.set(previousUmaToken);
            }

            return true;
		}
	}

	private static String getVREFolderNameFromContext(String context) {
		if (context.startsWith("/")) {
			return context.substring(1).replace("/", "-");
		}
		return null;
	}

	/**
	 * 
	 * @param groupId
	 * @param userId
	 */
	private void removeUsersFromVRERelatedServices(long groupId, long[] userId)  {
		for (int i = 0; i < userId.length; i++) {
			removeUserFromVREReleatedServices(groupId, userId[i]);
		}
	}
	/**
	 * this method remove the user leaving a VRE from all the related services she was associated (VREFolder, LDAP Group and SecurityToken)
	 * @param groupId
	 * @param userId
	 */
	private void removeUserFromVREReleatedServices(long groupId, long userId) {
		_log.debug("GCube VRE Folder hook removeUserFromHLVREFolder intercepted, trying to remove user from VRE Folder");
		GroupManager gm = new LiferayGroupManager();
		String currScope = ScopeProvider.instance.get();
		String scopeToset = "/"+PortalContext.getConfiguration().getInfrastructureName();
		ScopeProvider.instance.set(scopeToset);
		try {
			if (gm.isVRE(groupId)) {
				_log.debug("Group is a VRE, proceeding with removal ...");
				String scope = gm.getInfrastructureScope(groupId);
				org.gcube.vomanagement.usermanagement.UserManager um = new LiferayUserManager();
				String username = um.getUserById(userId).getUsername();
				setUser2VREFolder(gm, um, username, scope, false);
				Thread tToken = new Thread(new RemoveUserTokenFromVREThread(username, scope));
				tToken.start();			
			} else {
				_log.debug("Group is not a VRE, SKIP removal");
			}
		}		
		catch (Exception e) {
			e.printStackTrace();
		}
		ScopeProvider.instance.set(currScope);
	}

}