/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.plugins;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserGroupRoleLocalService;
import com.liferay.portal.service.UserGroupRoleLocalServiceWrapper;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.provider.UmaJWTProvider;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.common.storagehub.client.dsl.Util;
import org.gcube.common.storagehub.client.dsl.VREFolderManager;
import org.gcube.portal.oidc.lr62.OIDCUmaUtil;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;
import org.gcube.vomanagement.usermanagement.model.GatewayRolesNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCubeHookSiteRoleLocalService
extends UserGroupRoleLocalServiceWrapper {
    private static final Logger _log = LoggerFactory.getLogger(GCubeHookSiteRoleLocalService.class);
    private GroupManager gm = new LiferayGroupManager();
    private LiferayUserManager uMan = new LiferayUserManager();

    public GCubeHookSiteRoleLocalService(UserGroupRoleLocalService userGroupRoleLocalService) {
        super(userGroupRoleLocalService);
        System.out.println("GCubeHookSiteRoleLocalService hook is UP & Listening ...");
    }

    public List<UserGroupRole> addUserGroupRoles(long[] userIds, long groupId, long roleId) throws SystemException {
        List toReturn = super.addUserGroupRoles(userIds, groupId, roleId);
        return toReturn;
    }

    public List<UserGroupRole> addUserGroupRoles(long userId, long groupId, long[] roleIds) throws SystemException {
        List toReturn = super.addUserGroupRoles(userId, groupId, roleIds);
        try {
            String context = this.gm.getInfrastructureScope(groupId);
            String username = UserLocalServiceUtil.getUser((long)userId).getScreenName();
            String userToken = Constants.authorizationService().resolveTokenByUserAndContext(username, context);
            List userRoles = this.getUserRoles(roleIds);
            Constants.authorizationService().setTokenRoles(userToken, userRoles);
            _log.debug("Check if addUserGroupRoles is done in a VRE");
            if (this.gm.isVRE(groupId).booleanValue()) {
                _log.debug("addUserGroupRoles performed in a VRE, groupId=" + groupId);
                boolean vreManagerRolePresent = false;
                for (int i = 0; i < roleIds.length; ++i) {
                    Role role = RoleLocalServiceUtil.getRole((long)roleIds[i]);
                    if (role.getName().compareTo("VRE-Manager") != 0) continue;
                    _log.info("User is being promoted (or was) as VREFolder Administrator, userId=" + userId + " on Site groupId=" + groupId);
                    vreManagerRolePresent = true;
                    break;
                }
                this.setVREFolderAdministrator(userId, groupId, vreManagerRolePresent);
            } else {
                _log.debug("addUserGroupRoles NOT done in a VRE, groupId=" + groupId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private List<String> getUserRoles(long[] roleIds) throws PortalException, SystemException {
        ArrayList<String> toReturn = new ArrayList<String>();
        for (int i = 0; i < roleIds.length; ++i) {
            Role role = RoleLocalServiceUtil.getRole((long)roleIds[i]);
            toReturn.add(role.getName());
        }
        return toReturn;
    }

    private boolean setVREFolderAdministrator(long userId, long groupId, boolean enable) throws Exception {
        String context = this.gm.getInfrastructureScope(groupId);
        ScopeProvider.instance.set(context);
        String vreFolderTitle = Util.getVREGroupFromContext((String)context);
        _log.info("The vreFolderTitle on which the VREFolder role is being {} is {}", (Object)enable, (Object)vreFolderTitle);
        _log.info("Before StorageHubClient shc = new StorageHubClient();");
        StorageHubClient shc = new StorageHubClient();
        _log.info("Before shc.getVreFolderManager(vreFolderTitle);");
        VREFolderManager vreFolderManager = shc.getVreFolderManager(vreFolderTitle);
        String previousToken = SecurityTokenProvider.instance.get();
        _log.info("//get the super user");
        String infraContext = "/" + PortalContext.getConfiguration().getInfrastructureName();
        long rootgroupId = this.gm.getGroupIdFromInfrastructureScope(infraContext);
        User theAdmin = LiferayUserManager.getRandomUserWithRole((long)rootgroupId, (GatewayRolesNames)GatewayRolesNames.INFRASTRUCTURE_MANAGER);
        if (theAdmin == null) {
            _log.warn("Cannot add the user as VRE Folder admin: there is no user having role " + GatewayRolesNames.INFRASTRUCTURE_MANAGER);
            return false;
        }
        LiferayRoleManager rm = new LiferayRoleManager();
        String adminUsername = theAdmin.getScreenName();
        _log.info("Got the super user: " + adminUsername);
        String theAdminToken = PortalContext.getConfiguration().getCurrentUserToken(infraContext, adminUsername);
        ArrayList<String> rolesString = new ArrayList<String>();
        List theAdminRoles = rm.listRolesByUserAndGroup(theAdmin.getUserId(), rootgroupId);
        for (GCubeRole gCubeRole : theAdminRoles) {
            rolesString.add(gCubeRole.getRoleName());
        }
        rolesString.add(GatewayRolesNames.INFRASTRUCTURE_MANAGER.getRoleName());
        _log.info("authorizationService().setTokenRoles(theAdminToken, rolesString);" + theAdminToken);
        Constants.authorizationService().setTokenRoles(theAdminToken, rolesString);
        SecurityTokenProvider.instance.set(theAdminToken);
        String previousUmaToken = UmaJWTProvider.instance.get();
        OIDCUmaUtil.provideConfiguredPortalClientUMATokenInThreadLocal((String)infraContext);
        String theUserToPromoteOrDeclass = this.uMan.getUserById(userId).getUsername();
        _log.info("The {} is being promoted? {} ", (Object)theUserToPromoteOrDeclass, (Object)enable);
        if (enable) {
            vreFolderManager.setAdmin(theUserToPromoteOrDeclass);
        } else {
            vreFolderManager.removeAdmin(theUserToPromoteOrDeclass);
        }
        SecurityTokenProvider.instance.set(previousToken);
        if (previousUmaToken != null) {
            UmaJWTProvider.instance.set(previousUmaToken);
        }
        return true;
    }
}

