/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.plugins;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalService;
import com.liferay.portal.service.UserLocalServiceWrapper;
import java.util.List;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.usermanager.UserManager;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.plugins.thread.CheckShareLatexUserThread;
import org.gcube.portal.plugins.thread.RemoveUserTokenFromVREThread;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;

public class GCubeHookUserLocalService
extends UserLocalServiceWrapper {
    private static Log _log = LogFactoryUtil.getLog(GCubeHookUserLocalService.class);

    public GCubeHookUserLocalService(UserLocalService userLocalService) {
        super(userLocalService);
        System.out.println("GCubeHookUserLocalService hook is UP & Listening ...");
    }

    public void addGroupUser(long groupId, long userId) throws SystemException {
        super.addGroupUser(groupId, userId);
        this.addUserToVRERelatedServices(groupId, userId);
    }

    public void addGroupUser(long groupId, User user) throws SystemException {
        super.addGroupUser(groupId, user.getUserId());
        this.addUserToVRERelatedServices(groupId, user.getUserId());
    }

    public void addGroupUsers(long groupId, long[] userIds) throws PortalException, SystemException {
        super.addGroupUsers(groupId, userIds);
        this.addUsersToVRERelatedServices(groupId, userIds);
    }

    public void addGroupUsers(long groupId, List<User> Users) throws PortalException, SystemException {
        super.addGroupUsers(groupId, Users);
        for (User user : Users) {
            this.addUserToVRERelatedServices(groupId, user.getUserId());
        }
    }

    public void unsetGroupUsers(long groupId, long[] userIds, ServiceContext serviceContext) throws PortalException, SystemException {
        super.unsetGroupUsers(groupId, userIds, serviceContext);
        this.removeUsersFromVRERelatedServices(groupId, userIds);
    }

    public void deleteGroupUser(long groupId, long userId) throws SystemException {
        super.deleteGroupUser(groupId, userId);
        this.removeUserFromVREReleatedServices(groupId, userId);
    }

    public void deleteGroupUser(long groupId, User user) throws SystemException {
        super.deleteGroupUser(groupId, user);
        this.removeUserFromVREReleatedServices(groupId, user.getUserId());
    }

    public void deleteGroupUsers(long groupId, long[] userIds) throws SystemException {
        super.deleteGroupUsers(groupId, userIds);
        this.removeUsersFromVRERelatedServices(groupId, userIds);
    }

    public void deleteGroupUsers(long groupId, List<User> Users) throws SystemException {
        super.deleteGroupUsers(groupId, Users);
        for (User user : Users) {
            this.removeUserFromVREReleatedServices(groupId, user.getUserId());
        }
    }

    private void addUsersToVRERelatedServices(long groupId, long[] userId) {
        for (int i = 0; i < userId.length; ++i) {
            this.addUserToVRERelatedServices(groupId, userId[i]);
        }
    }

    private void addUserToVRERelatedServices(long groupId, long userId) {
        _log.debug((Object)"GCube VRE Folder hook addGroupUser intercepted, trying to add user to VRE Folder");
        LiferayGroupManager gm = new LiferayGroupManager();
        String currScope = ScopeProvider.instance.get();
        String scopeToset = "/" + PortalContext.getConfiguration().getInfrastructureName();
        ScopeProvider.instance.set(scopeToset);
        try {
            if (gm.isVRE(groupId).booleanValue()) {
                _log.debug((Object)"Group is a VRE, proceeding with association ...");
                String scope = gm.getInfrastructureScope(groupId);
                LiferayUserManager um = new LiferayUserManager();
                String username = um.getUserById(userId).getUsername();
                Thread t = new Thread((Runnable)new CheckShareLatexUserThread(username, scope));
                t.start();
                UserManager hlUm = HomeLibrary.getHomeManagerFactory().getUserManager();
                hlUm.associateUserToGroup(scope, username);
            } else {
                _log.debug((Object)"Group is not a VRE, SKIP adding");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ScopeProvider.instance.set(currScope);
    }

    private void removeUsersFromVRERelatedServices(long groupId, long[] userId) {
        for (int i = 0; i < userId.length; ++i) {
            this.removeUserFromVREReleatedServices(groupId, userId[i]);
        }
    }

    private void removeUserFromVREReleatedServices(long groupId, long userId) {
        _log.debug((Object)"GCube VRE Folder hook removeUserFromHLVREFolder intercepted, trying to remove user from VRE Folder");
        LiferayGroupManager gm = new LiferayGroupManager();
        String currScope = ScopeProvider.instance.get();
        String scopeToset = "/" + PortalContext.getConfiguration().getInfrastructureName();
        ScopeProvider.instance.set(scopeToset);
        try {
            if (gm.isVRE(groupId).booleanValue()) {
                _log.debug((Object)"Group is a VRE, proceeding with removal ...");
                String scope = gm.getInfrastructureScope(groupId);
                LiferayUserManager um = new LiferayUserManager();
                String username = um.getUserById(userId).getUsername();
                UserManager hlUm = HomeLibrary.getHomeManagerFactory().getUserManager();
                hlUm.removeUserFromGroup(scope, username);
                Thread tToken = new Thread((Runnable)new RemoveUserTokenFromVREThread(username, scope));
                tToken.start();
            } else {
                _log.debug((Object)"Group is not a VRE, SKIP removal");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ScopeProvider.instance.set(currScope);
    }
}

