/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.plugins;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalService;
import com.liferay.portal.service.UserLocalServiceWrapper;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.provider.UmaJWTProvider;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.storagehub.client.plugins.AbstractPlugin;
import org.gcube.common.storagehub.client.proxies.GroupManagerClient;
import org.gcube.portal.oidc.lr62.OIDCUmaUtil;
import org.gcube.portal.plugins.thread.CheckShareLatexUserThread;
import org.gcube.portal.plugins.thread.RemoveUserTokenFromVREThread;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;
import org.gcube.vomanagement.usermanagement.model.GatewayRolesNames;

/*
 * Exception performing whole class analysis ignored.
 */
public class GCubeHookUserLocalService
extends UserLocalServiceWrapper {
    private static Log _log = LogFactoryUtil.getLog(GCubeHookUserLocalService.class);

    public GCubeHookUserLocalService(UserLocalService userLocalService) {
        super(userLocalService);
        System.out.println("GCubeHookUserLocalService hook is UP & Listening ...");
    }

    public void addGroupUser(long groupId, long userId) throws SystemException {
        super.addGroupUser(groupId, userId);
        this.addUserToVRERelatedServices(groupId, userId);
    }

    public void addGroupUser(long groupId, User user) throws SystemException {
        super.addGroupUser(groupId, user.getUserId());
        this.addUserToVRERelatedServices(groupId, user.getUserId());
    }

    public void addGroupUsers(long groupId, long[] userIds) throws PortalException, SystemException {
        super.addGroupUsers(groupId, userIds);
        this.addUsersToVRERelatedServices(groupId, userIds);
    }

    public void addGroupUsers(long groupId, List<User> Users) throws PortalException, SystemException {
        super.addGroupUsers(groupId, Users);
        for (User user : Users) {
            this.addUserToVRERelatedServices(groupId, user.getUserId());
        }
    }

    public void unsetGroupUsers(long groupId, long[] userIds, ServiceContext serviceContext) throws PortalException, SystemException {
        super.unsetGroupUsers(groupId, userIds, serviceContext);
        this.removeUsersFromVRERelatedServices(groupId, userIds);
    }

    public void deleteGroupUser(long groupId, long userId) throws SystemException {
        super.deleteGroupUser(groupId, userId);
        this.removeUserFromVREReleatedServices(groupId, userId);
    }

    public void deleteGroupUser(long groupId, User user) throws SystemException {
        super.deleteGroupUser(groupId, user);
        this.removeUserFromVREReleatedServices(groupId, user.getUserId());
    }

    public void deleteGroupUsers(long groupId, long[] userIds) throws SystemException {
        super.deleteGroupUsers(groupId, userIds);
        this.removeUsersFromVRERelatedServices(groupId, userIds);
    }

    public void deleteGroupUsers(long groupId, List<User> Users) throws SystemException {
        super.deleteGroupUsers(groupId, Users);
        for (User user : Users) {
            this.removeUserFromVREReleatedServices(groupId, user.getUserId());
        }
    }

    private void addUsersToVRERelatedServices(long groupId, long[] userId) {
        for (int i = 0; i < userId.length; ++i) {
            this.addUserToVRERelatedServices(groupId, userId[i]);
        }
    }

    private void addUserToVRERelatedServices(long groupId, long userId) {
        _log.debug((Object)"GCube VRE Folder hook addGroupUser intercepted, trying to add user to VRE Folder");
        LiferayGroupManager gm = new LiferayGroupManager();
        String currScope = ScopeProvider.instance.get();
        String scopeToset = "/" + PortalContext.getConfiguration().getInfrastructureName();
        ScopeProvider.instance.set(scopeToset);
        try {
            if (gm.isVRE(groupId).booleanValue()) {
                _log.debug((Object)"Group is a VRE, proceeding with association ...");
                String contextOfVRE = gm.getInfrastructureScope(groupId);
                LiferayUserManager um = new LiferayUserManager();
                String username = um.getUserById(userId).getUsername();
                Thread t = new Thread((Runnable)new CheckShareLatexUserThread(username, contextOfVRE));
                t.start();
                this.setUser2VREFolder((GroupManager)gm, (UserManager)um, username, contextOfVRE, true);
            } else {
                _log.debug((Object)"Group is not a VRE, SKIP adding");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ScopeProvider.instance.set(currScope);
    }

    private boolean setUser2VREFolder(GroupManager gm, UserManager uMan, String username2Add, String context, boolean add) throws Exception {
        String previousToken = SecurityTokenProvider.instance.get();
        String previousUMAToken = UmaJWTProvider.instance.get();
        _log.info((Object)("Getting super user with role " + GatewayRolesNames.INFRASTRUCTURE_MANAGER.getRoleName()));
        String infraContext = "/" + PortalContext.getConfiguration().getInfrastructureName();
        long rootgroupId = gm.getGroupIdFromInfrastructureScope(infraContext);
        User theAdmin = LiferayUserManager.getRandomUserWithRole((long)rootgroupId, (GatewayRolesNames)GatewayRolesNames.INFRASTRUCTURE_MANAGER);
        if (theAdmin == null) {
            _log.error((Object)("Cannot add the user to the VRE Folder: there is no user having role Infrastructure-Manager on context: " + infraContext));
            return false;
        }
        String adminUsername = theAdmin.getScreenName();
        _log.info((Object)("Got the super user: " + adminUsername));
        String theAdminToken = PortalContext.getConfiguration().getCurrentUserToken(infraContext, adminUsername);
        ArrayList<String> rolesString = new ArrayList<String>();
        List theAdminRoles = new LiferayRoleManager().listRolesByUserAndGroup(theAdmin.getUserId(), rootgroupId);
        for (GCubeRole gCubeRole : theAdminRoles) {
            rolesString.add(gCubeRole.getRoleName());
        }
        rolesString.add(GatewayRolesNames.INFRASTRUCTURE_MANAGER.getRoleName());
        _log.info((Object)"legacy authorizationService().setTokenRoles done");
        Constants.authorizationService().setTokenRoles(theAdminToken, rolesString);
        SecurityTokenProvider.instance.set(theAdminToken);
        OIDCUmaUtil.provideConfiguredPortalClientUMATokenInThreadLocal((String)("/" + PortalContext.getConfiguration().getInfrastructureName()));
        _log.info((Object)"\n\n\n*VREFolder-Hook** new authorizationService PortalClient UMA-Token In ThreadLocal done  ****\n\n");
        String vreFolderNameForsHub = GCubeHookUserLocalService.getVREFolderNameFromContext((String)context);
        System.out.println("-> VRE FOlder name to pass to shub: " + vreFolderNameForsHub);
        GroupManagerClient client = (GroupManagerClient)AbstractPlugin.groups().build();
        if (add) {
            client.addUserToGroup(username2Add, vreFolderNameForsHub);
        } else {
            client.removeUserFromGroup(username2Add, vreFolderNameForsHub);
        }
        _log.info((Object)("*VREFolder-Hook** " + username2Add + " was added or removed succefully from this VRE Folder. Added? (if false was removed)" + add));
        UmaJWTProvider.instance.set(previousUMAToken);
        SecurityTokenProvider.instance.set(previousToken);
        return true;
    }

    private static String getVREFolderNameFromContext(String context) {
        if (context.startsWith("/")) {
            return context.substring(1).replace("/", "-");
        }
        return null;
    }

    private void removeUsersFromVRERelatedServices(long groupId, long[] userId) {
        for (int i = 0; i < userId.length; ++i) {
            this.removeUserFromVREReleatedServices(groupId, userId[i]);
        }
    }

    private void removeUserFromVREReleatedServices(long groupId, long userId) {
        _log.debug((Object)"GCube VRE Folder hook removeUserFromHLVREFolder intercepted, trying to remove user from VRE Folder");
        LiferayGroupManager gm = new LiferayGroupManager();
        String currScope = ScopeProvider.instance.get();
        String scopeToset = "/" + PortalContext.getConfiguration().getInfrastructureName();
        ScopeProvider.instance.set(scopeToset);
        try {
            if (gm.isVRE(groupId).booleanValue()) {
                _log.debug((Object)"Group is a VRE, proceeding with removal ...");
                String contextOfVRE = gm.getInfrastructureScope(groupId);
                LiferayUserManager um = new LiferayUserManager();
                String username = um.getUserById(userId).getUsername();
                this.setUser2VREFolder((GroupManager)gm, (UserManager)um, username, contextOfVRE, false);
                Thread tToken = new Thread((Runnable)new RemoveUserTokenFromVREThread(username, contextOfVRE));
                tToken.start();
            } else {
                _log.debug((Object)"Group is not a VRE, SKIP removal");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ScopeProvider.instance.set(currScope);
    }
}

