package org.gcube.portal.events;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.gcube.portal.landingpage.LandingPageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.WebKeys;

public class LandingPageAction extends Action {
	
	private static final Logger _log = LoggerFactory.getLogger(LandingPageAction.class);
			
	@Override
	public void run(HttpServletRequest request, HttpServletResponse response) throws ActionException {
		
		_log.info("LandingPageAction is ON");
		
		HttpSession session = request.getSession();
		String path = "";
		try {
			path = getCustomLandingPage(request);
		} catch (Exception e) {
			e.printStackTrace();
		} 
		session.setAttribute(WebKeys.LAST_PATH, new LastPath(StringPool.BLANK, path));
	}
	/**
	 * Returns custom landing page path after user login
	 * 
	 * @param request
	 * @return
	 * @throws PortalException
	 * @throws SystemException
	 */
	private String getCustomLandingPage(final HttpServletRequest request) throws PortalException, SystemException {
		String customLandingPagePath ="";
		customLandingPagePath = LandingPageManager.getLandingPagePath(request);
		_log.info("Private Site LandingPage Path = " +  customLandingPagePath);
		return customLandingPagePath;
	}		
}