package org.gcube.portal.removeaccount.thread;

import java.util.ArrayList;
import java.util.List;
import static org.gcube.common.authorization.client.Constants.authorizationService;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.common.storagehub.client.plugins.AbstractPlugin;
import org.gcube.common.storagehub.client.proxies.UserManagerClient;
import org.gcube.portal.removeaccount.Constants;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.RoleManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

/**
 * 
 * @author Massimiliano Assante ISTI-CNR
 *
 */
public class RemoveUserFromJCR {
	private static Log _log = LogFactoryUtil.getLog(RemoveUserFromJCR.class);

	private String username2Delete;
	private GroupManager gm;
	private UserManager uMan;

	public RemoveUserFromJCR(String username2Delete, GroupManager gm, UserManager uMan) {
		this.username2Delete = username2Delete;
		this.gm = gm;
		this.uMan = uMan;
	}

	public boolean remove() {
		try {
			_log.debug("in RemoveUserFromJCR remove() for " + username2Delete );
			//get the super user
			String infraContext = "/"+PortalContext.getConfiguration().getInfrastructureName();
			long groupId = gm.getGroupIdFromInfrastructureScope(infraContext);
			RoleManager rm = new LiferayRoleManager();
			long roleId = rm.getRoleId(Constants.AUTORISED_INFRA_ROLE, groupId);
			List<GCubeUser> users = uMan.listUsersByGroupAndRole(groupId, roleId);
			if (users.isEmpty()) {
				_log.error("Cannot delete the user: there is no user having role " + Constants.AUTORISED_INFRA_ROLE + " on context: " + infraContext);
				return false;
			}
			else {
				GCubeUser theAdmin = users.get(0);
				String adminUsername =  theAdmin.getUsername();
				String theAdminToken = PortalContext.getConfiguration().getCurrentUserToken(infraContext, adminUsername);
				List<GCubeRole> theAdminRoles = rm.listRolesByUserAndGroup(theAdmin.getUserId(), groupId);			
				List<String> rolesString = new ArrayList<String>();
				for (GCubeRole gCubeRole : theAdminRoles) {
					rolesString.add(gCubeRole.getRoleName());
				}
				authorizationService().setTokenRoles(theAdminToken, rolesString);
				SecurityTokenProvider.instance.set(theAdminToken);
				_log.debug("Autorising drop workspace with infra manager token of " + theAdminToken);
				StorageHubClient shc = new StorageHubClient();
				_log.debug("BEFORE shc.deleteUserAccount " + username2Delete);
				shc.deleteUserAccount(username2Delete);
				return true;
			}
		} catch (Exception e) {
			_log.error("Could not delete " + username2Delete + " from JCR ", e);
			return false;
		}
	}


}
