package org.gcube.portal.databook.shared;


/**
 * @author Massimiliano Assante ISTI-CNR
 * 
 * @version 1.0 July 6th 2012
 */
public enum NotificationType {
	/**
	 * use to notify a user he got a workspace folder shared
	 */
	WP_FOLDER_SHARE,
	/**
	 * use to notify a user that a new user was added in on of his workspace shared folder
	 */
	WP_FOLDER_ADDEDUSER,
	/**
	 * use to notify a user that an existing user was removed from one of his workspace shared folder
	 */
	WP_FOLDER_REMOVEDUSER,
	/**
	 * use to notify a user he got a workspace item deleted from one of his workspace shared folder
	 */
	WP_ITEM_DELETE, 
	/**
	 * use to notify a user he got a workspace item updated from one of his workspace shared folder
	 */
	WP_ITEM_UPDATED, 
	/**
	 * use to notify a user he got a workspace item new in some of his workspace shared folder
	 */
	WP_ITEM_NEW, 
	/**
	 * use to notify a user he got one of his feed commented 
	 */
	OWN_COMMENT,
	/**
	 * use to notify a user that commented on a feed (Not his) that someone commented too 
	 */
	COMMENT, 
	/**
	 * use to notify a user he got one of his feed liked 
	 */
	LIKE, 
	/**
	 * use to notify a user he got a message
	 */
	MESSAGE,
	/**
	 * use to notify a user he got a connections request
	 */
	REQUEST_CONNECTION,
	/**
	 * use to notify a user he got a job completed ok
	 */
	JOB_COMPLETED_OK,
	/**
	 * use to notify a user he got a job completed not ok
	 */
	JOB_COMPLETED_NOK,
	/**
	 * generic notification
	 */
	GENERIC;
}
