/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.ldapexport;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.gcube.common.portal.PortalContext;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPSync
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(LDAPSync.class);
    private static final String ldapUrl = "ldap://ldap-liferay.d4science.org";
    private static final String ldapPrincipal = "cn=admin,dc=d4science,dc=org";
    private static final String ldapPwd = "poiwefhaewfkhj";
    private static final String filter = "(objectClass=inetOrgPerson)";

    public LDAPSync() {
        _log.debug("LDAPSync()");
    }

    @Override
    public void run() {
        _log.debug("Reading Portal Users ...");
        List users = null;
        try {
            users = this.getAllLiferayUsers();
            _log.debug("Read " + users.size() + " from LR DB");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        _log.debug("Initializing LDAP exporter ...");
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapUrl);
        env.put("java.naming.security.principal", ldapPrincipal);
        env.put("java.naming.security.credentials", ldapPwd);
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            _log.debug("Initiating LDAP Sync ...");
            for (User user : users) {
                this.updateUserInLDAP(user.getScreenName(), user.getFirstName(), user.getLastName(), user.getFullName(), user.getEmailAddress(), "{SHA}" + user.getPassword(), (DirContext)ctx, filter);
            }
            _log.debug("LDAP Sync cycle done");
        }
        catch (NamingException e) {
            _log.error("Something went Wrong during LDAP Sync");
            e.printStackTrace();
        }
        if (!users.isEmpty()) {
            _log.info("LDAP Sync Completed OK!");
        } else {
            _log.warn("LDAP Sync cycle skipped this time");
        }
    }

    private String getSubContext(String username) {
        return "uid=" + username + ",ou=People,o=Liferay,ou=Organizations,dc=d4science,dc=org";
    }

    private boolean checkIfLDAPUserExists(String username, DirContext ctx, String filter) {
        NamingEnumeration<SearchResult> answer;
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        try {
            answer = ctx.search(this.getSubContext(username), filter, ctls);
        }
        catch (NamingException e) {
            _log.info("user: " + username + " not found in LDAP, trying to export it");
            return false;
        }
        return answer.hasMoreElements();
    }

    private void updateUserInLDAP(String username, String name, String lastName, String fullName, String email, String passwd, DirContext ctx, String filter) throws NamingException {
        BasicAttributes attributes = new BasicAttributes();
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        objectClass.add("inetOrgPerson");
        attributes.put(objectClass);
        BasicAttribute givenName = new BasicAttribute("givenName");
        BasicAttribute cn = new BasicAttribute("cn");
        BasicAttribute sn = new BasicAttribute("sn");
        BasicAttribute mail = new BasicAttribute("mail");
        BasicAttribute userPassword = new BasicAttribute("userPassword");
        givenName.add(name);
        cn.add(fullName);
        sn.add(lastName);
        mail.add(email);
        userPassword.add(passwd);
        attributes.put(givenName);
        attributes.put(cn);
        attributes.put(sn);
        attributes.put(mail);
        attributes.put(userPassword);
        if (this.checkIfLDAPUserExists(username, ctx, filter)) {
            ctx.modifyAttributes(this.getSubContext(username), 2, (Attributes)attributes);
        } else {
            ctx.createSubcontext(this.getSubContext(username), (Attributes)attributes);
            _log.debug("New User Found with uid=" + username + " created");
        }
    }

    private List<User> getAllLiferayUsers() {
        String infraName = PortalContext.getConfiguration().getInfrastructureName();
        _log.debug("Reading users belonging to: /" + infraName);
        ArrayList<User> toReturn = new ArrayList();
        try {
            Organization rootInfra = OrganizationLocalServiceUtil.getOrganization((long)OrganizationsUtil.getCompany().getCompanyId(), (String)infraName);
            toReturn = UserLocalServiceUtil.getOrganizationUsers((long)rootInfra.getOrganizationId());
        }
        catch (PortalException | SystemException e) {
            _log.error("Error during LDAP Sync, could not retrieve users from LR DB: " + e.getMessage());
        }
        return toReturn;
    }
}

