/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.VirtualHost;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.VirtualHostLocalServiceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.socialmail.EmailPopAccount;
import org.gcube.portal.socialmail.PeriodicTask;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.model.CustomAttributeKeys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PortalSchedulerService
extends HttpServlet {
    private static final Logger _log = LoggerFactory.getLogger(PortalSchedulerService.class);
    private static final String POP3_POLLING_MINUTES_INTERVAL = "pop3pollinginminutes";
    private static final String POP3_SERVER_NAME = "Pop3MailServer";
    private static DatabookStore store;

    public void init() {
        store = new DBCassandraAstyanaxImpl();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        EmailPopAccount popAccount = null;
        try {
            Group site = this.getSiteFromServletRequest(request);
            popAccount = this.getPopAccountData(site);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String toReturn = "<DIV>Check Notification Email Starting ... </DIV>";
        int pollingInterval = this.getPollingInterval();
        ScheduledExecutorService pop3Scheduler = Executors.newScheduledThreadPool(1);
        pop3Scheduler.scheduleAtFixedRate((Runnable)new PeriodicTask(store, popAccount, request), 0L, pollingInterval, TimeUnit.MINUTES);
        String portalName = "unknown";
        try {
            popAccount.getPortalName();
        }
        catch (NullPointerException e) {
            _log.warn("Could not read popAccount data portal name", (Throwable)e);
        }
        _log.info("EmailParser stared for " + portalName + ", pollingInterval (in minutes)=" + pollingInterval);
        toReturn = "<DIV>Check Notification Email Started ... </DIV>";
        response.setContentType("text/html");
        response.getWriter().write(toReturn);
    }

    public int getPollingInterval() {
        Properties props = new Properties();
        int toReturn = 7;
        try {
            String propertyfile = PortalSchedulerService.getCatalinaHome() + File.separator + "conf" + File.separator + "gcube-data.properties";
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            toReturn = Integer.parseInt(props.getProperty("pop3pollinginminutes"));
        }
        catch (IOException e) {
            _log.error("gcube-data.properties file not found under $CATALINA_HOME/conf dir, returning default interval in minutes = " + toReturn);
            return toReturn;
        }
        _log.debug("Returning poling interval in minutes: " + toReturn);
        return toReturn;
    }

    private static String getCatalinaHome() {
        return System.getenv("CATALINA_HOME").endsWith("/") ? System.getenv("CATALINA_HOME") : System.getenv("CATALINA_HOME") + "/";
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    private Group getSiteFromServletRequest(HttpServletRequest request) throws PortalException, SystemException {
        String serverName = request.getServerName();
        _log.debug("currentHost is " + serverName);
        Group site = null;
        List vHosts = VirtualHostLocalServiceUtil.getVirtualHosts((int)0, (int)VirtualHostLocalServiceUtil.getVirtualHostsCount());
        for (VirtualHost virtualHost : vHosts) {
            _log.debug("Found  " + virtualHost.getHostname());
            if (virtualHost.getHostname().compareTo("localhost") == 0 || virtualHost.getLayoutSetId() == 0L || virtualHost.getHostname().compareTo(serverName) != 0) continue;
            long layoutSetId = virtualHost.getLayoutSetId();
            site = LayoutSetLocalServiceUtil.getLayoutSet((long)layoutSetId).getGroup();
            _log.debug("Found match! Your site is " + site.getName());
            return site;
        }
        return null;
    }

    private EmailPopAccount getPopAccountData(Group site) throws GroupRetrievalFault {
        _log.debug("Found site for vhost, name " + site.getName() + " reading custom field: " + CustomAttributeKeys.GATEWAY_SITE_NAME);
        String gatewayName = (String)((Object)new LiferayGroupManager().readCustomAttr(site.getGroupId(), CustomAttributeKeys.GATEWAY_SITE_NAME.getKeyName()));
        String curScope = ScopeProvider.instance.get();
        PortalContext context = PortalContext.getConfiguration();
        String scope2Set = "/" + context.getInfrastructureName();
        ScopeProvider.instance.set(scope2Set);
        EmailPopAccount toReturn = new EmailPopAccount();
        toReturn.setPortalName(gatewayName);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'Portal'");
        query.addCondition("$resource/Profile/Name/text() eq '" + gatewayName + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List list = client.submit((Query)query);
        if (list == null || list.isEmpty()) {
            _log.error("Could not find any Service endpoint registred in the infrastructure for this gateway: " + gatewayName);
            return null;
        }
        if (list.size() > 1) {
            _log.warn("Found more than one Service endpoint registred in the infrastructure for this gateway: " + gatewayName);
            return null;
        }
        for (ServiceEndpoint res : list) {
            org.gcube.common.resources.gcore.utils.Group apGroup = res.profile().accessPoints();
            ServiceEndpoint.AccessPoint[] accessPoints = (ServiceEndpoint.AccessPoint[])apGroup.toArray((Object[])new ServiceEndpoint.AccessPoint[apGroup.size()]);
            for (int i = 0; i < accessPoints.length; ++i) {
                if (accessPoints[i].name().compareTo("Pop3MailServer") != 0) continue;
                _log.info("Found credentials for Pop3MailServer");
                ServiceEndpoint.AccessPoint found = accessPoints[i];
                toReturn.setPop3Server(found.address());
                toReturn.setPop3user(found.username());
                String encrPassword = found.password();
                try {
                    toReturn.setPop3password(StringEncrypter.getEncrypter().decrypt(encrPassword, new Key[0]));
                    continue;
                }
                catch (Exception e) {
                    _log.error("Something went wrong while decrypting password for Pop3MailServer");
                    e.printStackTrace();
                }
            }
        }
        ScopeProvider.instance.set(curScope);
        return toReturn;
    }
}

