/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.threadlocalexec;

import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.client.exceptions.ObjectNotFound;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.threadlocalexec.TheUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartGearsPortalValve
extends ValveBase {
    private static final Logger _log = LoggerFactory.getLogger(SmartGearsPortalValve.class);
    private static final String LIFERAY_POLLER_CONTEXT = "poller/receive";

    public void invoke(Request req, Response resp) throws IOException, ServletException {
        SecurityTokenProvider.instance.reset();
        ScopeProvider.instance.reset();
        AuthorizationProvider.instance.reset();
        if (req instanceof HttpServletRequest) {
            Request request = req;
            if (!req.getRequestURL().toString().endsWith(LIFERAY_POLLER_CONTEXT)) {
                PortalContext context = PortalContext.getConfiguration();
                String scope = context.getCurrentScope((HttpServletRequest)request);
                long groupId = context.getCurrentGroupId((HttpServletRequest)request);
                TheUser theUser = SmartGearsPortalValve.getCurrentUser((HttpServletRequest)request);
                List<String> userRoles = null;
                if (scope != null && theUser != null) {
                    String userToken = null;
                    String username = theUser.getUsername();
                    try {
                        ScopeProvider.instance.set(scope);
                        userToken = Constants.authorizationService().resolveTokenByUserAndContext(username, scope);
                        userRoles = SmartGearsPortalValve.getUserRoles(theUser.getUserId(), groupId);
                        Constants.authorizationService().setTokenRoles(userToken, userRoles);
                        SecurityTokenProvider.instance.set(userToken);
                    }
                    catch (ObjectNotFound ex) {
                        userToken = SmartGearsPortalValve.generateAuthorizationToken(theUser, scope, groupId);
                        SecurityTokenProvider.instance.set(userToken);
                        _log.debug("generateAuthorizationToken OK for " + username + " also set roles in scope " + scope);
                    }
                    catch (Exception e) {
                        _log.error("Something went wrong in generating token for " + username + " in scope " + scope);
                        e.printStackTrace();
                    }
                    _log.trace("Security token and roles set OK for " + username + " found roles: " + userRoles.toString() + " in scope " + scope);
                }
            }
        }
        this.getNext().invoke(req, resp);
    }

    private static List<String> getUserRoles(long userId, long groupId) {
        ArrayList<String> toReturn = new ArrayList<String>();
        try {
            List roles = UserGroupRoleLocalServiceUtil.getUserGroupRolesByGroup((long)groupId);
            for (UserGroupRole ugr : roles) {
                if (ugr.getUserId() != userId || ugr.getRole().getName().startsWith("Site")) continue;
                toReturn.add(ugr.getRole().getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private static String generateAuthorizationToken(TheUser theUser, String scope, long groupId) {
        String token;
        List<String> userRoles = SmartGearsPortalValve.getUserRoles(theUser.getUserId(), groupId);
        try {
            token = Constants.authorizationService().generateUserToken(new UserInfo(theUser.getUsername(), userRoles), scope);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return token;
    }

    public static TheUser getCurrentUser(HttpServletRequest httpServletRequest) {
        String userIdNo = httpServletRequest.getHeader("gcube-userId");
        if (userIdNo != null && userIdNo.compareTo("undefined") != 0) {
            long userId = -1L;
            try {
                userId = Long.parseLong(userIdNo);
                return new TheUser(userId, UserLocalServiceUtil.getUser((long)userId).getScreenName());
            }
            catch (NumberFormatException e) {
                _log.error("The userId is not a number -> " + userIdNo);
                return null;
            }
            catch (Exception e) {
                _log.error("The userId does not belong to any user -> " + userIdNo);
                return null;
            }
        }
        return null;
    }
}

