/**
 * 
 */
package org.gcube.portlets.user.warmanagementwidget.client.data;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public class WarProfile implements Serializable {

	private static final long serialVersionUID = 6325318508852137880L;

	protected String applicationId;
	
	protected String warFileName;
	
	protected String categoryName;
	protected String categoryDescription;
	
	protected String applicationName;
	protected String applicationDescription;
	protected int majorVersion;
	protected int minorVersion;
	protected int ageVersion;
	
	protected ArrayList<String> entryPoints;
	
	public WarProfile(){
		entryPoints = new ArrayList<String>();
	}

	public WarProfile(String applicationId, String warFileName, String categoryName, String categoryDescription,
			String applicationName, String applicationDescription,
			int majorVersion, int minorVersion, int ageVersion, ArrayList<String> entryPoints) {
		this.applicationId = applicationId;
		this.warFileName = warFileName;
		this.categoryName = categoryName;
		this.categoryDescription = categoryDescription;
		this.applicationName = applicationName;
		this.applicationDescription = applicationDescription;
		this.majorVersion = majorVersion;
		this.minorVersion = minorVersion;
		this.ageVersion = ageVersion;
		this.entryPoints = entryPoints;
	}

	/**
	 * @return the applicationId
	 */
	public String getApplicationId() {
		return applicationId;
	}

	/**
	 * @param applicationId the applicationId to set
	 */
	public void setApplicationId(String applicationId) {
		this.applicationId = applicationId;
	}

	/**
	 * @return the warFileName
	 */
	public String getWarFileName() {
		return warFileName;
	}

	/**
	 * @param warFileName the warFileName to set
	 */
	public void setWarFileName(String warFileName) {
		this.warFileName = warFileName;
	}

	/**
	 * @return the categoryName
	 */
	public String getCategoryName() {
		return categoryName;
	}

	/**
	 * @param categoryName the categoryName to set
	 */
	public void setCategoryName(String categoryName) {
		this.categoryName = categoryName;
	}

	/**
	 * @return the categoryDescription
	 */
	public String getCategoryDescription() {
		return categoryDescription;
	}

	/**
	 * @param categoryDescription the categoryDescription to set
	 */
	public void setCategoryDescription(String categoryDescription) {
		this.categoryDescription = categoryDescription;
	}

	/**
	 * @return the applicationName
	 */
	public String getApplicationName() {
		return applicationName;
	}

	/**
	 * @param applicationName the applicationName to set
	 */
	public void setApplicationName(String applicationName) {
		this.applicationName = applicationName;
	}

	/**
	 * @return the applicationDescription
	 */
	public String getApplicationDescription() {
		return applicationDescription;
	}

	/**
	 * @param applicationDescription the applicationDescription to set
	 */
	public void setApplicationDescription(String applicationDescription) {
		this.applicationDescription = applicationDescription;
	}

	/**
	 * @return the majorVersion
	 */
	public int getMajorVersion() {
		return majorVersion;
	}

	/**
	 * @param majorVersion the majorVersion to set
	 */
	public void setMajorVersion(int majorVersion) {
		this.majorVersion = majorVersion;
	}

	/**
	 * @return the minorVersion
	 */
	public int getMinorVersion() {
		return minorVersion;
	}

	/**
	 * @param minorVersion the minorVersion to set
	 */
	public void setMinorVersion(int minorVersion) {
		this.minorVersion = minorVersion;
	}

	/**
	 * @return the ageVersion
	 */
	public int getAgeVersion() {
		return ageVersion;
	}

	/**
	 * @param ageVersion the ageVersion to set
	 */
	public void setAgeVersion(int ageVersion) {
		this.ageVersion = ageVersion;
	}

	/**
	 * @return the entryPoints
	 */
	public ArrayList<String> getEntryPoints() {
		return entryPoints;
	}

	/**
	 * @param entryPoints the entryPoints to set
	 */
	public void setEntryPoints(ArrayList<String> entryPoints) {
		this.entryPoints = entryPoints;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("WarProfile [applicationId=");
		builder.append(applicationId);
		builder.append(", warFileName=");
		builder.append(warFileName);
		builder.append(", categoryName=");
		builder.append(categoryName);
		builder.append(", categoryDescription=");
		builder.append(categoryDescription);
		builder.append(", applicationName=");
		builder.append(applicationName);
		builder.append(", applicationDescription=");
		builder.append(applicationDescription);
		builder.append(", majorVersion=");
		builder.append(majorVersion);
		builder.append(", minorVersion=");
		builder.append(minorVersion);
		builder.append(", ageVersion=");
		builder.append(ageVersion);
		builder.append(", entryPoints=");
		builder.append(entryPoints);
		builder.append("]");
		return builder.toString();
	}
}
