/**
 * 
 */
package org.gcube.portlets.user.warmanagementwidget.client.upload;

import java.util.ArrayList;

import org.gcube.portlets.user.warmanagementwidget.client.upload.source.WarSource;
import org.gcube.portlets.user.warmanagementwidget.client.wizard.WizardCard;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.SimpleRadioButton;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public class SourceSelectionCard extends WizardCard {
	
	protected WarImportSession importSession;

	public SourceSelectionCard(final WarImportSession importSession, ArrayList<WarSource> sources) {
		//FIXME step message calculated
		super("WAR source selection", "Step 1 of 4");
		
		this.importSession = importSession;
		VerticalPanel sourceSelectionPanel = new VerticalPanel();
		sourceSelectionPanel.setSpacing(4);
		sourceSelectionPanel.setWidth("100%");
		sourceSelectionPanel.setHeight("100%");
		
		boolean first = true;
		for (WarSource source:sources) {
			HorizontalPanel sourcePanel = getCSVSourcePanel(source);
			sourceSelectionPanel.add(sourcePanel);
			if (first) importSession.setSource(source);
			first = false;
		}
		
		setContent(sourceSelectionPanel);
		
	}
	
	protected HorizontalPanel getCSVSourcePanel(final WarSource source)
	{
		HorizontalPanel sourcePanel = new HorizontalPanel();
		sourcePanel.setSpacing(2);
		final SimpleRadioButton sourceRadioButton = new SimpleRadioButton("source");
		sourceRadioButton.setValue(true);
		sourceRadioButton.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				if (sourceRadioButton.getValue()) importSession.setSource(source);
			}
			
		});
		
		sourcePanel.add(sourceRadioButton);
		HTML sourceDescription = new HTML();
		StringBuilder description = new StringBuilder();
		description.append("<b>");
		description.append(source.getName());
		description.append("</b><br><p>");
		description.append(source.getDescription());
		description.append("</p>");
		sourceDescription.setHTML(description.toString());
		sourcePanel.add(sourceDescription);
		
		return sourcePanel;
	}

}
