/**
 * 
 */
package org.gcube.portlets.user.warmanagementwidget.client.upload;

import java.util.ArrayList;
import java.util.HashMap;

import org.gcube.portlets.user.warmanagementwidget.client.upload.source.WarSource;
import org.gcube.portlets.user.warmanagementwidget.client.wizard.WizardCard;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.layout.CardLayout;

/**
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public class UploadCard extends WizardCard {

	protected HashMap<String, Component> sourcesPanels = new HashMap<String, Component>();
	protected CardLayout layout;
	protected WarImportSession session;
	
	public UploadCard(WarImportSession session, ArrayList<WarSource> sources) {
		//FIXME step message calculated
		super("War Upload", "Step 2 of 4");

		this.session = session;
		layout = new CardLayout();
		ContentPanel uploadPanel = new ContentPanel(layout);
		uploadPanel.setHeaderVisible(false);
		
		for (WarSource source:sources) {
			Component sourcePanel = source.getPanel(this, session);
			sourcesPanels.put(source.getId(), sourcePanel);
			uploadPanel.add(sourcePanel);
		}
		
		setContent(uploadPanel);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setup() {
		Component sourcePanel = sourcesPanels.get(session.getSource().getId());
		layout.setActiveItem(sourcePanel);
		setEnableNextButton(false);
	}
		

}
