/*
 * Decompiled with CFR 0.152.
 */
package it.eng.edison.usersurvey_portlet.client;

import com.github.gwtbootstrap.client.ui.CellTable;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.DateCell;
import com.google.gwt.cell.client.NumberCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.SelectElement;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.shared.DateTimeFormat;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.Range;
import it.eng.edison.usersurvey_portlet.client.GreetingService;
import it.eng.edison.usersurvey_portlet.client.GreetingServiceAsync;
import it.eng.edison.usersurvey_portlet.client.SurveyHomePage;
import it.eng.edison.usersurvey_portlet.client.SurveyTable;
import it.eng.edison.usersurvey_portlet.client.model.SurveyModel;
import it.eng.edison.usersurvey_portlet.client.util.SurveyOptions;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class SurveyTable
extends Composite {
    private final GreetingServiceAsync rpcService = (GreetingServiceAsync)GWT.create(GreetingService.class);
    private CellTable<SurveyModel> table = new CellTable();
    private ListDataProvider<SurveyModel> dataProvider = new ListDataProvider();
    private List<SurveyOptions> optionsMap = new ArrayList();
    private List<String> options = new ArrayList();
    private SurveyHomePage surveyHp;

    public SurveyTable(SurveyHomePage surveyHp, List<SurveyModel> surveys) {
        this.surveyHp = surveyHp;
        this.dataProvider.setList(surveys);
        this.table.setVisibleRange(new Range(0, surveys.size()));
        this.dataProvider.addDataDisplay((HasData)this.table);
        this.table.setWidth("95%", false);
        this.table.setStriped(true);
        this.table.setBordered(true);
        this.table.setRowCount(surveys.size(), true);
        this.table.addStyleName("invitesTable");
        this.optionsMap.add(SurveyOptions.SELECT);
        this.optionsMap.add(SurveyOptions.GET_LINK);
        this.optionsMap.add(SurveyOptions.STATISTICS);
        this.optionsMap.add(SurveyOptions.MODIFY);
        this.optionsMap.add(SurveyOptions.DELETE);
        for (SurveyOptions opt : this.optionsMap) {
            this.options.add(opt.getDisplayLabel());
        }
        Column surveyName = this.getColumn((Cell)new TextCell(), (GetValue)new /* Unavailable Anonymous Inner Class!! */);
        Column surveyCreator = this.getColumn((Cell)new TextCell(), (GetValue)new /* Unavailable Anonymous Inner Class!! */);
        com.google.gwt.i18n.client.DateTimeFormat dateFormat = com.google.gwt.i18n.client.DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_MEDIUM);
        Column surveyCreateDate = this.getColumn((Cell)new DateCell((DateTimeFormat)dateFormat), (GetValue)new /* Unavailable Anonymous Inner Class!! */);
        Column surveyExpireDate = this.getColumn((Cell)new DateCell((DateTimeFormat)dateFormat), (GetValue)new /* Unavailable Anonymous Inner Class!! */);
        Column surveysFilled = this.getColumn((Cell)new NumberCell(), (GetValue)new /* Unavailable Anonymous Inner Class!! */);
        6 selectColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.table.addColumn(surveyName, "Survey name");
        this.table.addColumn(surveyCreator, "Created by");
        this.table.addColumn(surveyCreateDate, "Create date");
        this.table.addColumn(surveyExpireDate, "Expires on");
        this.table.addColumn(surveysFilled, "Filled Surveys");
        this.table.addColumn((Column)selectColumn, "Available options");
        surveyName.setSortable(true);
        ColumnSortEvent.ListHandler surveyTitleColHandler = new ColumnSortEvent.ListHandler(this.dataProvider.getList());
        surveyTitleColHandler.setComparator(surveyName, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.table.addColumnSortHandler((ColumnSortEvent.Handler)surveyTitleColHandler);
        surveyCreator.setSortable(true);
        ColumnSortEvent.ListHandler surveyCreatorColHandler = new ColumnSortEvent.ListHandler(this.dataProvider.getList());
        surveyCreatorColHandler.setComparator(surveyCreator, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.table.addColumnSortHandler((ColumnSortEvent.Handler)surveyCreatorColHandler);
        surveyCreateDate.setSortable(true);
        surveyCreateDate.setDefaultSortAscending(true);
        ColumnSortEvent.ListHandler dateColHandler = new ColumnSortEvent.ListHandler(this.dataProvider.getList());
        dateColHandler.setComparator(surveyCreateDate, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.table.addColumnSortHandler((ColumnSortEvent.Handler)dateColHandler);
        surveyExpireDate.setSortable(true);
        surveyExpireDate.setDefaultSortAscending(true);
        ColumnSortEvent.ListHandler dateExpiryColHandler = new ColumnSortEvent.ListHandler(this.dataProvider.getList());
        dateExpiryColHandler.setComparator(surveyExpireDate, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.table.addColumnSortHandler((ColumnSortEvent.Handler)dateExpiryColHandler);
        this.table.getColumnSortList().push(surveyCreateDate);
        this.initWidget((Widget)this.table);
    }

    private <C> Column<SurveyModel, C> getColumn(Cell<C> cell, GetValue<C> getter) {
        11 column = new /* Unavailable Anonymous Inner Class!! */;
        return column;
    }

    private void handleInviteSurvey(SurveyModel selectedSurvey, SelectElement select) {
        if (selectedSurvey.getExpiredDateSurvay().before(new Date())) {
            Window.alert((String)"Sorry, this survey is expired. You cannot invite any user to fill in an expired survey");
            select.setSelectedIndex(0);
            return;
        }
        this.rpcService.getSurveyInvitationLink(selectedSurvey.getIdsurvey(), selectedSurvey.getIsAnonymous().booleanValue(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void handleEditSurvey(SurveyModel selectedSurvey, SelectElement select) {
        this.surveyHp.getSurveyQuestionModelListModifySelectedSurvey().clear();
        this.surveyHp.surveySelected(selectedSurvey);
        select.setSelectedIndex(0);
        this.surveyHp.getQuestionsSurvey(selectedSurvey.getIdsurvey().intValue());
    }

    private void handleSeeSurveyStats(SurveyModel selectedSurvey, SelectElement select) {
        this.surveyHp.surveySelected(selectedSurvey);
        int number = this.surveyHp.getFilledSurveys().get(selectedSurvey.getIdsurvey()) == null ? 0 : (Integer)this.surveyHp.getFilledSurveys().get(selectedSurvey.getIdsurvey());
        GWT.log((String)("Stats" + number));
        if (number == 0) {
            Window.alert((String)"No VRE's member have partecipated to this survey, no statistics to show.");
            select.setSelectedIndex(0);
            return;
        }
        GWT.log((String)"Stats3");
        this.surveyHp.statView(selectedSurvey, this.surveyHp.getFilledSurveys());
    }

    private void handleDeleteSurvey(SurveyModel selectedSurvey, SelectElement select) {
        if (!Window.confirm((String)"Are you sure you want to delete this survey? \nThis action deletes VRE's members answers too.")) {
            select.setSelectedIndex(0);
            return;
        }
        this.rpcService.deleteSurvey(selectedSurvey, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ List access$000(SurveyTable x0) {
        return x0.optionsMap;
    }

    static /* synthetic */ void access$100(SurveyTable x0, SurveyModel x1, SelectElement x2) {
        x0.handleInviteSurvey(x1, x2);
    }

    static /* synthetic */ void access$200(SurveyTable x0, SurveyModel x1, SelectElement x2) {
        x0.handleSeeSurveyStats(x1, x2);
    }

    static /* synthetic */ void access$300(SurveyTable x0, SurveyModel x1, SelectElement x2) {
        x0.handleEditSurvey(x1, x2);
    }

    static /* synthetic */ void access$400(SurveyTable x0, SurveyModel x1, SelectElement x2) {
        x0.handleDeleteSurvey(x1, x2);
    }
}

