/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={OIDCTokenService.class})
public class OIDCTokenService {
    private static final Log _log = LogFactoryUtil.getLog(OIDCTokenService.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JSONObject exchangeToken(String tokenUrl, String accessToken, String context, String clientId, String clientSecret) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Exchanging token for context: " + context));
        }
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(tokenUrl);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("subject_token", accessToken));
        params.add(new BasicNameValuePair("client_id", clientId));
        params.add(new BasicNameValuePair("client_secret", clientSecret));
        params.add(new BasicNameValuePair("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange"));
        params.add(new BasicNameValuePair("subject_token_type", "urn:ietf:params:oauth:token-type:access_token"));
        params.add(new BasicNameValuePair("requested_token_type", "urn:ietf:params:oauth:token-type:access_token"));
        String encodedContext = context;
        if (context.startsWith("/")) {
            try {
                encodedContext = URLEncoder.encode(context, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                _log.error((Object)"Cannot URL encode context", (Throwable)e);
            }
        }
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
        httpPost.setHeader("X-D4Science-Context", encodedContext);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            String responseBody = EntityUtils.toString((HttpEntity)entity);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                JsonNode jsonNode = this.objectMapper.readTree(responseBody);
                JSONObject result = JSONFactoryUtil.createJSONObject();
                result.put("success", true);
                result.put("access_token", jsonNode.get("access_token").asText());
                if (jsonNode.has("refresh_token")) {
                    result.put("refresh_token", jsonNode.get("refresh_token").asText());
                }
                if (jsonNode.has("expires_in")) {
                    result.put("expires_in", jsonNode.get("expires_in").asInt());
                }
                result.put("token_url", tokenUrl);
                result.put("client_id", clientId);
                result.put("raw_token", responseBody);
                return result;
            }
            _log.error((Object)("Token exchange failed with status: " + statusCode + ", response: " + responseBody));
            JSONObject errorResult = JSONFactoryUtil.createJSONObject();
            errorResult.put("success", false);
            errorResult.put("error", "Token exchange failed");
            errorResult.put("status_code", statusCode);
            errorResult.put("message", responseBody);
            return errorResult;
        }
        catch (IOException e) {
            _log.error((Object)"Error during token exchange", (Throwable)e);
            JSONObject errorResult = JSONFactoryUtil.createJSONObject();
            errorResult.put("success", false);
            errorResult.put("error", "Network error during token exchange");
            errorResult.put("message", e.getMessage());
            return errorResult;
        }
    }

    public boolean isTokenValid(String token) {
        return token != null && !token.trim().isEmpty() && token.contains(".");
    }

    public JSONObject getTokenInfo(String token) {
        JSONObject info = JSONFactoryUtil.createJSONObject();
        if (!this.isTokenValid(token)) {
            info.put("valid", false);
            return info;
        }
        try {
            String[] parts = token.split("\\.");
            if (parts.length >= 2) {
                String payload = new String(Base64.getUrlDecoder().decode(parts[1]), StandardCharsets.UTF_8);
                JsonNode payloadNode = this.objectMapper.readTree(payload);
                info.put("valid", true);
                if (payloadNode.has("exp")) {
                    info.put("expires_at", payloadNode.get("exp").asLong());
                }
                if (payloadNode.has("aud")) {
                    info.put("audience", payloadNode.get("aud").asText());
                }
                if (payloadNode.has("sub")) {
                    info.put("subject", payloadNode.get("sub").asText());
                }
            }
        }
        catch (Exception e) {
            _log.warn((Object)"Could not parse token info", (Throwable)e);
            info.put("valid", false);
        }
        return info;
    }
}

