package org.gcube.portlets.admin.accountingmanager.server.amservice.query;

import java.text.ParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;

import org.gcube.accounting.aggregation.AggregatedJobUsageRecord;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.portlets.admin.accountingmanager.server.amservice.PeriodModeMap;
import org.gcube.portlets.admin.accountingmanager.shared.data.query.SeriesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.exception.AccountingManagerServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Accounting Query 4 Job
 * 
 * @author "Giancarlo Panichi" email: <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class AccountingQuery4Job extends AccountingQueryBuilder {
	protected static Logger logger = LoggerFactory
			.getLogger(AccountingQuery4Job.class);
	private SeriesRequest seriesRequest;

	public AccountingQuery4Job(SeriesRequest seriesRequest) {
		this.seriesRequest = seriesRequest;
	}

	@Override
	public void buildOpEx() throws AccountingManagerServiceException {
		
		Calendar startCalendar = GregorianCalendar.getInstance(TemporalConstraint.DEFAULT_TIME_ZONE);
		try {
			startCalendar.setTime(sdf.parse(seriesRequest.getAccountingPeriod().getStartDate()));
		} catch (ParseException e) {
			e.printStackTrace();
			throw new AccountingManagerServiceException("Start Date not valid!");
		}
		
		Calendar endCalendar = GregorianCalendar.getInstance(TemporalConstraint.DEFAULT_TIME_ZONE);
		try {
			endCalendar.setTime(sdf.parse(seriesRequest.getAccountingPeriod().getEndDate()));
		} catch (ParseException e) {
			e.printStackTrace();
			throw new AccountingManagerServiceException("End Date not valid!");
		}
		
		endCalendar.set(GregorianCalendar.HOUR_OF_DAY, 23);
		endCalendar.set(GregorianCalendar.MINUTE, 59);
		endCalendar.set(GregorianCalendar.SECOND, 59);
		endCalendar.set(GregorianCalendar.MILLISECOND, 999);
		
		
		TemporalConstraint temporalConstraint = new TemporalConstraint(
				startCalendar.getTimeInMillis(),
				endCalendar.getTimeInMillis(),
				PeriodModeMap.getMode(seriesRequest.getAccountingPeriod()
						.getPeriod()));

		AccountingQuery invocation = new AccountingQuery(
				AggregatedJobUsageRecord.class, temporalConstraint,null);

		accountingQuerySpec.setOp(invocation);

	}
}
