package org.gcube.portlets.admin.accountingmanager.server.amservice.response;

import java.util.List;

import org.gcube.accounting.analytics.Info;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.exception.AccountingManagerServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Series Response 4 Job
 * 
 * @author "Giancarlo Panichi" email: <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class SeriesResponse4Job extends SeriesResponseBuilder {
	protected static Logger logger = LoggerFactory
			.getLogger(SeriesResponse4Job.class);
	private List<Info> infos;

	public SeriesResponse4Job(List<Info> infos) {
		this.infos=infos;
	}

	@Override
	public void buildSeriesResponse() throws AccountingManagerServiceException {
		if(infos.size()<=0){
			logger.error("Error creating series for job accounting: No data available!");
			throw new AccountingManagerServiceException("No data available!");
		}

		SeriesResponse seriesResponse = new SeriesResponse();

		seriesResponseSpec.setSr(seriesResponse);

	}
}
