/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.client.filters;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.cell.core.client.ButtonCell;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell;
import com.sencha.gxt.core.client.Style;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.ModelKeyProvider;
import com.sencha.gxt.dnd.core.client.DND;
import com.sencha.gxt.dnd.core.client.DndDragStartEvent;
import com.sencha.gxt.dnd.core.client.GridDragSource;
import com.sencha.gxt.dnd.core.client.GridDropTarget;
import com.sencha.gxt.widget.core.client.button.ButtonBar;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.event.BeforeStartEditEvent;
import com.sencha.gxt.widget.core.client.event.CancelEditEvent;
import com.sencha.gxt.widget.core.client.event.CompleteEditEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.form.FieldSet;
import com.sencha.gxt.widget.core.client.form.IsField;
import com.sencha.gxt.widget.core.client.form.StringComboBox;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;
import com.sencha.gxt.widget.core.client.grid.GridSelectionModel;
import com.sencha.gxt.widget.core.client.grid.editing.GridRowEditing;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.portlets.admin.accountingmanager.client.event.StateChangeEvent;
import org.gcube.portlets.admin.accountingmanager.client.filters.ActiveFiltersPanel;
import org.gcube.portlets.admin.accountingmanager.client.properties.AccountingFilterProperties;
import org.gcube.portlets.admin.accountingmanager.client.resource.AccountingManagerResources;
import org.gcube.portlets.admin.accountingmanager.client.rpc.AccountingManagerServiceAsync;
import org.gcube.portlets.admin.accountingmanager.client.state.AccountingStateData;
import org.gcube.portlets.admin.accountingmanager.client.utils.UtilsGXT3;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilter;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterKey;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValuesRequest;

public class ActiveFiltersPanel
extends SimpleContainer {
    private EventBus eventBus;
    private Grid<AccountingFilter> grid;
    private ListStore<AccountingFilter> store;
    private boolean addStatus;
    private AccountingStateData accountingStateData;
    private ListStore<FilterKey> storeComboFilterKey;
    private ComboBox<FilterKey> comboFilterKey;
    private ListStore<String> storeComboFilterValue;
    private StringComboBox comboFilterValue;
    private GridRowEditing<AccountingFilter> editing;
    private TextButton addButton;
    private int seq;

    public ActiveFiltersPanel(EventBus eventBus) {
        Log.debug((String)"ActiveFiltersPanel");
        this.eventBus = eventBus;
        this.init();
        this.create();
        this.bindToEvents();
    }

    private void init() {
    }

    private void create() {
        AccountingFilterProperties props = (AccountingFilterProperties)GWT.create(AccountingFilterProperties.class);
        ColumnConfig keyColumn = new ColumnConfig(props.filterKey(), 130, "Key");
        keyColumn.setMenuDisabled(true);
        keyColumn.setCell((Cell)new /* Unavailable Anonymous Inner Class!! */);
        ColumnConfig valueColumn = new ColumnConfig(props.filterValue(), 130, "Value");
        valueColumn.setMenuDisabled(true);
        valueColumn.setCell((Cell)new /* Unavailable Anonymous Inner Class!! */);
        ArrayList<ColumnConfig> l = new ArrayList<ColumnConfig>();
        l.add(keyColumn);
        l.add(valueColumn);
        ColumnModel columns = new ColumnModel(l);
        this.store = new ListStore(props.id());
        GridSelectionModel sm = new GridSelectionModel();
        sm.setSelectionMode(Style.SelectionMode.SINGLE);
        this.grid = new Grid(this.store, columns);
        this.grid.setSelectionModel(sm);
        this.grid.getView().setStripeRows(true);
        this.grid.getView().setColumnLines(true);
        this.grid.getView().setAutoFill(true);
        this.grid.setBorders(false);
        this.grid.setColumnReordering(false);
        this.grid.getView().setAutoExpandColumn(valueColumn);
        this.grid.getView().setSortingEnabled(false);
        GridDragSource ds = new GridDragSource(this.grid);
        ds.addDragStartHandler((DndDragStartEvent.DndDragStartHandler)new /* Unavailable Anonymous Inner Class!! */);
        GridDropTarget dt = new GridDropTarget(this.grid);
        dt.setFeedback(DND.Feedback.BOTH);
        dt.setAllowSelfAsSource(true);
        FilterKeyPropertiesCombo filterKeyPropertiesCombo = (FilterKeyPropertiesCombo)GWT.create(FilterKeyPropertiesCombo.class);
        this.storeComboFilterKey = new ListStore(filterKeyPropertiesCombo.id());
        this.comboFilterKey = new ComboBox(this.storeComboFilterKey, filterKeyPropertiesCombo.key());
        this.comboFilterKey.setClearValueOnParseError(false);
        this.comboFilterKey.setEditable(false);
        this.comboFilterKey.setTriggerAction(ComboBoxCell.TriggerAction.ALL);
        this.addHandlersForComboFilterKey(filterKeyPropertiesCombo.key());
        this.storeComboFilterValue = new ListStore((ModelKeyProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.comboFilterValue = new StringComboBox();
        this.comboFilterValue.setStore(this.storeComboFilterValue);
        this.comboFilterValue.setClearValueOnParseError(false);
        this.comboFilterValue.setEditable(true);
        this.comboFilterValue.setForceSelection(false);
        this.comboFilterValue.setTriggerAction(ComboBoxCell.TriggerAction.ALL);
        this.editing = new GridRowEditing(this.grid);
        this.editing.addEditor(keyColumn, (IsField)this.comboFilterKey);
        this.editing.addEditor(valueColumn, (IsField)this.comboFilterValue);
        this.addButton = new TextButton("Add Filter");
        this.addButton.setIcon(AccountingManagerResources.INSTANCE.accountingFilter24());
        this.addButton.setIconAlign(ButtonCell.IconAlign.RIGHT);
        this.addButton.setToolTip("Add Filter");
        this.addButton.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        TextButton deleteBtn = new TextButton("Delete");
        deleteBtn.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        ButtonBar buttonBar = this.editing.getButtonBar();
        buttonBar.add((Widget)deleteBtn);
        this.editing.addBeforeStartEditHandler((BeforeStartEditEvent.BeforeStartEditHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.editing.addCancelEditHandler((CancelEditEvent.CancelEditHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.editing.addCompleteEditHandler((CompleteEditEvent.CompleteEditHandler)new /* Unavailable Anonymous Inner Class!! */);
        ToolBar toolBar = new ToolBar();
        toolBar.add((IsWidget)this.addButton, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        VerticalLayoutContainer vlc = new VerticalLayoutContainer();
        vlc.add((IsWidget)toolBar, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        vlc.add((IsWidget)this.grid, new VerticalLayoutContainer.VerticalLayoutData(1.0, 1.0, new Margins(0)));
        FieldSet fieldSet = new FieldSet();
        fieldSet.setHeadingHtml("<b>Active Filters</b>");
        fieldSet.setCollapsible(false);
        fieldSet.add((Widget)vlc);
        this.add((Widget)fieldSet, new MarginData(0));
    }

    private void bindToEvents() {
        this.eventBus.addHandler(StateChangeEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doStateChangeCommand(StateChangeEvent event) {
        if (event.getStateChangeType() == null) {
            return;
        }
        switch (13.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$type$StateChangeType[event.getStateChangeType().ordinal()]) {
            case 1: {
                this.onRestoreStateChange(event);
                break;
            }
            case 2: {
                break;
            }
        }
    }

    private void onRestoreStateChange(StateChangeEvent event) {
        if (event.getAccountingStateData() != null) {
            this.accountingStateData = event.getAccountingStateData();
            this.changeActiveFilters();
        } else {
            this.accountingStateData = null;
            this.seq = 0;
        }
        Log.debug((String)("Set seq to: " + this.seq));
        this.forceLayout();
    }

    private void changeActiveFilters() {
        this.storeComboFilterKey.clear();
        this.storeComboFilterKey.addAll((Collection)this.accountingStateData.getAvailableFilterKeys());
        this.storeComboFilterKey.commitChanges();
        if (this.accountingStateData.getSeriesRequest() != null && this.accountingStateData.getSeriesRequest().getFilters() != null) {
            ArrayList filters = this.accountingStateData.getSeriesRequest().getFilters();
            this.store.clear();
            this.store.addAll((Collection)filters);
            this.seq = 0;
            for (AccountingFilter filter : filters) {
                if (filter.getId() <= this.seq) continue;
                this.seq = filter.getId();
            }
            this.store.commitChanges();
        } else {
            this.store.clear();
            this.store.commitChanges();
            this.seq = 0;
        }
    }

    public ArrayList<AccountingFilter> getActiveFilters() {
        try {
            if (this.store == null || this.store.size() <= 0) {
                return null;
            }
            List filtersActives = this.store.getAll();
            ArrayList<AccountingFilter> filtersReady = new ArrayList<AccountingFilter>();
            for (AccountingFilter filter : filtersActives) {
                if (filter.getFilterValue() == null || filter.getFilterValue().isEmpty()) continue;
                filtersReady.add(filter);
            }
            if (filtersReady.size() > 0) {
                return filtersReady;
            }
            return null;
        }
        catch (Throwable e) {
            Log.error((String)e.getLocalizedMessage());
            e.printStackTrace();
            UtilsGXT3.alert((String)"Attention", (String)e.getLocalizedMessage());
            return null;
        }
    }

    private void addNewFilter(SelectEvent event) {
        List filtersSet = this.store.getAll();
        FilterKey fk = null;
        if (this.accountingStateData == null || this.accountingStateData.getAvailableFilterKeys() == null || this.accountingStateData.getAvailableFilterKeys().size() < 0) {
            UtilsGXT3.info((String)"No key available", (String)"No key available");
        } else {
            ArrayList remainingFilterKeys = new ArrayList(this.accountingStateData.getAvailableFilterKeys());
            ArrayList<FilterKey> removableFilterKeys = new ArrayList<FilterKey>();
            for (AccountingFilter filterSet : filtersSet) {
                removableFilterKeys.add(filterSet.getFilterKey());
            }
            remainingFilterKeys.removeAll(removableFilterKeys);
            if (remainingFilterKeys.size() > 0) {
                fk = (FilterKey)remainingFilterKeys.get(0);
                ++this.seq;
                AccountingFilter newAccountingFilter = new AccountingFilter(this.seq, fk, "");
                Log.debug((String)("newAccountingFilter: " + newAccountingFilter));
                this.editing.cancelEditing();
                this.addStatus = true;
                this.editing.getCancelButton().setVisible(false);
                this.store.add((Object)newAccountingFilter);
                int row = this.store.indexOf((Object)newAccountingFilter);
                this.storeComboFilterKey.clear();
                this.storeComboFilterKey.addAll(remainingFilterKeys);
                this.storeComboFilterKey.commitChanges();
                this.editing.startEditing(new Grid.GridCell(row, 0));
            } else {
                UtilsGXT3.info((String)"No key available", (String)"No key available");
            }
        }
    }

    private void retrieveFilterValuesByKey(FilterKey filterKey, boolean cancelValue) {
        FilterValuesRequest requestFilterValue = new FilterValuesRequest(filterKey, this.accountingStateData.getAccountingType());
        AccountingManagerServiceAsync.INSTANCE.getFilterValues(requestFilterValue, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void editingBeforeStart(BeforeStartEditEvent<AccountingFilter> event) {
        Grid.GridCell cell = event.getEditCell();
        int rowIndex = cell.getRow();
        AccountingFilter editingFilter = (AccountingFilter)this.store.get(rowIndex);
        List filtersSet = this.store.getAll();
        ArrayList remainingFilterKeys = null;
        remainingFilterKeys = this.accountingStateData == null || this.accountingStateData.getAvailableFilterKeys() == null ? new ArrayList() : new ArrayList(this.accountingStateData.getAvailableFilterKeys());
        ArrayList<FilterKey> setFilterKeys = new ArrayList<FilterKey>();
        for (AccountingFilter filterSet : filtersSet) {
            if (filterSet.getFilterKey().getKey().compareTo(editingFilter.getFilterKey().getKey()) == 0) continue;
            setFilterKeys.add(filterSet.getFilterKey());
        }
        remainingFilterKeys.removeAll(setFilterKeys);
        this.storeComboFilterKey.clear();
        this.storeComboFilterKey.addAll(remainingFilterKeys);
        this.storeComboFilterKey.commitChanges();
        if (editingFilter.getFilterKey() != null) {
            this.retrieveFilterValuesByKey(editingFilter.getFilterKey(), false);
        }
        this.addButton.setEnabled(false);
    }

    private void addHandlersForComboFilterKey(LabelProvider<FilterKey> labelProvider) {
        this.comboFilterKey.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateFilterKey(FilterKey selectedFilterKey) {
        this.retrieveFilterValuesByKey(selectedFilterKey, true);
    }

    static /* synthetic */ void access$000(ActiveFiltersPanel x0, SelectEvent x1) {
        x0.addNewFilter(x1);
    }

    static /* synthetic */ GridRowEditing access$100(ActiveFiltersPanel x0) {
        return x0.editing;
    }

    static /* synthetic */ ListStore access$200(ActiveFiltersPanel x0) {
        return x0.store;
    }

    static /* synthetic */ TextButton access$300(ActiveFiltersPanel x0) {
        return x0.addButton;
    }

    static /* synthetic */ boolean access$400(ActiveFiltersPanel x0) {
        return x0.addStatus;
    }

    static /* synthetic */ boolean access$402(ActiveFiltersPanel x0, boolean x1) {
        x0.addStatus = x1;
        return x0.addStatus;
    }

    static /* synthetic */ void access$500(ActiveFiltersPanel x0, BeforeStartEditEvent x1) {
        x0.editingBeforeStart(x1);
    }

    static /* synthetic */ void access$600(ActiveFiltersPanel x0, StateChangeEvent x1) {
        x0.doStateChangeCommand(x1);
    }

    static /* synthetic */ EventBus access$700(ActiveFiltersPanel x0) {
        return x0.eventBus;
    }

    static /* synthetic */ StringComboBox access$800(ActiveFiltersPanel x0) {
        return x0.comboFilterValue;
    }

    static /* synthetic */ ListStore access$900(ActiveFiltersPanel x0) {
        return x0.storeComboFilterValue;
    }

    static /* synthetic */ void access$1000(ActiveFiltersPanel x0, FilterKey x1) {
        x0.updateFilterKey(x1);
    }
}

