/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.command;

import java.util.ArrayList;
import java.util.List;
import org.gcube.accounting.analytics.ResourceRecordQuery;
import org.gcube.accounting.datamodel.aggregation.AggregatedJobUsageRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedServiceUsageRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedStorageUsageRecord;
import org.gcube.portlets.admin.accountingmanager.server.amservice.command.AccountingCommand;
import org.gcube.portlets.admin.accountingmanager.server.amservice.command.AccountingCommandGetFilterKeys;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingType;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterKey;
import org.gcube.portlets.admin.accountingmanager.shared.exception.AccountingManagerServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingCommandGetFilterKeys
implements AccountingCommand<ArrayList<FilterKey>> {
    private static final Logger logger = LoggerFactory.getLogger(AccountingCommandGetFilterKeys.class);
    private AccountingType accountingType;

    public AccountingCommandGetFilterKeys(AccountingType accountingType) {
        this.accountingType = accountingType;
    }

    public ArrayList<FilterKey> execute() throws AccountingManagerServiceException {
        try {
            List keys;
            logger.debug("getFilterKeys(): [AccountingType=" + this.accountingType + "]");
            if (this.accountingType == null) {
                return new ArrayList<FilterKey>();
            }
            ArrayList<FilterKey> filterKeys = new ArrayList<FilterKey>();
            ResourceRecordQuery rrq = new ResourceRecordQuery();
            switch (1.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$AccountingType[this.accountingType.ordinal()]) {
                case 1: {
                    keys = rrq.getKeys(AggregatedJobUsageRecord.class);
                    break;
                }
                case 2: {
                    return filterKeys;
                }
                case 3: {
                    keys = rrq.getKeys(AggregatedServiceUsageRecord.class);
                    break;
                }
                case 4: {
                    keys = rrq.getKeys(AggregatedStorageUsageRecord.class);
                    break;
                }
                case 5: {
                    return filterKeys;
                }
                default: {
                    return filterKeys;
                }
            }
            for (String key : keys) {
                if (key == null || key.isEmpty()) continue;
                filterKeys.add(new FilterKey(key));
            }
            logger.debug("List FilterKeys:" + filterKeys);
            return filterKeys;
        }
        catch (Throwable e) {
            logger.error("Error in AccountingCommandGetFilterKeys(): " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new AccountingManagerServiceException("No keys available!");
        }
    }
}

