/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.response;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.SortedMap;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.Info;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponseBuilder;
import org.gcube.portlets.admin.accountingmanager.shared.data.Context;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesTask;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.task.SeriesTaskContext;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.task.SeriesTaskDataContext;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.task.SeriesTaskDefinition;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeriesResponse4TaskContext
extends SeriesResponseBuilder {
    protected static Logger logger = LoggerFactory.getLogger(SeriesResponse4TaskContext.class);
    private Context context;
    private SortedMap<Filter, SortedMap<Calendar, Info>> contextSM;

    public SeriesResponse4TaskContext(Context context, SortedMap<Filter, SortedMap<Calendar, Info>> contextSM) {
        this.context = context;
        this.contextSM = contextSM;
    }

    public void buildSeriesResponse() throws ServiceException {
        try {
            if (this.contextSM == null || this.contextSM.isEmpty()) {
                logger.error("Error creating series for task accounting: No data available!");
                throw new ServiceException("No data available!");
            }
            ArrayList<SeriesTaskDataContext> seriesTaskDataContextList = new ArrayList<SeriesTaskDataContext>();
            for (Filter contextValue : this.contextSM.keySet()) {
                ArrayList series = new ArrayList();
                SortedMap infos = (SortedMap)this.contextSM.get(contextValue);
                for (Info info : infos.values()) {
                    JSONObject jSONObject = info.getValue();
                }
                SeriesTaskDataContext seriesTaskDataContext = new SeriesTaskDataContext(contextValue.getValue(), series);
                seriesTaskDataContextList.add(seriesTaskDataContext);
            }
            SeriesTaskContext seriesTaskContext = new SeriesTaskContext(this.context, seriesTaskDataContextList);
            SeriesTask seriesTask = new SeriesTask((SeriesTaskDefinition)seriesTaskContext);
            this.seriesResponseSpec.setSr((SeriesResponse)seriesTask);
        }
        catch (Throwable e) {
            logger.error("Error creating series for portlet accounting context chart: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException("Error creating series for portlet accounting context chart: " + e.getLocalizedMessage());
        }
    }
}

