/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.client.maindata.charts.service;

import com.allen_sauer.gwt.log.client.Log;
import com.github.highcharts4gwt.client.view.widget.HighchartsLayoutPanel;
import com.github.highcharts4gwt.model.array.api.Array;
import com.github.highcharts4gwt.model.array.api.ArrayNumber;
import com.github.highcharts4gwt.model.array.api.ArrayString;
import com.github.highcharts4gwt.model.factory.jso.JsoHighchartsOptionFactory;
import com.github.highcharts4gwt.model.highcharts.option.api.ChartOptions;
import com.github.highcharts4gwt.model.highcharts.option.api.SeriesArea;
import com.github.highcharts4gwt.model.highcharts.option.api.SeriesColumn;
import com.github.highcharts4gwt.model.highcharts.option.api.seriesarea.point.ClickHandler;
import com.github.highcharts4gwt.model.highcharts.option.api.seriescolumn.Data;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.cell.core.client.ButtonCell;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.button.ToggleButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.menu.Menu;
import com.sencha.gxt.widget.core.client.menu.MenuItem;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;
import java.util.Date;
import org.gcube.portlets.admin.accountingmanager.client.event.ExportRequestEvent;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.utils.ChartTimeMeasure;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.utils.ServiceChartMeasure;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.utils.TimeUnitMeasure;
import org.gcube.portlets.admin.accountingmanager.client.resource.AccountingManagerResources;
import org.gcube.portlets.admin.accountingmanager.client.state.AccountingClientStateData;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingPeriod;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingPeriodMode;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesService;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.service.SeriesServiceBasic;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.service.SeriesServiceData;
import org.gcube.portlets.admin.accountingmanager.shared.export.ExportType;

public class ServiceChartBasicPanel
extends SimpleContainer {
    private DateTimeFormat dtf = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.YEAR_MONTH_DAY);
    private static final String TIME_UNIT = "Time Unit";
    private static final String SINGLE_AXIS = "Single Axis";
    private EventBus eventBus;
    private AccountingClientStateData accountingStateData;
    private HighchartsLayoutPanel highchartsLayoutPanel;
    private MenuItem downloadCSVItem;
    private MenuItem downloadXMLItem;
    private MenuItem downloadJSONItem;
    private MenuItem downloadPNGItem;
    private MenuItem downloadJPGItem;
    private MenuItem downloadPDFItem;
    private MenuItem downloadSVGItem;
    private MenuItem msItem;
    private MenuItem sItem;
    private MenuItem mItem;
    private MenuItem hItem;
    private ChartOptions options;
    private VerticalLayoutContainer vert;
    private long unitMeasure = TimeUnitMeasure.getMilliseconds();
    private String unitMeasureLabel = "ms";
    private TextButton unitButton;
    private ToggleButton toggleButton;

    public ServiceChartBasicPanel(EventBus eventBus, AccountingClientStateData accountingStateData) {
        this.eventBus = eventBus;
        this.accountingStateData = accountingStateData;
        this.forceLayoutOnResize = true;
        this.create();
    }

    private void create() {
        ToolBar toolBar = new ToolBar();
        toolBar.setSpacing(2);
        TextButton downloadButton = new TextButton("Download", AccountingManagerResources.INSTANCE.accountingDownload24());
        downloadButton.setIconAlign(ButtonCell.IconAlign.RIGHT);
        downloadButton.setArrowAlign(ButtonCell.ButtonArrowAlign.RIGHT);
        downloadButton.setMenu(this.createDownloadMenu());
        this.unitButton = new TextButton(TIME_UNIT, AccountingManagerResources.INSTANCE.accountingUnitms24());
        this.unitButton.setIconAlign(ButtonCell.IconAlign.RIGHT);
        this.unitButton.setArrowAlign(ButtonCell.ButtonArrowAlign.RIGHT);
        this.unitButton.setMenu(this.createUnitMenu());
        this.toggleButton = new ToggleButton(SINGLE_AXIS);
        this.toggleButton.setIcon(AccountingManagerResources.INSTANCE.accountingChartVariableAxis24());
        this.toggleButton.setIconAlign(ButtonCell.IconAlign.RIGHT);
        this.toggleButton.setValue((Object)false);
        this.toggleButton.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        toolBar.add((IsWidget)downloadButton, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        toolBar.add((IsWidget)this.unitButton, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        toolBar.add((IsWidget)this.toggleButton, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        this.createMultiAxisChart();
        this.highchartsLayoutPanel = new HighchartsLayoutPanel();
        this.highchartsLayoutPanel.renderChart(this.options);
        this.vert = new VerticalLayoutContainer();
        this.vert.add((IsWidget)toolBar, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        this.vert.add((IsWidget)this.highchartsLayoutPanel, new VerticalLayoutContainer.VerticalLayoutData(1.0, 1.0, new Margins(0)));
        this.add((Widget)this.vert, new MarginData(0));
    }

    private void updateChart() {
        if (((Boolean)this.toggleButton.getValue()).booleanValue()) {
            this.createSingleAxisChart();
            this.highchartsLayoutPanel.renderChart(this.options);
        } else {
            this.createMultiAxisChart();
            this.highchartsLayoutPanel.renderChart(this.options);
        }
        this.forceLayout();
    }

    private Menu createUnitMenu() {
        Menu menuUnit = new Menu();
        this.msItem = new MenuItem("Milliseconds", AccountingManagerResources.INSTANCE.accountingUnitms24());
        this.msItem.setHeight(30);
        this.sItem = new MenuItem("Seconds", AccountingManagerResources.INSTANCE.accountingUnits24());
        this.sItem.setHeight(30);
        this.mItem = new MenuItem("Minutes", AccountingManagerResources.INSTANCE.accountingUnitm24());
        this.mItem.setHeight(30);
        this.hItem = new MenuItem("Hours", AccountingManagerResources.INSTANCE.accountingUnith24());
        this.hItem.setHeight(30);
        this.msItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.sItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.mItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.hItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        menuUnit.add((Widget)this.msItem);
        menuUnit.add((Widget)this.sItem);
        menuUnit.add((Widget)this.mItem);
        menuUnit.add((Widget)this.hItem);
        return menuUnit;
    }

    private Menu createDownloadMenu() {
        Menu menuDownload = new Menu();
        this.downloadCSVItem = new MenuItem("Download CSV", AccountingManagerResources.INSTANCE.accountingFileCSV24());
        this.downloadCSVItem.setHeight(30);
        this.downloadXMLItem = new MenuItem("Download XML", AccountingManagerResources.INSTANCE.accountingFileXML24());
        this.downloadXMLItem.setHeight(30);
        this.downloadJSONItem = new MenuItem("Download JSON", AccountingManagerResources.INSTANCE.accountingFileJSON24());
        this.downloadJSONItem.setHeight(30);
        this.downloadPNGItem = new MenuItem("Download PNG Image", AccountingManagerResources.INSTANCE.accountingFilePNG24());
        this.downloadPNGItem.setHeight(30);
        this.downloadJPGItem = new MenuItem("Download JPG Image", AccountingManagerResources.INSTANCE.accountingFileJPG24());
        this.downloadJPGItem.setHeight(30);
        this.downloadPDFItem = new MenuItem("Download PDF Document", AccountingManagerResources.INSTANCE.accountingFilePDF24());
        this.downloadPDFItem.setHeight(30);
        this.downloadSVGItem = new MenuItem("Download SVG Vector Image", AccountingManagerResources.INSTANCE.accountingFileSVG24());
        this.downloadSVGItem.setHeight(30);
        this.downloadCSVItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadXMLItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadJSONItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadPNGItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadJPGItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadPDFItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadSVGItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        menuDownload.add((Widget)this.downloadCSVItem);
        menuDownload.add((Widget)this.downloadXMLItem);
        menuDownload.add((Widget)this.downloadJSONItem);
        menuDownload.add((Widget)this.downloadPNGItem);
        menuDownload.add((Widget)this.downloadJPGItem);
        menuDownload.add((Widget)this.downloadPDFItem);
        menuDownload.add((Widget)this.downloadSVGItem);
        return menuDownload;
    }

    private void onDownloadCSV() {
        ExportRequestEvent event = new ExportRequestEvent(ExportType.CSV, this.accountingStateData.getAccountingType());
        this.eventBus.fireEvent((GwtEvent)event);
    }

    private void onDownloadXML() {
        ExportRequestEvent event = new ExportRequestEvent(ExportType.XML, this.accountingStateData.getAccountingType());
        this.eventBus.fireEvent((GwtEvent)event);
    }

    private void onDownloadJSON() {
        ExportRequestEvent event = new ExportRequestEvent(ExportType.JSON, this.accountingStateData.getAccountingType());
        this.eventBus.fireEvent((GwtEvent)event);
    }

    public static native void onDownloadPNG(String var0);

    public static native void onDownloadJPG(String var0);

    public static native void onDownloadPDF(String var0);

    public static native void onDownloadSVG(String var0);

    private void createMultiAxisChart() {
        SeriesService seriesService = (SeriesService)this.accountingStateData.getSeriesResponse();
        if (!(seriesService.getSerieServiceDefinition() instanceof SeriesServiceBasic)) {
            Log.error((String)"Invalid SeriesServiceBasic!");
            return;
        }
        SeriesServiceBasic seriesServiceBasic = (SeriesServiceBasic)seriesService.getSerieServiceDefinition();
        JsoHighchartsOptionFactory highchartsFactory = new JsoHighchartsOptionFactory();
        this.options = highchartsFactory.createChartOptions();
        this.options.chart().zoomType("xy");
        this.options.navigation().buttonOptions().enabled(false);
        this.options.exporting().filename("AccountingServiceBasic");
        this.options.title().text("Accounting Service");
        ArrayString colors = this.options.colors();
        String multiAxis = "[{ \"id\": \"" + ServiceChartMeasure.OperationCount.name() + "\"," + " \"labels\": { " + "    \"format\": \"{value}\"," + "    \"style\": { " + "      \"color\": \"" + colors.get(1) + "\"" + "    }" + " }," + " \"title\": { " + "    \"text\": \"" + ServiceChartMeasure.OperationCount.getLabel() + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "    }" + " }" + "} , {" + " \"id\": \"" + ServiceChartMeasure.Duration.name() + "\", " + " \"title\": {" + "    \"text\": \"" + ServiceChartMeasure.Duration.getLabel() + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(0) + "\"" + "    }" + " }," + " \"labels\": {" + "    \"format\": \"{value} " + this.unitMeasureLabel + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(0) + "\"" + "     }" + " }," + " \"opposite\": \"true\"" + ", \"showFirstLabel\": \"false\"" + "} , {" + " \"id\": \"" + ServiceChartMeasure.MaxInvocationTime.name() + "\", " + " \"title\": {" + "    \"text\": \"" + ServiceChartMeasure.MaxInvocationTime.getLabel() + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(2) + "\"" + "    }" + " }," + " \"labels\": {" + "    \"format\": \"{value} " + this.unitMeasureLabel + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(2) + "\"" + "     }" + " }," + " \"opposite\": \"true\"" + ", \"showFirstLabel\": \"false\"" + "} , {" + " \"id\": \"" + ServiceChartMeasure.MinInvocationTime.name() + "\", " + " \"title\": {" + "    \"text\": \"" + ServiceChartMeasure.MinInvocationTime.getLabel() + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(3) + "\"" + "    }" + " }," + " \"labels\": {" + "    \"format\": \"{value} " + this.unitMeasureLabel + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(3) + "\"" + "     }" + " }," + " \"opposite\": \"true\"" + ", \"showFirstLabel\": \"false\"" + "}]";
        this.options.setFieldAsJsonObject("yAxis", multiAxis);
        String fillcolor = "{\"linearGradient\": {\"x1\": 0,\"y1\": 0,\"x2\": 0,\"y2\": 1},\"stops\": [[0, \"#058DC7\"],[1, \"#FFFFFF\"]]}";
        this.options.plotOptions().area().setFieldAsJsonObject("fillColor", fillcolor).marker().radius(2.0).lineWidth(1.0).states().hover().lineWidth(1.0);
        SeriesColumn seriesOperationCount = highchartsFactory.createSeriesColumn();
        seriesOperationCount.name(ServiceChartMeasure.OperationCount.getLabel());
        seriesOperationCount.color(colors.get(1));
        seriesOperationCount.type("column");
        seriesOperationCount.point().addClickHandler((com.github.highcharts4gwt.model.highcharts.option.api.seriescolumn.point.ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        SeriesArea seriesDuration = highchartsFactory.createSeriesArea();
        seriesDuration.name(ServiceChartMeasure.Duration.getLabel());
        seriesDuration.color(colors.get(0));
        seriesDuration.yAxisAsString(ServiceChartMeasure.Duration.name());
        seriesDuration.point().addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        SeriesArea seriesMaxInvocationTime = highchartsFactory.createSeriesArea();
        seriesMaxInvocationTime.name(ServiceChartMeasure.MaxInvocationTime.getLabel());
        seriesMaxInvocationTime.color(colors.get(2));
        seriesMaxInvocationTime.yAxisAsString(ServiceChartMeasure.MaxInvocationTime.name());
        seriesMaxInvocationTime.point().addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        SeriesArea seriesMinInvocationTime = highchartsFactory.createSeriesArea();
        seriesMinInvocationTime.name(ServiceChartMeasure.MinInvocationTime.getLabel());
        seriesMinInvocationTime.color(colors.get(3));
        seriesMinInvocationTime.yAxisAsString(ServiceChartMeasure.MinInvocationTime.name());
        seriesMinInvocationTime.point().addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        if (this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.DAILY) == 0 || this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.HOURLY) == 0 || this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.MINUTELY) == 0) {
            double minRange = ChartTimeMeasure.calculateMinRange((AccountingPeriod)this.accountingStateData.getSeriesRequest().getAccountingPeriod());
            double interval = ChartTimeMeasure.calculateInterval((AccountingPeriod)this.accountingStateData.getSeriesRequest().getAccountingPeriod());
            Date dateStart = this.dtf.parse(this.accountingStateData.getSeriesRequest().getAccountingPeriod().getStartDate());
            dateStart.setTime(dateStart.getTime() + ChartTimeMeasure.timeZoneOffset() * 60000L);
            Log.debug((String)("BuildChart DateStart: " + DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_FULL).format(dateStart)));
            this.options.xAxis().type("datetime");
            this.options.xAxis().minRange(minRange);
            this.options.tooltip().xDateFormat("Selected Data");
            ArrayNumber dataOperationCount = seriesOperationCount.dataAsArrayNumber();
            seriesOperationCount.pointInterval(interval);
            seriesOperationCount.pointStart((double)dateStart.getTime());
            ArrayNumber dataDuration = seriesDuration.dataAsArrayNumber();
            seriesDuration.pointInterval(interval);
            seriesDuration.pointStart((double)dateStart.getTime());
            ArrayNumber dataMaxInvocationTime = seriesMaxInvocationTime.dataAsArrayNumber();
            seriesMaxInvocationTime.pointInterval(interval);
            seriesMaxInvocationTime.pointStart((double)dateStart.getTime());
            ArrayNumber dataMinInvocationTime = seriesMinInvocationTime.dataAsArrayNumber();
            seriesMinInvocationTime.pointInterval(interval);
            seriesMinInvocationTime.pointStart((double)dateStart.getTime());
            for (SeriesServiceData seriesServiceData : seriesServiceBasic.getSeries()) {
                dataOperationCount.push((double)seriesServiceData.getOperationCount().longValue());
                dataDuration.push((double)(seriesServiceData.getDuration() / this.unitMeasure));
                dataMaxInvocationTime.push((double)(seriesServiceData.getMaxInvocationTime() / this.unitMeasure));
                dataMinInvocationTime.push((double)(seriesServiceData.getMinInvocationTime() / this.unitMeasure));
            }
        } else {
            this.options.xAxis().type("datetime");
            if (this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.MONTHLY) == 0) {
                this.options.tooltip().xDateFormat("Selected Data");
            } else if (this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.YEARLY) == 0) {
                this.options.tooltip().xDateFormat("Selected Data");
            } else {
                this.options.tooltip().xDateFormat("Selected Data");
            }
            Array arrayDataOperationCount = seriesOperationCount.dataAsArrayObject();
            Array arrayDataDuration = seriesDuration.dataAsArrayObject();
            Array arrayDataMaxInvocationTime = seriesMaxInvocationTime.dataAsArrayObject();
            Array arrayDataMinInvocationTime = seriesMinInvocationTime.dataAsArrayObject();
            for (SeriesServiceData seriesServiceData : seriesServiceBasic.getSeries()) {
                long dateFrom1970 = seriesServiceData.getDate().getTime();
                Log.debug((String)("SeriersServiceData: " + seriesServiceData.getDate()));
                Log.debug((String)("SeriersServiceData: " + dateFrom1970));
                Data dataOperationCount = highchartsFactory.createSeriesColumnData();
                dataOperationCount.x((double)dateFrom1970);
                dataOperationCount.y((double)seriesServiceData.getOperationCount().longValue());
                arrayDataOperationCount.addToEnd((Object)dataOperationCount);
                com.github.highcharts4gwt.model.highcharts.option.api.seriesarea.Data dataDuration = highchartsFactory.createSeriesAreaData();
                dataDuration.x((double)dateFrom1970);
                dataDuration.y((double)(seriesServiceData.getDuration() / this.unitMeasure));
                arrayDataDuration.addToEnd((Object)dataDuration);
                com.github.highcharts4gwt.model.highcharts.option.api.seriesarea.Data dataMaxInvocationTime = highchartsFactory.createSeriesAreaData();
                dataMaxInvocationTime.x((double)dateFrom1970);
                dataMaxInvocationTime.y((double)(seriesServiceData.getMaxInvocationTime() / this.unitMeasure));
                arrayDataMaxInvocationTime.addToEnd((Object)dataMaxInvocationTime);
                com.github.highcharts4gwt.model.highcharts.option.api.seriesarea.Data dataMinInvocationTime = highchartsFactory.createSeriesAreaData();
                dataMinInvocationTime.x((double)dateFrom1970);
                dataMinInvocationTime.y((double)(seriesServiceData.getMinInvocationTime() / this.unitMeasure));
                arrayDataMinInvocationTime.addToEnd((Object)dataMinInvocationTime);
            }
        }
        this.options.series().addToEnd((Object)seriesOperationCount);
        this.options.series().addToEnd((Object)seriesDuration);
        this.options.series().addToEnd((Object)seriesMaxInvocationTime);
        this.options.series().addToEnd((Object)seriesMinInvocationTime);
        this.options.chart().showAxes(true);
        this.options.legend().enabled(true);
    }

    private void createSingleAxisChart() {
        SeriesService seriesService = (SeriesService)this.accountingStateData.getSeriesResponse();
        if (!(seriesService.getSerieServiceDefinition() instanceof SeriesServiceBasic)) {
            Log.debug((String)"Invalid SeriesServiceBasic!");
            return;
        }
        SeriesServiceBasic seriesServiceBasic = (SeriesServiceBasic)seriesService.getSerieServiceDefinition();
        JsoHighchartsOptionFactory highchartsFactory = new JsoHighchartsOptionFactory();
        this.options = highchartsFactory.createChartOptions();
        this.options.navigation().buttonOptions().enabled(false);
        this.options.exporting().filename("AccountingService");
        this.options.chart().zoomType("xy");
        this.options.title().text("Accounting Service");
        ArrayString colors = this.options.colors();
        String multiAxis = "[{ \"id\": \"" + ServiceChartMeasure.OperationCount.name() + "\"," + " \"labels\": { " + "    \"format\": \"{value}\"," + "    \"style\": { " + "      \"color\": \"" + colors.get(1) + "\"" + "    }" + " }," + " \"title\": { " + "    \"text\": \"" + ServiceChartMeasure.OperationCount.getLabel() + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "    }" + " }" + "} , {" + " \"id\": \"ServiceData\", " + " \"linkedTo\": \"0\"," + "  \"gridLineWidth\": \"0\"," + " \"title\": {" + "    \"text\": \"\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "    }" + " }," + " \"labels\": {" + "    \"format\": \"{value} " + this.unitMeasureLabel + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "     }" + " }," + " \"opposite\": \"true\"" + "}]";
        this.options.setFieldAsJsonObject("yAxis", multiAxis);
        String fillcolor = "{\"linearGradient\": {\"x1\": 0,\"y1\": 0,\"x2\": 0,\"y2\": 1},\"stops\": [[0, \"#058DC7\"],[1, \"#FFFFFF\"]]}";
        this.options.plotOptions().area().setFieldAsJsonObject("fillColor", fillcolor).marker().radius(2.0).lineWidth(1.0).states().hover().lineWidth(1.0);
        SeriesColumn seriesOperationCount = highchartsFactory.createSeriesColumn();
        seriesOperationCount.name(ServiceChartMeasure.OperationCount.getLabel());
        seriesOperationCount.color(colors.get(1));
        seriesOperationCount.type("column");
        SeriesArea seriesDuration = highchartsFactory.createSeriesArea();
        seriesDuration.name(ServiceChartMeasure.Duration.getLabel());
        seriesDuration.color(colors.get(0));
        SeriesArea seriesMaxInvocationTime = highchartsFactory.createSeriesArea();
        seriesMaxInvocationTime.name(ServiceChartMeasure.MaxInvocationTime.getLabel());
        seriesMaxInvocationTime.color(colors.get(2));
        SeriesArea seriesMinInvocationTime = highchartsFactory.createSeriesArea();
        seriesMinInvocationTime.name(ServiceChartMeasure.MinInvocationTime.getLabel());
        seriesMinInvocationTime.color(colors.get(3));
        if (this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.DAILY) == 0 || this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.HOURLY) == 0 || this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.MINUTELY) == 0) {
            double minRange = ChartTimeMeasure.calculateMinRange((AccountingPeriod)this.accountingStateData.getSeriesRequest().getAccountingPeriod());
            double interval = ChartTimeMeasure.calculateInterval((AccountingPeriod)this.accountingStateData.getSeriesRequest().getAccountingPeriod());
            Date dateStart = this.dtf.parse(this.accountingStateData.getSeriesRequest().getAccountingPeriod().getStartDate());
            dateStart.setTime(dateStart.getTime() + ChartTimeMeasure.timeZoneOffset() * 60000L);
            Log.debug((String)("BuildChart DateStart: " + DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_FULL).format(dateStart)));
            this.options.xAxis().type("datetime");
            this.options.xAxis().minRange(minRange);
            this.options.tooltip().xDateFormat("Selected Data");
            ArrayNumber dataOperationCount = seriesOperationCount.dataAsArrayNumber();
            seriesOperationCount.pointInterval(interval).pointStart((double)dateStart.getTime());
            ArrayNumber dataDuration = seriesDuration.dataAsArrayNumber();
            seriesDuration.pointInterval(interval).pointStart((double)dateStart.getTime());
            ArrayNumber dataMaxInvocationTime = seriesMaxInvocationTime.dataAsArrayNumber();
            seriesMaxInvocationTime.pointInterval(interval).pointStart((double)dateStart.getTime());
            ArrayNumber dataMinInvocationTime = seriesMinInvocationTime.dataAsArrayNumber();
            seriesMinInvocationTime.pointInterval(interval).pointStart((double)dateStart.getTime());
            for (SeriesServiceData seriesServiceData : seriesServiceBasic.getSeries()) {
                dataOperationCount.push((double)seriesServiceData.getOperationCount().longValue());
                dataDuration.push((double)(seriesServiceData.getDuration() / this.unitMeasure));
                dataMaxInvocationTime.push((double)(seriesServiceData.getMaxInvocationTime() / this.unitMeasure));
                dataMinInvocationTime.push((double)(seriesServiceData.getMinInvocationTime() / this.unitMeasure));
            }
        } else {
            this.options.xAxis().type("datetime");
            if (this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.MONTHLY) == 0) {
                this.options.tooltip().xDateFormat("Selected Data");
            } else if (this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.YEARLY) == 0) {
                this.options.tooltip().xDateFormat("Selected Data");
            } else {
                this.options.tooltip().xDateFormat("Selected Data");
            }
            Array arrayDataOperationCount = seriesOperationCount.dataAsArrayObject();
            Array arrayDataDuration = seriesDuration.dataAsArrayObject();
            Array arrayDataMaxInvocationTime = seriesMaxInvocationTime.dataAsArrayObject();
            Array arrayDataMinInvocationTime = seriesMinInvocationTime.dataAsArrayObject();
            for (SeriesServiceData seriesServiceData : seriesServiceBasic.getSeries()) {
                long dateFrom1970 = seriesServiceData.getDate().getTime();
                Log.debug((String)("SeriersServiceData: " + seriesServiceData.getDate()));
                Log.debug((String)("SeriersServiceData: " + dateFrom1970));
                Data dataOperationCount = highchartsFactory.createSeriesColumnData();
                dataOperationCount.x((double)dateFrom1970);
                dataOperationCount.y((double)seriesServiceData.getOperationCount().longValue());
                arrayDataOperationCount.addToEnd((Object)dataOperationCount);
                com.github.highcharts4gwt.model.highcharts.option.api.seriesarea.Data dataDuration = highchartsFactory.createSeriesAreaData();
                dataDuration.x((double)dateFrom1970);
                dataDuration.y((double)(seriesServiceData.getDuration() / this.unitMeasure));
                arrayDataDuration.addToEnd((Object)dataDuration);
                com.github.highcharts4gwt.model.highcharts.option.api.seriesarea.Data dataMaxInvocationTime = highchartsFactory.createSeriesAreaData();
                dataMaxInvocationTime.x((double)dateFrom1970);
                dataMaxInvocationTime.y((double)(seriesServiceData.getMaxInvocationTime() / this.unitMeasure));
                arrayDataMaxInvocationTime.addToEnd((Object)dataMaxInvocationTime);
                com.github.highcharts4gwt.model.highcharts.option.api.seriesarea.Data dataMinInvocationTime = highchartsFactory.createSeriesAreaData();
                dataMinInvocationTime.x((double)dateFrom1970);
                dataMinInvocationTime.y((double)(seriesServiceData.getMinInvocationTime() / this.unitMeasure));
                arrayDataMinInvocationTime.addToEnd((Object)dataMinInvocationTime);
            }
        }
        this.options.series().addToEnd((Object)seriesOperationCount);
        this.options.series().addToEnd((Object)seriesDuration);
        this.options.series().addToEnd((Object)seriesMaxInvocationTime);
        this.options.series().addToEnd((Object)seriesMinInvocationTime);
        this.options.chart().showAxes(true);
        this.options.legend().enabled(true);
    }

    static /* synthetic */ void access$000(ServiceChartBasicPanel x0) {
        x0.updateChart();
    }

    static /* synthetic */ long access$102(ServiceChartBasicPanel x0, long x1) {
        x0.unitMeasure = x1;
        return x0.unitMeasure;
    }

    static /* synthetic */ String access$202(ServiceChartBasicPanel x0, String x1) {
        x0.unitMeasureLabel = x1;
        return x0.unitMeasureLabel;
    }

    static /* synthetic */ TextButton access$300(ServiceChartBasicPanel x0) {
        return x0.unitButton;
    }

    static /* synthetic */ void access$400(ServiceChartBasicPanel x0) {
        x0.onDownloadCSV();
    }

    static /* synthetic */ void access$500(ServiceChartBasicPanel x0) {
        x0.onDownloadXML();
    }

    static /* synthetic */ void access$600(ServiceChartBasicPanel x0) {
        x0.onDownloadJSON();
    }

    static /* synthetic */ HighchartsLayoutPanel access$700(ServiceChartBasicPanel x0) {
        return x0.highchartsLayoutPanel;
    }
}

