/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.command;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SortedSet;
import org.gcube.accounting.analytics.NumberedFilter;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQueryFactory;
import org.gcube.accounting.datamodel.aggregation.AggregatedJobUsageRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedServiceUsageRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedStorageStatusRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedStorageUsageRecord;
import org.gcube.portlets.admin.accountingmanager.server.amservice.PeriodModeMap;
import org.gcube.portlets.admin.accountingmanager.server.amservice.command.AccountingCommand;
import org.gcube.portlets.admin.accountingmanager.server.amservice.command.AccountingCommandGetFilterValues;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingPeriodMode;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValue;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValuesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValuesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingCommandGetFilterValues
implements AccountingCommand<FilterValuesResponse> {
    private static final Logger logger = LoggerFactory.getLogger(AccountingCommandGetFilterValues.class);
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy MMMMM dd");
    private FilterValuesRequest filterValuesRequest;

    public AccountingCommandGetFilterValues(FilterValuesRequest filterValuesRequest) {
        this.filterValuesRequest = filterValuesRequest;
    }

    public FilterValuesResponse execute() throws ServiceException {
        try {
            SortedSet values;
            logger.debug("getFilterValue(): [FilterValueRequest=" + this.filterValuesRequest + "]");
            FilterValuesResponse filterValuesResponse = null;
            if (this.filterValuesRequest == null || this.filterValuesRequest.getAccountingType() == null || this.filterValuesRequest.getFilterKey() == null) {
                filterValuesResponse = new FilterValuesResponse(new ArrayList());
                return filterValuesResponse;
            }
            ArrayList<FilterValue> filterValues = new ArrayList<FilterValue>();
            AccountingPersistenceQuery apq = AccountingPersistenceQueryFactory.getInstance();
            Calendar startCalendar = GregorianCalendar.getInstance(TemporalConstraint.DEFAULT_TIME_ZONE);
            try {
                startCalendar.setTime(this.sdf.parse(this.filterValuesRequest.getAccountingPeriod().getStartDate()));
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new ServiceException("Start Date not valid!");
            }
            Calendar endCalendar = GregorianCalendar.getInstance(TemporalConstraint.DEFAULT_TIME_ZONE);
            try {
                endCalendar.setTime(this.sdf.parse(this.filterValuesRequest.getAccountingPeriod().getEndDate()));
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new ServiceException("End Date not valid!");
            }
            endCalendar.set(11, 23);
            endCalendar.set(12, 59);
            endCalendar.set(13, 59);
            endCalendar.set(14, 999);
            TemporalConstraint tc = new TemporalConstraint(startCalendar.getTimeInMillis(), endCalendar.getTimeInMillis(), PeriodModeMap.getMode((AccountingPeriodMode)this.filterValuesRequest.getAccountingPeriod().getPeriod()));
            ArrayList filters = new ArrayList();
            switch (1.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$AccountingType[this.filterValuesRequest.getAccountingType().ordinal()]) {
                case 1: {
                    values = apq.getFilterValues(AggregatedJobUsageRecord.class, tc, filters, this.filterValuesRequest.getFilterKey().getKey());
                    break;
                }
                case 2: {
                    filterValuesResponse = new FilterValuesResponse(filterValues);
                    return filterValuesResponse;
                }
                case 3: {
                    values = apq.getFilterValues(AggregatedServiceUsageRecord.class, tc, filters, this.filterValuesRequest.getFilterKey().getKey());
                    break;
                }
                case 4: {
                    values = apq.getFilterValues(AggregatedStorageUsageRecord.class, tc, filters, this.filterValuesRequest.getFilterKey().getKey());
                    break;
                }
                case 5: {
                    filterValuesResponse = new FilterValuesResponse(filterValues);
                    return filterValuesResponse;
                }
                case 6: {
                    values = apq.getFilterValues(AggregatedStorageStatusRecord.class, tc, filters, this.filterValuesRequest.getFilterKey().getKey());
                    break;
                }
                default: {
                    filterValuesResponse = new FilterValuesResponse(filterValues);
                    return filterValuesResponse;
                }
            }
            for (NumberedFilter value : values) {
                if (value == null) continue;
                filterValues.add(new FilterValue(value.getValue()));
            }
            filterValuesResponse = new FilterValuesResponse(filterValues);
            return filterValuesResponse;
        }
        catch (Throwable e) {
            logger.error("Error in AccountingCommandGetFilterValues(): " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException("No values available!");
        }
    }
}

