/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.response;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.SortedMap;
import org.gcube.accounting.analytics.Info;
import org.gcube.accounting.analytics.NumberedFilter;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponseBuilder;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValue;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesService;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.service.SeriesServiceData;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.service.SeriesServiceDataTop;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.service.SeriesServiceDefinition;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.service.SeriesServiceTop;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeriesResponse4ServiceTop
extends SeriesResponseBuilder {
    protected static Logger logger = LoggerFactory.getLogger(SeriesResponse4ServiceTop.class);
    private Boolean showOthers;
    private Integer topNumber;
    private SortedMap<NumberedFilter, SortedMap<Calendar, Info>> topSM;

    public SeriesResponse4ServiceTop(Boolean showOthers, Integer topNumber, SortedMap<NumberedFilter, SortedMap<Calendar, Info>> topSM) {
        this.showOthers = showOthers;
        this.topNumber = topNumber;
        this.topSM = topSM;
    }

    public void buildSeriesResponse() throws ServiceException {
        try {
            if (this.topSM == null || this.topSM.isEmpty()) {
                logger.error("Error creating series for service accounting: No data available!");
                throw new ServiceException("No data available!");
            }
            ArrayList<SeriesServiceDataTop> seriesServiceDataTopList = new ArrayList<SeriesServiceDataTop>();
            for (NumberedFilter topValue : this.topSM.keySet()) {
                ArrayList<SeriesServiceData> series = new ArrayList<SeriesServiceData>();
                SortedMap infos = (SortedMap)this.topSM.get(topValue);
                for (Info info : infos.values()) {
                    JsonNode jso = info.getValue();
                    Long duration = jso.get("duration").asLong();
                    Long operationCount = jso.get("operationCount").asLong();
                    Long maxInvocationTime = jso.get("maxInvocationTime").asLong();
                    Long minInvocationTime = jso.get("minInvocationTime").asLong();
                    series.add(new SeriesServiceData(info.getCalendar().getTime(), operationCount, duration, maxInvocationTime, minInvocationTime));
                }
                SeriesServiceDataTop seriesServiceDataTop = new SeriesServiceDataTop(new FilterValue(topValue.getValue()), series);
                seriesServiceDataTopList.add(seriesServiceDataTop);
            }
            SeriesServiceTop seriesServiceTop = new SeriesServiceTop(this.showOthers, this.topNumber, seriesServiceDataTopList);
            SeriesService seriesService = new SeriesService((SeriesServiceDefinition)seriesServiceTop);
            this.seriesResponseSpec.setSr((SeriesResponse)seriesService);
        }
        catch (Throwable e) {
            logger.error("Error creating series for service accounting top chart: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException("Error creating series for service accounting top chart: " + e.getLocalizedMessage());
        }
    }
}

