/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.response;

import java.util.ArrayList;
import java.util.List;
import org.gcube.accounting.analytics.Info;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponseBuilder;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesJob;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobBasic;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobData;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobDefinition;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeriesResponse4JobBasic
extends SeriesResponseBuilder {
    protected static Logger logger = LoggerFactory.getLogger(SeriesResponse4JobBasic.class);
    private List<Info> infos;

    public SeriesResponse4JobBasic(List<Info> infos) {
        this.infos = infos;
    }

    public void buildSeriesResponse() throws ServiceException {
        try {
            if (this.infos.size() <= 0) {
                logger.error("Error creating series for job accounting: No data available!");
                throw new ServiceException("No data available!");
            }
            ArrayList<SeriesJobData> series = new ArrayList<SeriesJobData>();
            for (Info info : this.infos) {
                JsonNode jso = info.getValue();
                Long duration = jso.get("duration").asLong();
                Long operationCount = jso.get("operationCount").asLong();
                Long maxInvocationTime = jso.get("maxInvocationTime").asLong();
                Long minInvocationTime = jso.get("minInvocationTime").asLong();
                series.add(new SeriesJobData(info.getCalendar().getTime(), operationCount, duration, maxInvocationTime, minInvocationTime));
            }
            SeriesJobBasic seriesJobBasic = new SeriesJobBasic(series);
            SeriesJob seriesJob = new SeriesJob((SeriesJobDefinition)seriesJobBasic);
            this.seriesResponseSpec.setSr((SeriesResponse)seriesJob);
        }
        catch (Throwable e) {
            logger.error("Error creating series for job accounting basic chart: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException("Error creating series for job accounting basic chart: " + e.getLocalizedMessage());
        }
    }
}

