/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.client.maindata.charts.service;

import com.allen_sauer.gwt.log.client.Log;
import com.github.highcharts4gwt.client.view.widget.HighchartsLayoutPanel;
import com.github.highcharts4gwt.model.array.api.ArrayNumber;
import com.github.highcharts4gwt.model.array.api.ArrayString;
import com.github.highcharts4gwt.model.factory.jso.JsoHighchartsOptionFactory;
import com.github.highcharts4gwt.model.highcharts.option.api.ChartOptions;
import com.github.highcharts4gwt.model.highcharts.option.api.SeriesColumn;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.cell.core.client.ButtonCell;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.menu.Menu;
import com.sencha.gxt.widget.core.client.menu.MenuItem;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;
import java.util.ArrayList;
import java.util.Date;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.service.ServiceChartTopPanel;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.utils.ChartTimeMeasure;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.utils.ServiceChartMeasure;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.utils.TimeUnitMeasure;
import org.gcube.portlets.admin.accountingmanager.client.resource.AccountingManagerResources;
import org.gcube.portlets.admin.accountingmanager.client.state.AccountingStateData;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingPeriod;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesService;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.service.SeriesServiceData;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.service.SeriesServiceDataTop;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.service.SeriesServiceTop;

public class ServiceChartTopPanel
extends SimpleContainer {
    private static final String TIME_UNIT = "Time Unit";
    private DateTimeFormat dtf = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.YEAR_MONTH_DAY);
    private AccountingStateData accountingStateData;
    private HighchartsLayoutPanel highchartsLayoutPanel;
    private MenuItem downloadPNGItem;
    private MenuItem downloadJPGItem;
    private MenuItem downloadPDFItem;
    private MenuItem downloadSVGItem;
    private MenuItem operationCountItem;
    private MenuItem durationItem;
    private MenuItem maxInvocationTimeItem;
    private MenuItem minInvocationTimeItem;
    private MenuItem msItem;
    private MenuItem sItem;
    private MenuItem mItem;
    private MenuItem hItem;
    private long unitMeasure = TimeUnitMeasure.getMilliseconds();
    private String unitMeasureLabel = "ms";
    private TextButton unitButton;
    private ChartOptions options;
    private ServiceChartMeasure measure = ServiceChartMeasure.OperationCount;
    private TextButton measureButton;
    private VerticalLayoutContainer vert;

    public ServiceChartTopPanel(AccountingStateData accountingStateData) {
        this.accountingStateData = accountingStateData;
        this.forceLayoutOnResize = true;
        this.create();
    }

    private void create() {
        ToolBar toolBar = new ToolBar();
        toolBar.setSpacing(2);
        TextButton downloadButton = new TextButton("Download", AccountingManagerResources.INSTANCE.accountingDownload24());
        downloadButton.setIconAlign(ButtonCell.IconAlign.RIGHT);
        downloadButton.setArrowAlign(ButtonCell.ButtonArrowAlign.RIGHT);
        downloadButton.setMenu(this.createDownloadMenu());
        this.measureButton = new TextButton(ServiceChartMeasure.OperationCount.getLabel(), AccountingManagerResources.INSTANCE.accountingByte24());
        this.measureButton.setIconAlign(ButtonCell.IconAlign.RIGHT);
        this.measureButton.setArrowAlign(ButtonCell.ButtonArrowAlign.RIGHT);
        this.measureButton.setMenu(this.createMeasureMenu());
        this.unitButton = new TextButton(TIME_UNIT, AccountingManagerResources.INSTANCE.accountingUnitms24());
        this.unitButton.setIconAlign(ButtonCell.IconAlign.RIGHT);
        this.unitButton.setArrowAlign(ButtonCell.ButtonArrowAlign.RIGHT);
        this.unitButton.setMenu(this.createUnitMenu());
        this.unitButton.setVisible(false);
        toolBar.add((IsWidget)downloadButton, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        toolBar.add((IsWidget)this.measureButton, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        toolBar.add((IsWidget)this.unitButton, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        this.createChart();
        this.highchartsLayoutPanel = new HighchartsLayoutPanel();
        this.highchartsLayoutPanel.renderChart(this.options);
        this.vert = new VerticalLayoutContainer();
        this.vert.add((IsWidget)toolBar, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        this.vert.add((IsWidget)this.highchartsLayoutPanel, new VerticalLayoutContainer.VerticalLayoutData(1.0, 1.0, new Margins(0)));
        this.add((Widget)this.vert, new MarginData(0));
    }

    private void updateChart() {
        this.createChart();
        this.highchartsLayoutPanel.renderChart(this.options);
        this.forceLayout();
    }

    private Menu createDownloadMenu() {
        Menu menuDownload = new Menu();
        this.downloadPNGItem = new MenuItem("Download PNG Image", AccountingManagerResources.INSTANCE.accountingFilePNG24());
        this.downloadPNGItem.setHeight(30);
        this.downloadJPGItem = new MenuItem("Download JPG Image", AccountingManagerResources.INSTANCE.accountingFileJPG24());
        this.downloadJPGItem.setHeight(30);
        this.downloadPDFItem = new MenuItem("Download PDF Document", AccountingManagerResources.INSTANCE.accountingFilePDF24());
        this.downloadPDFItem.setHeight(30);
        this.downloadSVGItem = new MenuItem("Download SVG Vector Image", AccountingManagerResources.INSTANCE.accountingFileSVG24());
        this.downloadSVGItem.setHeight(30);
        this.downloadPNGItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadJPGItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadPDFItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadSVGItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        menuDownload.add((Widget)this.downloadPNGItem);
        menuDownload.add((Widget)this.downloadJPGItem);
        menuDownload.add((Widget)this.downloadPDFItem);
        menuDownload.add((Widget)this.downloadSVGItem);
        return menuDownload;
    }

    private Menu createMeasureMenu() {
        Menu menuMeasure = new Menu();
        this.durationItem = new MenuItem(ServiceChartMeasure.Duration.getLabel());
        this.durationItem.setHeight(30);
        this.operationCountItem = new MenuItem(ServiceChartMeasure.OperationCount.getLabel());
        this.operationCountItem.setHeight(30);
        this.maxInvocationTimeItem = new MenuItem(ServiceChartMeasure.MaxInvocationTime.getLabel());
        this.maxInvocationTimeItem.setHeight(30);
        this.minInvocationTimeItem = new MenuItem(ServiceChartMeasure.MinInvocationTime.getLabel());
        this.minInvocationTimeItem.setHeight(30);
        this.durationItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.operationCountItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.maxInvocationTimeItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.minInvocationTimeItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        menuMeasure.add((Widget)this.durationItem);
        menuMeasure.add((Widget)this.maxInvocationTimeItem);
        menuMeasure.add((Widget)this.minInvocationTimeItem);
        menuMeasure.add((Widget)this.operationCountItem);
        return menuMeasure;
    }

    private Menu createUnitMenu() {
        Menu menuUnit = new Menu();
        this.msItem = new MenuItem("Milliseconds", AccountingManagerResources.INSTANCE.accountingUnitms24());
        this.msItem.setHeight(30);
        this.sItem = new MenuItem("Seconds", AccountingManagerResources.INSTANCE.accountingUnits24());
        this.sItem.setHeight(30);
        this.mItem = new MenuItem("Minutes", AccountingManagerResources.INSTANCE.accountingUnitm24());
        this.mItem.setHeight(30);
        this.hItem = new MenuItem("Hours", AccountingManagerResources.INSTANCE.accountingUnith24());
        this.hItem.setHeight(30);
        this.msItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.sItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.mItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.hItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        menuUnit.add((Widget)this.msItem);
        menuUnit.add((Widget)this.sItem);
        menuUnit.add((Widget)this.mItem);
        menuUnit.add((Widget)this.hItem);
        return menuUnit;
    }

    public static native void onDownloadPNG(String var0);

    public static native void onDownloadJPG(String var0);

    public static native void onDownloadPDF(String var0);

    public static native void onDownloadSVG(String var0);

    private void createChart() {
        SeriesService seriesService = (SeriesService)this.accountingStateData.getSeriesResponse();
        if (!(seriesService.getSerieServiceDefinition() instanceof SeriesServiceTop)) {
            Log.debug((String)"Invalid SeriesServiceTop!");
            return;
        }
        SeriesServiceTop seriesServiceTop = (SeriesServiceTop)seriesService.getSerieServiceDefinition();
        double minRange = ChartTimeMeasure.calculateMinRange((AccountingPeriod)this.accountingStateData.getSeriesRequest().getAccountingPeriod());
        double interval = ChartTimeMeasure.calculateInterval((AccountingPeriod)this.accountingStateData.getSeriesRequest().getAccountingPeriod());
        Date dateStart = this.dtf.parse(this.accountingStateData.getSeriesRequest().getAccountingPeriod().getStartDate());
        dateStart.setTime(dateStart.getTime() + ChartTimeMeasure.timeZoneOffset() * 60000L);
        Log.debug((String)("BuildChart DateStart: " + DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_FULL).format(dateStart)));
        JsoHighchartsOptionFactory highchartsFactory = new JsoHighchartsOptionFactory();
        this.options = highchartsFactory.createChartOptions();
        this.options.chart().zoomType("xy");
        this.options.exporting().buttons().contextButton().enabled(false);
        this.options.exporting().filename("AccountingServiceTop");
        this.options.title().text("Accounting Service Top");
        ArrayString colors = this.options.colors();
        this.options.xAxis().type("datetime").minRange(minRange);
        this.options.setFieldAsJsonObject("yAxis", this.retrieveYAxis(colors));
        this.options.plotOptions().setFieldAsJsonObject("column", "{ \"stacking\": \"normal\",\"dataLabels\": {     \"enabled\": \"true\",    \"color\": \"white\",     \"style\": {        \"textShadow\": \"0 0 3px black\"    } } }");
        ArrayList<SeriesColumn> seriesColumn = new ArrayList<SeriesColumn>();
        for (int i = 0; i < seriesServiceTop.getSeriesServiceDataTopList().size(); ++i) {
            SeriesColumn seriesColumnData = highchartsFactory.createSeriesColumn();
            seriesColumnData.name(((SeriesServiceDataTop)seriesServiceTop.getSeriesServiceDataTopList().get(i)).getFilterValue().getValue());
            seriesColumnData.color(colors.get(i));
            seriesColumnData.type("column");
            ArrayNumber data = seriesColumnData.dataAsArrayNumber();
            block7: for (SeriesServiceData seriesServiceData : ((SeriesServiceDataTop)seriesServiceTop.getSeriesServiceDataTopList().get(i)).getSeries()) {
                switch (13.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$maindata$charts$utils$ServiceChartMeasure[this.measure.ordinal()]) {
                    case 1: {
                        data.push((double)(seriesServiceData.getDuration() / this.unitMeasure));
                        continue block7;
                    }
                    case 2: {
                        data.push((double)(seriesServiceData.getMaxInvocationTime() / this.unitMeasure));
                        continue block7;
                    }
                    case 3: {
                        data.push((double)(seriesServiceData.getMinInvocationTime() / this.unitMeasure));
                        continue block7;
                    }
                    case 4: {
                        data.push((double)seriesServiceData.getOperationCount().longValue());
                        continue block7;
                    }
                }
                data.push((double)(seriesServiceData.getDuration() / this.unitMeasure));
            }
            seriesColumnData.pointInterval(interval).pointStart((double)dateStart.getTime());
            seriesColumn.add(seriesColumnData);
        }
        for (SeriesColumn serie : seriesColumn) {
            this.options.series().addToEnd((Object)serie);
        }
        this.options.chart().showAxes(true);
        this.options.legend().enabled(true);
    }

    private String retrieveYAxis(ArrayString colors) {
        switch (13.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$maindata$charts$utils$ServiceChartMeasure[this.measure.ordinal()]) {
            case 1: {
                return "[{ \"id\": \"" + ServiceChartMeasure.Duration.name() + "\"," + " \"labels\": {" + "    \"format\": \"{value} " + this.unitMeasureLabel + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "     }" + " }," + " \"stackLabels\": {" + " \"enabled\": \"true\"," + " \"style\": {" + "     \"fontWeight\": \"bold\"," + "    \"color\": \"gray\"" + "   } " + "   }," + " \"title\": { " + "    \"text\": \"" + ServiceChartMeasure.Duration.getLabel() + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "    }" + " }" + "}]";
            }
            case 2: {
                return "[{ \"id\": \"" + ServiceChartMeasure.MaxInvocationTime.name() + "\"," + " \"labels\": {" + "    \"format\": \"{value} " + this.unitMeasureLabel + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "     }" + " }," + " \"stackLabels\": {" + " \"enabled\": \"true\"," + " \"style\": {" + "     \"fontWeight\": \"bold\"," + "    \"color\": \"gray\"" + "   } " + "   }," + " \"title\": { " + "    \"text\": \"" + ServiceChartMeasure.MaxInvocationTime.getLabel() + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "    }" + " }" + "}]";
            }
            case 3: {
                return "[{ \"id\": \"" + ServiceChartMeasure.MinInvocationTime.name() + "\"," + " \"labels\": {" + "    \"format\": \"{value} " + this.unitMeasureLabel + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "     }" + " }," + " \"stackLabels\": {" + " \"enabled\": \"true\"," + " \"style\": {" + "     \"fontWeight\": \"bold\"," + "    \"color\": \"gray\"" + "   } " + "   }," + " \"title\": { " + "    \"text\": \"" + ServiceChartMeasure.MinInvocationTime.getLabel() + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "    }" + " }" + "}]";
            }
            case 4: {
                return "[{ \"id\": \"" + ServiceChartMeasure.OperationCount.name() + "\"," + " \"labels\": { " + "    \"format\": \"{value}\"," + "    \"style\": { " + "      \"color\": \"" + colors.get(1) + "\"" + "    }" + " }," + " \"stackLabels\": {" + " \"enabled\": \"true\"," + " \"style\": {" + "     \"fontWeight\": \"bold\"," + "    \"color\": \"gray\"" + "   } " + "   }," + " \"title\": { " + "    \"text\": \"" + ServiceChartMeasure.OperationCount.getLabel() + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "    }" + " }" + "}]";
            }
        }
        return "[{ \"id\": \"" + ServiceChartMeasure.Duration.name() + "\"," + " \"labels\": {" + "    \"format\": \"{value} " + this.unitMeasureLabel + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "     }" + " }," + " \"stackLabels\": {" + " \"enabled\": \"true\"," + " \"style\": {" + "     \"fontWeight\": \"bold\"," + "    \"color\": \"gray\"" + "   } " + "   }," + " \"title\": { " + "    \"text\": \"" + ServiceChartMeasure.Duration.getLabel() + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "    }" + " }" + "}]";
    }

    static /* synthetic */ HighchartsLayoutPanel access$000(ServiceChartTopPanel x0) {
        return x0.highchartsLayoutPanel;
    }

    static /* synthetic */ TextButton access$100(ServiceChartTopPanel x0) {
        return x0.measureButton;
    }

    static /* synthetic */ ServiceChartMeasure access$202(ServiceChartTopPanel x0, ServiceChartMeasure x1) {
        x0.measure = x1;
        return x0.measure;
    }

    static /* synthetic */ TextButton access$300(ServiceChartTopPanel x0) {
        return x0.unitButton;
    }

    static /* synthetic */ void access$400(ServiceChartTopPanel x0) {
        x0.updateChart();
    }

    static /* synthetic */ long access$502(ServiceChartTopPanel x0, long x1) {
        x0.unitMeasure = x1;
        return x0.unitMeasure;
    }

    static /* synthetic */ String access$602(ServiceChartTopPanel x0, String x1) {
        x0.unitMeasureLabel = x1;
        return x0.unitMeasureLabel;
    }
}

