/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server;

import javax.servlet.http.HttpSession;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portlets.admin.accountingmanager.shared.exception.AccountingManagerServiceException;
import org.gcube.portlets.admin.accountingmanager.shared.exception.AccountingManagerSessionExpiredException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionUtil {
    private static Logger logger = LoggerFactory.getLogger(SessionUtil.class);

    public static ASLSession getASLSession(HttpSession httpSession) throws AccountingManagerServiceException {
        String username = (String)httpSession.getAttribute("username");
        if (username == null) {
            logger.info("No user found in session");
            throw new AccountingManagerSessionExpiredException("Session Expired!");
        }
        ASLSession aslSession = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
        logger.info("SessionUtil: aslSession " + aslSession.getUsername() + " " + aslSession.getScope());
        return aslSession;
    }

    public static String getToken(ASLSession aslSession) {
        String token = null;
        token = aslSession.getSecurityToken();
        logger.info("received token: " + token);
        return token;
    }
}

