/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.command;

import java.util.Calendar;
import java.util.List;
import java.util.SortedMap;
import org.gcube.accounting.analytics.Info;
import org.gcube.accounting.analytics.NumberedFilter;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQueryFactory;
import org.gcube.portlets.admin.accountingmanager.server.amservice.command.AccountingCommand;
import org.gcube.portlets.admin.accountingmanager.server.amservice.command.AccountingCommandTop;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQueryTop;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponse4JobTop;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponse4PortletTop;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponse4ServiceTop;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponse4StorageTop;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponse4TaskTop;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponseBuilder;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponseDirector;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingType;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.exception.AccountingManagerServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingCommandTop
implements AccountingCommand<SeriesResponse> {
    private static final Logger logger = LoggerFactory.getLogger(AccountingCommandTop.class);
    private AccountingQueryTop accountingQueryTop;
    private AccountingType accountingType;

    public AccountingCommandTop(AccountingQueryTop accountingQueryTop, AccountingType accountingType) {
        this.accountingQueryTop = accountingQueryTop;
        this.accountingType = accountingType;
    }

    public SeriesResponse execute() throws AccountingManagerServiceException {
        try {
            AccountingPersistenceQuery apq = AccountingPersistenceQueryFactory.getInstance();
            logger.debug("Qyery TopValues: " + this.accountingQueryTop.getFilterKey().getKey());
            SortedMap topSM = apq.getTopValues(this.accountingQueryTop.getType(), this.accountingQueryTop.getTemporalConstraint(), (List)this.accountingQueryTop.getFilters(), this.accountingQueryTop.getFilterKey().getKey(), null, true, this.accountingQueryTop.getTopNumber().intValue());
            if (topSM == null) {
                throw new AccountingManagerServiceException("Error retrieving info for top: sorted map is null!");
            }
            logger.debug("TopSM: " + topSM);
            SeriesResponseBuilder seriesResponseBuilder = this.getSeriesResponseBuilder(this.accountingType, topSM);
            SeriesResponseDirector seriesResponseDirector = new SeriesResponseDirector();
            seriesResponseDirector.setSeriesResponseBuilder(seriesResponseBuilder);
            seriesResponseDirector.constructSeriesResponse();
            SeriesResponse seriesResponse = seriesResponseDirector.getSeriesResponse();
            if (seriesResponse == null) {
                throw new AccountingManagerServiceException("Error creating series response!");
            }
            logger.debug("SeriesResponse Created: " + seriesResponse);
            return seriesResponse;
        }
        catch (Throwable e) {
            logger.error("Error in AccountingCommandTop(): " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new AccountingManagerServiceException("No data available!");
        }
    }

    private SeriesResponseBuilder getSeriesResponseBuilder(AccountingType accountingType, SortedMap<NumberedFilter, SortedMap<Calendar, Info>> topSM) throws AccountingManagerServiceException {
        if (accountingType == null) {
            throw new AccountingManagerServiceException("Error accounting type is null");
        }
        switch (1.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$AccountingType[accountingType.ordinal()]) {
            case 1: {
                return new SeriesResponse4JobTop(topSM);
            }
            case 2: {
                return new SeriesResponse4PortletTop(topSM);
            }
            case 3: {
                return new SeriesResponse4ServiceTop(topSM);
            }
            case 4: {
                return new SeriesResponse4StorageTop(topSM);
            }
            case 5: {
                return new SeriesResponse4TaskTop(topSM);
            }
        }
        throw new AccountingManagerServiceException("Error request type is unknow!");
    }
}

