/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.response;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.SortedMap;
import org.gcube.accounting.analytics.Info;
import org.gcube.accounting.analytics.NumberedFilter;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponseBuilder;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValue;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesJob;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobData;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobDataTop;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobDefinition;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobTop;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeriesResponse4JobTop
extends SeriesResponseBuilder {
    protected static Logger logger = LoggerFactory.getLogger(SeriesResponse4JobTop.class);
    private Boolean showOthers;
    private Integer topNumber;
    private SortedMap<NumberedFilter, SortedMap<Calendar, Info>> topSM;

    public SeriesResponse4JobTop(Boolean showOthers, Integer topNumber, SortedMap<NumberedFilter, SortedMap<Calendar, Info>> topSM) {
        this.showOthers = showOthers;
        this.topNumber = topNumber;
        this.topSM = topSM;
    }

    public void buildSeriesResponse() throws ServiceException {
        try {
            if (this.topSM == null || this.topSM.isEmpty()) {
                logger.error("Error creating series for job accounting: No data available!");
                throw new ServiceException("No data available!");
            }
            ArrayList<SeriesJobDataTop> seriesJobDataTopList = new ArrayList<SeriesJobDataTop>();
            for (NumberedFilter topValue : this.topSM.keySet()) {
                ArrayList<SeriesJobData> series = new ArrayList<SeriesJobData>();
                SortedMap infos = (SortedMap)this.topSM.get(topValue);
                for (Info info : infos.values()) {
                    JSONObject jso = info.getValue();
                    Long operationCount = jso.getLong("operationCount");
                    series.add(new SeriesJobData(info.getCalendar().getTime(), operationCount, operationCount, operationCount, operationCount));
                }
                SeriesJobDataTop seriesJobDataTop = new SeriesJobDataTop(new FilterValue(topValue.getValue()), series);
                seriesJobDataTopList.add(seriesJobDataTop);
            }
            SeriesJobTop seriesJobTop = new SeriesJobTop(this.showOthers, this.topNumber, seriesJobDataTopList);
            SeriesJob seriesJob = new SeriesJob((SeriesJobDefinition)seriesJobTop);
            this.seriesResponseSpec.setSr((SeriesResponse)seriesJob);
        }
        catch (Throwable e) {
            logger.error("Error creating series for job accounting top chart: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException("Error creating series for job accounting top chart: " + e.getLocalizedMessage());
        }
    }
}

