/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.client.maindata.charts.job;

import com.allen_sauer.gwt.log.client.Log;
import com.github.highcharts4gwt.client.view.widget.HighchartsLayoutPanel;
import com.github.highcharts4gwt.model.array.api.Array;
import com.github.highcharts4gwt.model.array.api.ArrayNumber;
import com.github.highcharts4gwt.model.array.api.ArrayString;
import com.github.highcharts4gwt.model.factory.api.HighchartsOptionFactory;
import com.github.highcharts4gwt.model.factory.jso.JsoHighchartsOptionFactory;
import com.github.highcharts4gwt.model.highcharts.option.api.ChartOptions;
import com.github.highcharts4gwt.model.highcharts.option.api.SeriesColumn;
import com.github.highcharts4gwt.model.highcharts.option.api.seriescolumn.Data;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.cell.core.client.ButtonCell;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.menu.Menu;
import com.sencha.gxt.widget.core.client.menu.MenuItem;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;
import java.util.ArrayList;
import java.util.Date;
import org.gcube.portlets.admin.accountingmanager.client.event.ExportRequestEvent;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.job.JobChartTopPanel;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.utils.ChartDateTimeData;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.utils.ChartTimeMeasure;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.utils.JobChartMeasure;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.utils.TimeUnitMeasure;
import org.gcube.portlets.admin.accountingmanager.client.resource.AccountingManagerResources;
import org.gcube.portlets.admin.accountingmanager.client.state.AccountingClientStateData;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingPeriod;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingPeriodMode;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesJob;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobData;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobDataTop;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobTop;
import org.gcube.portlets.admin.accountingmanager.shared.export.ExportType;

public class JobChartTopPanel
extends SimpleContainer {
    private static final String TIME_UNIT = "Time Unit";
    private DateTimeFormat dtf = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.YEAR_MONTH_DAY);
    private EventBus eventBus;
    private AccountingClientStateData accountingStateData;
    private HighchartsLayoutPanel highchartsLayoutPanel;
    private MenuItem downloadCSVItem;
    private MenuItem downloadXMLItem;
    private MenuItem downloadJSONItem;
    private MenuItem downloadPNGItem;
    private MenuItem downloadJPGItem;
    private MenuItem downloadPDFItem;
    private MenuItem downloadSVGItem;
    private MenuItem operationCountItem;
    private MenuItem durationItem;
    private MenuItem maxInvocationTimeItem;
    private MenuItem minInvocationTimeItem;
    private MenuItem msItem;
    private MenuItem sItem;
    private MenuItem mItem;
    private MenuItem hItem;
    private long unitMeasure = TimeUnitMeasure.getMilliseconds();
    private String unitMeasureLabel = "ms";
    private TextButton unitButton;
    private ChartOptions options;
    private JobChartMeasure measure = JobChartMeasure.Duration;
    private TextButton measureButton;
    private VerticalLayoutContainer vert;

    public JobChartTopPanel(EventBus eventBus, AccountingClientStateData accountingStateData) {
        this.eventBus = eventBus;
        this.accountingStateData = accountingStateData;
        this.forceLayoutOnResize = true;
        this.create();
    }

    private void create() {
        ToolBar toolBar = new ToolBar();
        toolBar.setSpacing(2);
        TextButton downloadButton = new TextButton("Download", AccountingManagerResources.INSTANCE.accountingDownload24());
        downloadButton.setIconAlign(ButtonCell.IconAlign.RIGHT);
        downloadButton.setArrowAlign(ButtonCell.ButtonArrowAlign.RIGHT);
        downloadButton.setMenu(this.createDownloadMenu());
        this.measureButton = new TextButton(JobChartMeasure.Duration.getLabel(), AccountingManagerResources.INSTANCE.accountingByte24());
        this.measureButton.setIconAlign(ButtonCell.IconAlign.RIGHT);
        this.measureButton.setArrowAlign(ButtonCell.ButtonArrowAlign.RIGHT);
        this.measureButton.setMenu(this.createMeasureMenu());
        this.unitButton = new TextButton(TIME_UNIT, AccountingManagerResources.INSTANCE.accountingUnitms24());
        this.unitButton.setIconAlign(ButtonCell.IconAlign.RIGHT);
        this.unitButton.setArrowAlign(ButtonCell.ButtonArrowAlign.RIGHT);
        this.unitButton.setMenu(this.createUnitMenu());
        toolBar.add((IsWidget)downloadButton, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        toolBar.add((IsWidget)this.measureButton, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        toolBar.add((IsWidget)this.unitButton, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        this.createChart();
        this.highchartsLayoutPanel = new HighchartsLayoutPanel();
        this.highchartsLayoutPanel.renderChart(this.options);
        this.vert = new VerticalLayoutContainer();
        this.vert.add((IsWidget)toolBar, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        this.vert.add((IsWidget)this.highchartsLayoutPanel, new VerticalLayoutContainer.VerticalLayoutData(1.0, 1.0, new Margins(0)));
        this.add((Widget)this.vert, new MarginData(0));
    }

    private void updateChart() {
        this.createChart();
        this.highchartsLayoutPanel.renderChart(this.options);
        this.forceLayout();
    }

    private Menu createDownloadMenu() {
        Menu menuDownload = new Menu();
        this.downloadCSVItem = new MenuItem("Download CSV", AccountingManagerResources.INSTANCE.accountingFileCSV24());
        this.downloadCSVItem.setHeight(30);
        this.downloadXMLItem = new MenuItem("Download XML", AccountingManagerResources.INSTANCE.accountingFileXML24());
        this.downloadXMLItem.setHeight(30);
        this.downloadJSONItem = new MenuItem("Download JSON", AccountingManagerResources.INSTANCE.accountingFileJSON24());
        this.downloadJSONItem.setHeight(30);
        this.downloadPNGItem = new MenuItem("Download PNG Image", AccountingManagerResources.INSTANCE.accountingFilePNG24());
        this.downloadPNGItem.setHeight(30);
        this.downloadJPGItem = new MenuItem("Download JPG Image", AccountingManagerResources.INSTANCE.accountingFileJPG24());
        this.downloadJPGItem.setHeight(30);
        this.downloadPDFItem = new MenuItem("Download PDF Document", AccountingManagerResources.INSTANCE.accountingFilePDF24());
        this.downloadPDFItem.setHeight(30);
        this.downloadSVGItem = new MenuItem("Download SVG Vector Image", AccountingManagerResources.INSTANCE.accountingFileSVG24());
        this.downloadSVGItem.setHeight(30);
        this.downloadCSVItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadXMLItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadJSONItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadPNGItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadJPGItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadPDFItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadSVGItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        menuDownload.add((Widget)this.downloadCSVItem);
        menuDownload.add((Widget)this.downloadXMLItem);
        menuDownload.add((Widget)this.downloadJSONItem);
        menuDownload.add((Widget)this.downloadPNGItem);
        menuDownload.add((Widget)this.downloadJPGItem);
        menuDownload.add((Widget)this.downloadPDFItem);
        menuDownload.add((Widget)this.downloadSVGItem);
        return menuDownload;
    }

    private Menu createMeasureMenu() {
        Menu menuMeasure = new Menu();
        this.durationItem = new MenuItem(JobChartMeasure.Duration.getLabel());
        this.durationItem.setHeight(30);
        this.operationCountItem = new MenuItem(JobChartMeasure.OperationCount.getLabel());
        this.operationCountItem.setHeight(30);
        this.maxInvocationTimeItem = new MenuItem(JobChartMeasure.MaxInvocationTime.getLabel());
        this.maxInvocationTimeItem.setHeight(30);
        this.minInvocationTimeItem = new MenuItem(JobChartMeasure.MinInvocationTime.getLabel());
        this.minInvocationTimeItem.setHeight(30);
        this.durationItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.operationCountItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.maxInvocationTimeItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.minInvocationTimeItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        menuMeasure.add((Widget)this.durationItem);
        menuMeasure.add((Widget)this.maxInvocationTimeItem);
        menuMeasure.add((Widget)this.minInvocationTimeItem);
        menuMeasure.add((Widget)this.operationCountItem);
        return menuMeasure;
    }

    private Menu createUnitMenu() {
        Menu menuUnit = new Menu();
        this.msItem = new MenuItem("Milliseconds", AccountingManagerResources.INSTANCE.accountingUnitms24());
        this.msItem.setHeight(30);
        this.sItem = new MenuItem("Seconds", AccountingManagerResources.INSTANCE.accountingUnits24());
        this.sItem.setHeight(30);
        this.mItem = new MenuItem("Minutes", AccountingManagerResources.INSTANCE.accountingUnitm24());
        this.mItem.setHeight(30);
        this.hItem = new MenuItem("Hours", AccountingManagerResources.INSTANCE.accountingUnith24());
        this.hItem.setHeight(30);
        this.msItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.sItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.mItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.hItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        menuUnit.add((Widget)this.msItem);
        menuUnit.add((Widget)this.sItem);
        menuUnit.add((Widget)this.mItem);
        menuUnit.add((Widget)this.hItem);
        return menuUnit;
    }

    private void onDownloadCSV() {
        ExportRequestEvent event = new ExportRequestEvent(ExportType.CSV, this.accountingStateData.getAccountingType());
        this.eventBus.fireEvent((GwtEvent)event);
    }

    private void onDownloadXML() {
        ExportRequestEvent event = new ExportRequestEvent(ExportType.XML, this.accountingStateData.getAccountingType());
        this.eventBus.fireEvent((GwtEvent)event);
    }

    private void onDownloadJSON() {
        ExportRequestEvent event = new ExportRequestEvent(ExportType.JSON, this.accountingStateData.getAccountingType());
        this.eventBus.fireEvent((GwtEvent)event);
    }

    public static native void onDownloadPNG(String var0);

    public static native void onDownloadJPG(String var0);

    public static native void onDownloadPDF(String var0);

    public static native void onDownloadSVG(String var0);

    private void createChart() {
        SeriesJob seriesJob = (SeriesJob)this.accountingStateData.getSeriesResponse();
        if (!(seriesJob.getSeriesJobDefinition() instanceof SeriesJobTop)) {
            Log.debug((String)"Invalid SeriesJobTop!");
            return;
        }
        SeriesJobTop seriesJobTop = (SeriesJobTop)seriesJob.getSeriesJobDefinition();
        JsoHighchartsOptionFactory highchartsFactory = new JsoHighchartsOptionFactory();
        this.options = highchartsFactory.createChartOptions();
        this.options.chart().zoomType("xy");
        this.options.exporting().buttons().contextButton().enabled(false);
        this.options.exporting().filename("AccountingJobTop");
        this.options.title().text("Accounting Job Top");
        ArrayString colors = this.options.colors();
        this.options.setFieldAsJsonObject("yAxis", this.retrieveYAxis(colors));
        this.options.plotOptions().setFieldAsJsonObject("column", "{ \"stacking\": \"normal\",\"dataLabels\": {     \"enabled\": \"true\",    \"color\": \"white\",     \"style\": {        \"textShadow\": \"0 0 3px black\"    } } }");
        ArrayList seriesColumn = new ArrayList();
        if (seriesJobTop.getShowOthers().booleanValue()) {
            this.createSeriesColumnShowOthers(seriesJobTop, (HighchartsOptionFactory)highchartsFactory, colors, seriesColumn);
        } else {
            this.createSeriesColumnSimple(seriesJobTop, (HighchartsOptionFactory)highchartsFactory, colors, seriesColumn);
        }
        for (SeriesColumn serie : seriesColumn) {
            this.options.series().addToEnd((Object)serie);
        }
        this.options.chart().showAxes(true);
        this.options.legend().enabled(true);
    }

    private void createSeriesColumnShowOthers(SeriesJobTop seriesJobTop, HighchartsOptionFactory highchartsFactory, ArrayString colors, ArrayList<SeriesColumn> seriesColumn) {
        Log.debug((String)"Series ShowOthers");
        if (this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.DAILY) == 0 || this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.HOURLY) == 0 || this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.MINUTELY) == 0) {
            SeriesColumn seriesColumnData;
            int i;
            double minRange = ChartTimeMeasure.calculateMinRange((AccountingPeriod)this.accountingStateData.getSeriesRequest().getAccountingPeriod());
            double interval = ChartTimeMeasure.calculateInterval((AccountingPeriod)this.accountingStateData.getSeriesRequest().getAccountingPeriod());
            Date dateStart = this.dtf.parse(this.accountingStateData.getSeriesRequest().getAccountingPeriod().getStartDate());
            dateStart.setTime(dateStart.getTime() + ChartTimeMeasure.timeZoneOffset() * 60000L);
            Log.debug((String)("BuildChart DateStart: " + DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_FULL).format(dateStart)));
            this.options.xAxis().type("datetime");
            this.options.xAxis().minRange(minRange);
            this.options.tooltip().xDateFormat("Selected Data");
            for (i = 0; i < seriesJobTop.getSeriesJobDataTopList().size() && i < seriesJobTop.getTopNumber(); ++i) {
                seriesColumnData = highchartsFactory.createSeriesColumn();
                seriesColumnData.name(((SeriesJobDataTop)seriesJobTop.getSeriesJobDataTopList().get(i)).getFilterValue().getValue());
                seriesColumnData.color(colors.get(i));
                seriesColumnData.type("column");
                ArrayNumber data = seriesColumnData.dataAsArrayNumber();
                block37: for (SeriesJobData seriesJobData : ((SeriesJobDataTop)seriesJobTop.getSeriesJobDataTopList().get(i)).getSeries()) {
                    switch (16.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$maindata$charts$utils$JobChartMeasure[this.measure.ordinal()]) {
                        case 1: {
                            data.push((double)(seriesJobData.getDuration() / this.unitMeasure));
                            continue block37;
                        }
                        case 2: {
                            data.push((double)(seriesJobData.getMaxInvocationTime() / this.unitMeasure));
                            continue block37;
                        }
                        case 3: {
                            data.push((double)(seriesJobData.getMinInvocationTime() / this.unitMeasure));
                            continue block37;
                        }
                        case 4: {
                            data.push((double)seriesJobData.getOperationCount().longValue());
                            continue block37;
                        }
                    }
                    data.push((double)(seriesJobData.getDuration() / this.unitMeasure));
                }
                seriesColumnData.pointInterval(interval).pointStart((double)dateStart.getTime());
                seriesColumn.add(seriesColumnData);
            }
            if (i < seriesJobTop.getSeriesJobDataTopList().size()) {
                seriesColumnData = highchartsFactory.createSeriesColumn();
                seriesColumnData.name("Others");
                seriesColumnData.color(colors.get(i));
                seriesColumnData.type("column");
                ArrayList<Long> othersData = new ArrayList<Long>();
                for (int j = i; j < seriesJobTop.getSeriesJobDataTopList().size(); ++j) {
                    block39: for (int k = 0; k < ((SeriesJobDataTop)seriesJobTop.getSeriesJobDataTopList().get(j)).getSeries().size(); ++k) {
                        SeriesJobData seriesJobData = (SeriesJobData)((SeriesJobDataTop)seriesJobTop.getSeriesJobDataTopList().get(j)).getSeries().get(k);
                        if (j == i) {
                            switch (16.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$maindata$charts$utils$JobChartMeasure[this.measure.ordinal()]) {
                                case 1: {
                                    othersData.add(seriesJobData.getDuration() / this.unitMeasure);
                                    break;
                                }
                                case 2: {
                                    othersData.add(seriesJobData.getMaxInvocationTime() / this.unitMeasure);
                                    break;
                                }
                                case 3: {
                                    othersData.add(seriesJobData.getMinInvocationTime() / this.unitMeasure);
                                    break;
                                }
                                case 4: {
                                    othersData.add(seriesJobData.getOperationCount());
                                    break;
                                }
                                default: {
                                    othersData.add(seriesJobData.getDuration() / this.unitMeasure);
                                    break;
                                }
                            }
                            continue;
                        }
                        switch (16.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$maindata$charts$utils$JobChartMeasure[this.measure.ordinal()]) {
                            case 1: {
                                Long value = seriesJobData.getDuration() / this.unitMeasure + (Long)othersData.get(k);
                                othersData.set(k, value);
                                continue block39;
                            }
                            case 2: {
                                Long value = seriesJobData.getMaxInvocationTime() / this.unitMeasure + (Long)othersData.get(k);
                                othersData.set(k, value);
                                continue block39;
                            }
                            case 3: {
                                Long value = seriesJobData.getMinInvocationTime() / this.unitMeasure + (Long)othersData.get(k);
                                othersData.set(k, value);
                                continue block39;
                            }
                            case 4: {
                                Long value = seriesJobData.getOperationCount() + (Long)othersData.get(k);
                                othersData.set(k, value);
                                continue block39;
                            }
                            default: {
                                Long value = seriesJobData.getDuration() / this.unitMeasure + (Long)othersData.get(k);
                                othersData.set(k, value);
                            }
                        }
                    }
                }
                ArrayNumber data = seriesColumnData.dataAsArrayNumber();
                for (Long value : othersData) {
                    data.push((double)value.longValue());
                }
                seriesColumnData.pointInterval(interval).pointStart((double)dateStart.getTime());
                seriesColumn.add(seriesColumnData);
            }
        } else {
            SeriesColumn seriesColumnData;
            int i;
            this.options.xAxis().type("datetime");
            if (this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.MONTHLY) == 0) {
                this.options.tooltip().xDateFormat("Selected Data");
            } else if (this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.YEARLY) == 0) {
                this.options.tooltip().xDateFormat("Selected Data");
            } else {
                this.options.tooltip().xDateFormat("Selected Data");
            }
            for (i = 0; i < seriesJobTop.getSeriesJobDataTopList().size() && i < seriesJobTop.getTopNumber(); ++i) {
                seriesColumnData = highchartsFactory.createSeriesColumn();
                seriesColumnData.name(((SeriesJobDataTop)seriesJobTop.getSeriesJobDataTopList().get(i)).getFilterValue().getValue());
                seriesColumnData.color(colors.get(i));
                seriesColumnData.type("column");
                Array arrayData = seriesColumnData.dataAsArrayObject();
                block42: for (SeriesJobData seriesJobData : ((SeriesJobDataTop)seriesJobTop.getSeriesJobDataTopList().get(i)).getSeries()) {
                    long dateFrom1970 = seriesJobData.getDate().getTime();
                    Log.debug((String)("SeriersJobData: " + seriesJobData.getDate()));
                    Log.debug((String)("SeriersJobData: " + dateFrom1970));
                    Data data = highchartsFactory.createSeriesColumnData();
                    switch (16.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$maindata$charts$utils$JobChartMeasure[this.measure.ordinal()]) {
                        case 1: {
                            data.x((double)dateFrom1970);
                            data.y((double)(seriesJobData.getDuration() / this.unitMeasure));
                            arrayData.addToEnd((Object)data);
                            continue block42;
                        }
                        case 2: {
                            data.x((double)dateFrom1970);
                            data.y((double)(seriesJobData.getMaxInvocationTime() / this.unitMeasure));
                            arrayData.addToEnd((Object)data);
                            continue block42;
                        }
                        case 3: {
                            data.x((double)dateFrom1970);
                            data.y((double)(seriesJobData.getMinInvocationTime() / this.unitMeasure));
                            arrayData.addToEnd((Object)data);
                            continue block42;
                        }
                        case 4: {
                            data.x((double)dateFrom1970);
                            data.y((double)seriesJobData.getOperationCount().longValue());
                            arrayData.addToEnd((Object)data);
                            continue block42;
                        }
                    }
                    data.x((double)dateFrom1970);
                    data.y((double)(seriesJobData.getDuration() / this.unitMeasure));
                    arrayData.addToEnd((Object)data);
                }
                seriesColumn.add(seriesColumnData);
            }
            if (i < seriesJobTop.getSeriesJobDataTopList().size()) {
                seriesColumnData = highchartsFactory.createSeriesColumn();
                seriesColumnData.name("Others");
                seriesColumnData.color(colors.get(i));
                seriesColumnData.type("column");
                ArrayList<ChartDateTimeData> othersData = new ArrayList<ChartDateTimeData>();
                for (int j = i; j < seriesJobTop.getSeriesJobDataTopList().size(); ++j) {
                    block44: for (int k = 0; k < ((SeriesJobDataTop)seriesJobTop.getSeriesJobDataTopList().get(j)).getSeries().size(); ++k) {
                        ChartDateTimeData chartDateTimeData;
                        SeriesJobData seriesJobData = (SeriesJobData)((SeriesJobDataTop)seriesJobTop.getSeriesJobDataTopList().get(j)).getSeries().get(k);
                        if (j == i) {
                            switch (16.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$maindata$charts$utils$JobChartMeasure[this.measure.ordinal()]) {
                                case 1: {
                                    chartDateTimeData = new ChartDateTimeData(seriesJobData.getDate(), Long.valueOf(seriesJobData.getDuration() / this.unitMeasure));
                                    othersData.add(chartDateTimeData);
                                    break;
                                }
                                case 2: {
                                    chartDateTimeData = new ChartDateTimeData(seriesJobData.getDate(), Long.valueOf(seriesJobData.getMaxInvocationTime() / this.unitMeasure));
                                    othersData.add(chartDateTimeData);
                                    break;
                                }
                                case 3: {
                                    chartDateTimeData = new ChartDateTimeData(seriesJobData.getDate(), Long.valueOf(seriesJobData.getMinInvocationTime() / this.unitMeasure));
                                    othersData.add(chartDateTimeData);
                                    break;
                                }
                                case 4: {
                                    chartDateTimeData = new ChartDateTimeData(seriesJobData.getDate(), seriesJobData.getOperationCount());
                                    othersData.add(chartDateTimeData);
                                    break;
                                }
                                default: {
                                    chartDateTimeData = new ChartDateTimeData(seriesJobData.getDate(), Long.valueOf(seriesJobData.getDuration() / this.unitMeasure));
                                    othersData.add(chartDateTimeData);
                                    break;
                                }
                            }
                            continue;
                        }
                        switch (16.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$maindata$charts$utils$JobChartMeasure[this.measure.ordinal()]) {
                            case 1: {
                                chartDateTimeData = new ChartDateTimeData(seriesJobData.getDate(), Long.valueOf(seriesJobData.getDuration() / this.unitMeasure + ((ChartDateTimeData)othersData.get(k)).getValue()));
                                othersData.set(k, chartDateTimeData);
                                continue block44;
                            }
                            case 2: {
                                chartDateTimeData = new ChartDateTimeData(seriesJobData.getDate(), Long.valueOf(seriesJobData.getMaxInvocationTime() / this.unitMeasure + ((ChartDateTimeData)othersData.get(k)).getValue()));
                                othersData.set(k, chartDateTimeData);
                                continue block44;
                            }
                            case 3: {
                                chartDateTimeData = new ChartDateTimeData(seriesJobData.getDate(), Long.valueOf(seriesJobData.getMinInvocationTime() / this.unitMeasure + ((ChartDateTimeData)othersData.get(k)).getValue()));
                                othersData.set(k, chartDateTimeData);
                                continue block44;
                            }
                            case 4: {
                                chartDateTimeData = new ChartDateTimeData(seriesJobData.getDate(), Long.valueOf(seriesJobData.getOperationCount() + ((ChartDateTimeData)othersData.get(k)).getValue()));
                                othersData.set(k, chartDateTimeData);
                                continue block44;
                            }
                            default: {
                                chartDateTimeData = new ChartDateTimeData(seriesJobData.getDate(), Long.valueOf(seriesJobData.getDuration() / this.unitMeasure + ((ChartDateTimeData)othersData.get(k)).getValue()));
                                othersData.set(k, chartDateTimeData);
                            }
                        }
                    }
                }
                Array arrayData = seriesColumnData.dataAsArrayObject();
                for (ChartDateTimeData chartDateTimeData : othersData) {
                    long dateFrom1970 = chartDateTimeData.getDate().getTime();
                    Log.debug((String)("SeriersOthersData: " + chartDateTimeData.getDate()));
                    Log.debug((String)("SeriersOthersData: " + dateFrom1970));
                    Data data = highchartsFactory.createSeriesColumnData();
                    data.x((double)dateFrom1970);
                    data.y((double)chartDateTimeData.getValue().longValue());
                    arrayData.addToEnd((Object)data);
                }
                seriesColumn.add(seriesColumnData);
            }
        }
    }

    private void createSeriesColumnSimple(SeriesJobTop seriesJobTop, HighchartsOptionFactory highchartsFactory, ArrayString colors, ArrayList<SeriesColumn> seriesColumn) {
        Log.debug((String)"Series Simple");
        if (this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.DAILY) == 0 || this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.HOURLY) == 0 || this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.MINUTELY) == 0) {
            double minRange = ChartTimeMeasure.calculateMinRange((AccountingPeriod)this.accountingStateData.getSeriesRequest().getAccountingPeriod());
            double interval = ChartTimeMeasure.calculateInterval((AccountingPeriod)this.accountingStateData.getSeriesRequest().getAccountingPeriod());
            Date dateStart = this.dtf.parse(this.accountingStateData.getSeriesRequest().getAccountingPeriod().getStartDate());
            dateStart.setTime(dateStart.getTime() + ChartTimeMeasure.timeZoneOffset() * 60000L);
            Log.debug((String)("BuildChart DateStart: " + DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_FULL).format(dateStart)));
            this.options.xAxis().type("datetime");
            this.options.xAxis().minRange(minRange);
            this.options.tooltip().xDateFormat("Selected Data");
            for (int i = 0; i < seriesJobTop.getSeriesJobDataTopList().size(); ++i) {
                SeriesColumn seriesColumnData = highchartsFactory.createSeriesColumn();
                seriesColumnData.name(((SeriesJobDataTop)seriesJobTop.getSeriesJobDataTopList().get(i)).getFilterValue().getValue());
                seriesColumnData.color(colors.get(i));
                seriesColumnData.type("column");
                ArrayNumber data = seriesColumnData.dataAsArrayNumber();
                block13: for (SeriesJobData seriesJobData : ((SeriesJobDataTop)seriesJobTop.getSeriesJobDataTopList().get(i)).getSeries()) {
                    switch (16.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$maindata$charts$utils$JobChartMeasure[this.measure.ordinal()]) {
                        case 1: {
                            data.push((double)(seriesJobData.getDuration() / this.unitMeasure));
                            continue block13;
                        }
                        case 2: {
                            data.push((double)(seriesJobData.getMaxInvocationTime() / this.unitMeasure));
                            continue block13;
                        }
                        case 3: {
                            data.push((double)(seriesJobData.getMinInvocationTime() / this.unitMeasure));
                            continue block13;
                        }
                        case 4: {
                            data.push((double)seriesJobData.getOperationCount().longValue());
                            continue block13;
                        }
                    }
                    data.push((double)(seriesJobData.getDuration() / this.unitMeasure));
                }
                seriesColumnData.pointInterval(interval).pointStart((double)dateStart.getTime());
                seriesColumn.add(seriesColumnData);
            }
        } else {
            this.options.xAxis().type("datetime");
            if (this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.MONTHLY) == 0) {
                this.options.tooltip().xDateFormat("Selected Data");
            } else if (this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.YEARLY) == 0) {
                this.options.tooltip().xDateFormat("Selected Data");
            } else {
                this.options.tooltip().xDateFormat("Selected Data");
            }
            for (int i = 0; i < seriesJobTop.getSeriesJobDataTopList().size(); ++i) {
                SeriesColumn seriesColumnData = highchartsFactory.createSeriesColumn();
                seriesColumnData.name(((SeriesJobDataTop)seriesJobTop.getSeriesJobDataTopList().get(i)).getFilterValue().getValue());
                seriesColumnData.color(colors.get(i));
                seriesColumnData.type("column");
                Array arrayData = seriesColumnData.dataAsArrayObject();
                block15: for (SeriesJobData seriesJobData : ((SeriesJobDataTop)seriesJobTop.getSeriesJobDataTopList().get(i)).getSeries()) {
                    long dateFrom1970 = seriesJobData.getDate().getTime();
                    Log.debug((String)("SeriersJobData: " + seriesJobData.getDate()));
                    Log.debug((String)("SeriersJobData: " + dateFrom1970));
                    Data data = highchartsFactory.createSeriesColumnData();
                    switch (16.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$maindata$charts$utils$JobChartMeasure[this.measure.ordinal()]) {
                        case 1: {
                            data.x((double)dateFrom1970);
                            data.y((double)(seriesJobData.getDuration() / this.unitMeasure));
                            arrayData.addToEnd((Object)data);
                            continue block15;
                        }
                        case 2: {
                            data.x((double)dateFrom1970);
                            data.y((double)(seriesJobData.getMaxInvocationTime() / this.unitMeasure));
                            arrayData.addToEnd((Object)data);
                            continue block15;
                        }
                        case 3: {
                            data.x((double)dateFrom1970);
                            data.y((double)(seriesJobData.getMinInvocationTime() / this.unitMeasure));
                            arrayData.addToEnd((Object)data);
                            continue block15;
                        }
                        case 4: {
                            data.x((double)dateFrom1970);
                            data.y((double)seriesJobData.getOperationCount().longValue());
                            arrayData.addToEnd((Object)data);
                            continue block15;
                        }
                    }
                    data.x((double)dateFrom1970);
                    data.y((double)(seriesJobData.getDuration() / this.unitMeasure));
                    arrayData.addToEnd((Object)data);
                }
                seriesColumn.add(seriesColumnData);
            }
        }
    }

    private String retrieveYAxis(ArrayString colors) {
        switch (16.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$maindata$charts$utils$JobChartMeasure[this.measure.ordinal()]) {
            case 1: {
                return "[{ \"id\": \"" + JobChartMeasure.Duration.name() + "\"," + " \"labels\": {" + "    \"format\": \"{value} " + this.unitMeasureLabel + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "     }" + " }," + " \"stackLabels\": {" + " \"enabled\": \"true\"," + " \"style\": {" + "     \"fontWeight\": \"bold\"," + "    \"color\": \"gray\"" + "   } " + "   }," + " \"title\": { " + "    \"text\": \"" + JobChartMeasure.Duration.getLabel() + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "    }" + " }" + "}]";
            }
            case 2: {
                return "[{ \"id\": \"" + JobChartMeasure.MaxInvocationTime.name() + "\"," + " \"labels\": {" + "    \"format\": \"{value} " + this.unitMeasureLabel + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "     }" + " }," + " \"stackLabels\": {" + " \"enabled\": \"true\"," + " \"style\": {" + "     \"fontWeight\": \"bold\"," + "    \"color\": \"gray\"" + "   } " + "   }," + " \"title\": { " + "    \"text\": \"" + JobChartMeasure.MaxInvocationTime.getLabel() + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "    }" + " }" + "}]";
            }
            case 3: {
                return "[{ \"id\": \"" + JobChartMeasure.MinInvocationTime.name() + "\"," + " \"labels\": {" + "    \"format\": \"{value} " + this.unitMeasureLabel + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "     }" + " }," + " \"stackLabels\": {" + " \"enabled\": \"true\"," + " \"style\": {" + "     \"fontWeight\": \"bold\"," + "    \"color\": \"gray\"" + "   } " + "   }," + " \"title\": { " + "    \"text\": \"" + JobChartMeasure.MinInvocationTime.getLabel() + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "    }" + " }" + "}]";
            }
            case 4: {
                return "[{ \"id\": \"" + JobChartMeasure.OperationCount.name() + "\"," + " \"labels\": { " + "    \"format\": \"{value}\"," + "    \"style\": { " + "      \"color\": \"" + colors.get(1) + "\"" + "    }" + " }," + " \"stackLabels\": {" + " \"enabled\": \"true\"," + " \"style\": {" + "     \"fontWeight\": \"bold\"," + "    \"color\": \"gray\"" + "   } " + "   }," + " \"title\": { " + "    \"text\": \"" + JobChartMeasure.OperationCount.getLabel() + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "    }" + " }" + "}]";
            }
        }
        return "[{ \"id\": \"" + JobChartMeasure.Duration.name() + "\"," + " \"labels\": {" + "    \"format\": \"{value} " + this.unitMeasureLabel + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "     }" + " }," + " \"stackLabels\": {" + " \"enabled\": \"true\"," + " \"style\": {" + "     \"fontWeight\": \"bold\"," + "    \"color\": \"gray\"" + "   } " + "   }," + " \"title\": { " + "    \"text\": \"" + JobChartMeasure.Duration.getLabel() + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "    }" + " }" + "}]";
    }

    static /* synthetic */ void access$000(JobChartTopPanel x0) {
        x0.onDownloadCSV();
    }

    static /* synthetic */ void access$100(JobChartTopPanel x0) {
        x0.onDownloadXML();
    }

    static /* synthetic */ void access$200(JobChartTopPanel x0) {
        x0.onDownloadJSON();
    }

    static /* synthetic */ HighchartsLayoutPanel access$300(JobChartTopPanel x0) {
        return x0.highchartsLayoutPanel;
    }

    static /* synthetic */ TextButton access$400(JobChartTopPanel x0) {
        return x0.measureButton;
    }

    static /* synthetic */ JobChartMeasure access$502(JobChartTopPanel x0, JobChartMeasure x1) {
        x0.measure = x1;
        return x0.measure;
    }

    static /* synthetic */ TextButton access$600(JobChartTopPanel x0) {
        return x0.unitButton;
    }

    static /* synthetic */ void access$700(JobChartTopPanel x0) {
        x0.updateChart();
    }

    static /* synthetic */ long access$802(JobChartTopPanel x0, long x1) {
        x0.unitMeasure = x1;
        return x0.unitMeasure;
    }

    static /* synthetic */ String access$902(JobChartTopPanel x0, String x1) {
        x0.unitMeasureLabel = x1;
        return x0.unitMeasureLabel;
    }
}

