/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.query;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.datamodel.aggregation.AggregatedJobUsageRecord;
import org.gcube.portlets.admin.accountingmanager.server.amservice.PeriodModeMap;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuery;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQueryBasic;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQueryBuilder;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQueryContext;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQueryTop;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilter;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilterBasic;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilterContext;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilterTop;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingPeriodMode;
import org.gcube.portlets.admin.accountingmanager.shared.data.query.SeriesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingQuery4Job
extends AccountingQueryBuilder {
    protected static Logger logger = LoggerFactory.getLogger(AccountingQuery4Job.class);
    private SeriesRequest seriesRequest;

    public AccountingQuery4Job(SeriesRequest seriesRequest) {
        this.seriesRequest = seriesRequest;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void buildOpEx() throws ServiceException {
        AccountingQueryBasic invocation;
        block15: {
            block16: {
                Calendar startCalendar = GregorianCalendar.getInstance(TemporalConstraint.DEFAULT_TIME_ZONE);
                try {
                    startCalendar.setTime(this.sdf.parse(this.seriesRequest.getAccountingPeriod().getStartDate()));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    throw new ServiceException("Start Date not valid!");
                }
                Calendar endCalendar = GregorianCalendar.getInstance(TemporalConstraint.DEFAULT_TIME_ZONE);
                try {
                    endCalendar.setTime(this.sdf.parse(this.seriesRequest.getAccountingPeriod().getEndDate()));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    throw new ServiceException("End Date not valid!");
                }
                endCalendar.set(11, 23);
                endCalendar.set(12, 59);
                endCalendar.set(13, 59);
                endCalendar.set(14, 999);
                TemporalConstraint temporalConstraint = new TemporalConstraint(startCalendar.getTimeInMillis(), endCalendar.getTimeInMillis(), PeriodModeMap.getMode((AccountingPeriodMode)this.seriesRequest.getAccountingPeriod().getPeriod()));
                ArrayList<Filter> filters = null;
                ArrayList accountingFilters = null;
                invocation = null;
                if (this.seriesRequest == null || this.seriesRequest.getAccountingFilterDefinition() == null) break block16;
                if (this.seriesRequest.getAccountingFilterDefinition() instanceof AccountingFilterBasic) {
                    AccountingFilterBasic accountingFilterBasic = (AccountingFilterBasic)this.seriesRequest.getAccountingFilterDefinition();
                    accountingFilters = accountingFilterBasic.getFilters();
                    filters = new ArrayList<Filter>();
                    if (accountingFilters != null) {
                        for (AccountingFilter accountigFilters : accountingFilters) {
                            Filter filter = new Filter(accountigFilters.getFilterKey().getKey(), accountigFilters.getFilterValue());
                            filters.add(filter);
                        }
                    }
                    invocation = new AccountingQueryBasic(AggregatedJobUsageRecord.class, temporalConstraint, filters, accountingFilterBasic.isNoContext());
                    break block15;
                } else if (this.seriesRequest.getAccountingFilterDefinition() instanceof AccountingFilterTop) {
                    AccountingFilterTop accountingFilterTop = (AccountingFilterTop)this.seriesRequest.getAccountingFilterDefinition();
                    accountingFilters = accountingFilterTop.getFilters();
                    filters = new ArrayList();
                    if (accountingFilters != null) {
                        for (AccountingFilter accountigFilters : accountingFilters) {
                            Filter filter = new Filter(accountigFilters.getFilterKey().getKey(), accountigFilters.getFilterValue());
                            filters.add(filter);
                        }
                    }
                    invocation = new AccountingQueryTop(AggregatedJobUsageRecord.class, accountingFilterTop.getFilterKey(), accountingFilterTop.getShowOthers(), accountingFilterTop.getTopNumber(), temporalConstraint, filters);
                    break block15;
                } else {
                    if (!(this.seriesRequest.getAccountingFilterDefinition() instanceof AccountingFilterContext)) {
                        logger.error("Invalid Request: " + this.seriesRequest);
                        throw new ServiceException("Invalid Request!");
                    }
                    AccountingFilterContext accountingFilterContext = (AccountingFilterContext)this.seriesRequest.getAccountingFilterDefinition();
                    accountingFilters = accountingFilterContext.getFilters();
                    filters = new ArrayList();
                    if (accountingFilters != null) {
                        for (AccountingFilter accountigFilters : accountingFilters) {
                            Filter filter = new Filter(accountigFilters.getFilterKey().getKey(), accountigFilters.getFilterValue());
                            filters.add(filter);
                        }
                    }
                    invocation = new AccountingQueryContext(AggregatedJobUsageRecord.class, accountingFilterContext.getContext(), temporalConstraint, filters);
                }
                break block15;
            }
            logger.error("Invalid Request: " + this.seriesRequest);
            throw new ServiceException("Invalid Request!");
        }
        this.accountingQuerySpec.setOp((AccountingQuery)invocation);
    }
}

