/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.createusers.client.ui;

import com.github.gwtbootstrap.client.ui.AlertBlock;
import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.CheckBox;
import com.github.gwtbootstrap.client.ui.Form;
import com.github.gwtbootstrap.client.ui.Image;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.portlets.admin.createusers.client.CreateUsersPanel;
import org.gcube.portlets.admin.createusers.client.HandleUsersServiceAsync;
import org.gcube.portlets.admin.createusers.client.ui.AddUserForm;

public class AddUserForm
extends Composite {
    private static AddUserFormUiBinder uiBinder = (AddUserFormUiBinder)GWT.create(AddUserFormUiBinder.class);
    public static final String imagePath = String.valueOf(GWT.getModuleBaseURL()) + "../images/loader.gif";
    @UiField
    Form form;
    @UiField
    Button submit;
    @UiField
    CheckBox sendMailCheckbox;
    @UiField
    Image performingRequest;
    @UiField
    TextBox emailTextbox;
    @UiField
    TextBox nameTextbox;
    @UiField
    TextBox surnameTextbox;
    @UiField
    TextBox companyTextbox;
    @UiField
    AlertBlock errorBlock;
    @UiField
    AlertBlock successBlock;
    private static final String NAME_SURNAME_PATTERN = "/^[a-zA-Z\u00e0\u00e1\u00e2\u00e4\u00e3\u00e5\u0105\u010d\u0107\u0119\u00e8\u00e9\u00ea\u00eb\u0117\u012f\u00ec\u00ed\u00ee\u00ef\u0142\u0144\u00f2\u00f3\u00f4\u00f6\u00f5\u00f8\u00f9\u00fa\u00fb\u00fc\u0173\u016b\u00ff\u00fd\u017c\u017a\u00f1\u00e7\u010d\u0161\u017e\u00c0\u00c1\u00c2\u00c4\u00c3\u00c5\u0104\u0106\u010c\u0116\u0118\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u012e\u0141\u0143\u00d2\u00d3\u00d4\u00d6\u00d5\u00d8\u00d9\u00da\u00db\u00dc\u0172\u016a\u0178\u00dd\u017b\u0179\u00d1\u00df\u00c7\u0152\u00c6\u010c\u0160\u017d\u2202\u00f0 ,.'-]+$/u";
    private static final String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private static final int HIDE_AFTER_MILLISECONDS = 10000;
    private final HandleUsersServiceAsync registrationService;
    private final HandlerManager eventBus;
    private final CreateUsersPanel parent;

    public AddUserForm(HandleUsersServiceAsync userServices, HandlerManager eventBus, CreateUsersPanel parent) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.registrationService = userServices;
        this.eventBus = eventBus;
        this.parent = parent;
        this.performingRequest.setUrl(imagePath);
    }

    protected void onAttach() {
        super.onAttach();
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    @UiHandler(value={"submit"})
    void onClick(ClickEvent e) {
        String actualName = this.nameTextbox.getText().trim();
        String actualSurname = this.surnameTextbox.getText().trim();
        String actualEmail = this.emailTextbox.getText().trim();
        String actualCompany = this.companyTextbox.getText().trim();
        if (actualEmail.isEmpty() || !actualEmail.matches(EMAIL_PATTERN)) {
            this.showError("Wrong or empty Email field");
            return;
        }
        if (actualName.isEmpty() || !actualName.matches(NAME_SURNAME_PATTERN)) {
            this.showError("Wrong or empty Name field");
            return;
        }
        if (actualSurname.isEmpty() || !actualSurname.matches(NAME_SURNAME_PATTERN)) {
            this.showError("Wrong or empty Surname field");
            return;
        }
        boolean presentTable = this.parent.isUserPresent(actualEmail);
        if (presentTable) {
            this.showAlertBlockThenHide(this.errorBlock, "Please note that a user with this email already exists", 10000);
        } else {
            this.performingRequest.setVisible(true);
            this.submit.setEnabled(false);
            this.registrationService.register(actualName, actualSurname, actualCompany, actualEmail, this.sendMailCheckbox.getValue().booleanValue(), true, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.form.reset();
    }

    private void showAlertBlockThenHide(AlertBlock alert, String msg, int hideAfterMs) {
        this.performingRequest.setVisible(false);
        this.submit.setEnabled(true);
        alert.setText(msg);
        alert.setVisible(true);
        3 t = new /* Unavailable Anonymous Inner Class!! */;
        t.schedule(hideAfterMs);
    }

    private void showError(String msg) {
        this.errorBlock.setText(msg);
        this.errorBlock.setVisible(true);
    }

    private void hideAlertBlocks() {
        this.errorBlock.setVisible(false);
        this.successBlock.setVisible(false);
    }

    @UiHandler(value={"emailTextbox"})
    void onChangeEmailTextbox(KeyUpEvent event) {
        this.hideAlertBlocks();
    }

    @UiHandler(value={"nameTextbox"})
    void onChangeNameTextbox(KeyUpEvent event) {
        this.hideAlertBlocks();
    }

    @UiHandler(value={"surnameTextbox"})
    void onChangeSurnameTextbox(KeyUpEvent event) {
        this.hideAlertBlocks();
    }

    @UiHandler(value={"companyTextbox"})
    void onChangeCompanyTextbox(KeyUpEvent event) {
        this.hideAlertBlocks();
    }

    static /* synthetic */ void access$0(AddUserForm addUserForm, AlertBlock alertBlock, String string, int n) {
        addUserForm.showAlertBlockThenHide(alertBlock, string, n);
    }

    static /* synthetic */ HandlerManager access$1(AddUserForm addUserForm) {
        return addUserForm.eventBus;
    }
}

