/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.dataminermanagerdeployer.server;

import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portlets.admin.dataminermanagerdeployer.server.util.ServiceCredentials;
import org.gcube.portlets.admin.dataminermanagerdeployer.shared.exception.ServiceException;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;

public class SessionUtil {
    private static final Logger logger = Logger.getLogger(SessionUtil.class);

    public static ServiceCredentials getServiceCredentials(HttpServletRequest httpServletRequest, String token) throws ServiceException {
        AuthorizationEntry entry;
        ServiceCredentials sCredentials = null;
        String userName = null;
        String scope = null;
        String groupId = null;
        String groupName = null;
        logger.debug((Object)"Retrieving credential in session!");
        PortalContext pContext = PortalContext.getConfiguration();
        logger.debug((Object)("Set SecurityToken: " + token));
        SecurityTokenProvider.instance.set(token);
        try {
            entry = Constants.authorizationService().get(token);
        }
        catch (Exception e) {
            throw new ServiceException("AuthorizationEntry not found: " + e.getLocalizedMessage(), (Throwable)e);
        }
        scope = entry.getContext();
        logger.debug((Object)("Set ScopeProvider: " + scope));
        ScopeProvider.instance.set(scope);
        if (scope == null || scope.isEmpty()) {
            String error = "Error retrieving scope: " + scope;
            logger.error((Object)error);
            throw new ServiceException(error);
        }
        GCubeUser gCubeUser = pContext.getCurrentUser(httpServletRequest);
        if (gCubeUser == null) {
            String error = "Error retrieving gCubeUser in scope " + scope + ": " + gCubeUser;
            logger.error((Object)error);
            throw new ServiceException(error);
        }
        userName = gCubeUser.getUsername();
        if (userName == null || userName.isEmpty()) {
            String error = "Error retrieving username in scope " + scope + ": " + userName;
            logger.error((Object)error);
            throw new ServiceException(error);
        }
        token = pContext.getCurrentUserToken(scope, userName);
        if (token == null || token.isEmpty()) {
            String error = "Error retrieving token for " + userName + " in " + scope + ": " + token;
            logger.error((Object)error);
            throw new ServiceException(error);
        }
        String name = gCubeUser.getFirstName();
        String lastName = gCubeUser.getLastName();
        String fullName = gCubeUser.getFullname();
        String userAvatarURL = gCubeUser.getUserAvatarURL();
        String email = gCubeUser.getEmail();
        sCredentials = new ServiceCredentials(userName, fullName, name, lastName, email, scope, groupId, groupName, userAvatarURL, token);
        logger.debug((Object)("ServiceCredentials: " + sCredentials));
        return sCredentials;
    }
}

