/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.dataminermanagerdeployer.server.is;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.ScopeGroup;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portlets.admin.dataminermanagerdeployer.shared.exception.ServiceException;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformationSystemUtils {
    private static Logger logger = LoggerFactory.getLogger(InformationSystemUtils.class);

    public static String retrieveDataMinerPoolManager(String scope) throws ServiceException {
        try {
            logger.debug("Retrieve dataminer-pool-manager");
            if (scope == null || scope.length() == 0) {
                return null;
            }
            ScopeProvider.instance.set(scope);
            logger.debug("Retrieve DataMiner Pool Manager resource in scope: " + scope);
            XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
            query.addCondition("$resource/Profile/ServiceClass/text() eq 'DataAnalysis'").addCondition("$resource/Profile/ServiceName/text() eq 'dataminer-pool-manager'").setResult("$resource");
            DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
            List dataMinerPoolManagerResources = client.submit((Query)query);
            logger.debug("Resources: " + dataMinerPoolManagerResources);
            String poolManagerURI = null;
            for (GCoreEndpoint gCoreEndpoint : dataMinerPoolManagerResources) {
                if (gCoreEndpoint.scopes() == null) continue;
                ScopeGroup scopes = gCoreEndpoint.scopes();
                Iterator iterator = scopes.iterator();
                String scopeFound = null;
                boolean found = false;
                while (iterator.hasNext() && !found) {
                    scopeFound = (String)iterator.next();
                    if (scopeFound.compareTo(scope) != 0) continue;
                    found = true;
                }
                if (!found) continue;
                try {
                    logger.debug("DataMiner PoolManager Endpoints map: " + gCoreEndpoint.profile().endpointMap());
                    Map endpointMap = gCoreEndpoint.profile().endpointMap();
                    GCoreEndpoint.Profile.Endpoint dataMinerEndpoint = (GCoreEndpoint.Profile.Endpoint)endpointMap.get("REST-API");
                    logger.debug("DataMiner PoolManager Endpoint: " + dataMinerEndpoint);
                    if (dataMinerEndpoint == null || dataMinerEndpoint.uri() == null) break;
                    poolManagerURI = dataMinerEndpoint.uri().toString();
                    break;
                }
                catch (Throwable e) {
                    String error = "Error in discovery DataMiner PoolManager gCubeEndpoint resource on IS in scope: " + scope;
                    logger.error(error);
                    logger.error("Error {resource=" + gCoreEndpoint + ", error=" + e.getLocalizedMessage() + "}");
                    e.printStackTrace();
                    throw new ServiceException(error, e);
                }
            }
            logger.debug("DataMiner PoolManager URI: " + poolManagerURI);
            return poolManagerURI;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Throwable e) {
            String error = "Error in discovery DataMiner PoolManager gCubeEndpoint resource on IS in scope : " + scope;
            logger.error(error);
            logger.error("Error: " + e.getLocalizedMessage(), e);
            throw new ServiceException(error, e);
        }
    }
}

