/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.dataminermanagerdeployer.client.application.deployconfig;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.gwtplatform.mvp.client.ViewWithUiHandlers;
import gwt.material.design.client.constants.Color;
import gwt.material.design.client.constants.IconType;
import gwt.material.design.client.ui.MaterialButton;
import gwt.material.design.client.ui.MaterialListBox;
import gwt.material.design.client.ui.MaterialTextArea;
import gwt.material.design.client.ui.MaterialTextBox;
import gwt.material.design.client.ui.animate.MaterialAnimation;
import gwt.material.design.client.ui.animate.Transition;
import javax.inject.Inject;
import org.gcube.portlets.admin.dataminermanagerdeployer.client.application.deployconfig.DeployConfPresenter;
import org.gcube.portlets.admin.dataminermanagerdeployer.client.application.deployconfig.DeployConfUiHandlers;
import org.gcube.portlets.admin.dataminermanagerdeployer.client.application.deployconfig.DeployConfView;
import org.gcube.portlets.admin.dataminermanagerdeployer.shared.config.DMDeployConfig;
import org.gcube.portlets.admin.dataminermanagerdeployer.shared.config.DeployType;

class DeployConfView
extends ViewWithUiHandlers<DeployConfUiHandlers>
implements DeployConfPresenter.PresenterView {
    @UiField
    MaterialTextBox targetVRE;
    @UiField
    MaterialTextBox algorithmPackageURL;
    @UiField
    MaterialTextBox algorithmCategory;
    @UiField
    MaterialListBox deployType;
    @UiField
    MaterialTextArea result;
    @UiField
    MaterialButton resultIcon;
    @UiField
    MaterialButton run;

    @Inject
    DeployConfView(Binder uiBinder) {
        this.initWidget((IsWidget)uiBinder.createAndBindUi((Object)this));
        this.deployType.clear();
        for (DeployType tType : DeployType.values()) {
            this.deployType.add((Object)tType.getLabel());
        }
    }

    @UiHandler(value={"run"})
    void onClick(ClickEvent e) {
        String targetVREValue = (String)this.targetVRE.getValue();
        String algorithmPackageURLValue = (String)this.algorithmPackageURL.getValue();
        String algorithmCategoryValue = (String)this.algorithmCategory.getValue();
        String deployTypeValue = (String)this.deployType.getValue();
        this.resultIcon.setVisible(false);
        this.result.setVisible(false);
        DMDeployConfig dmConfig = new DMDeployConfig(targetVREValue, algorithmPackageURLValue, algorithmCategoryValue, deployTypeValue);
        ((DeployConfUiHandlers)this.getUiHandlers()).executeDeploy(dmConfig);
    }

    public void setResult(String resultValue, boolean success) {
        this.resultIcon.setVisible(true);
        this.result.setVisible(true);
        if (success) {
            this.resultIcon.setIconType(IconType.CHECK_CIRCLE);
            this.resultIcon.setBackgroundColor(Color.GREEN);
            this.resultIcon.setIconFontSize(4.0, Style.Unit.EM);
        } else {
            this.resultIcon.setIconType(IconType.ERROR);
            this.resultIcon.setBackgroundColor(Color.RED);
            this.resultIcon.setIconFontSize(4.0, Style.Unit.EM);
        }
        MaterialAnimation animation = new MaterialAnimation();
        animation.setDelay(0);
        animation.setDuration(1000);
        animation.transition(Transition.FLIPINX);
        animation.animate((Widget)this.resultIcon);
        this.result.setLength(resultValue.length());
        this.result.setValue((Object)resultValue);
        this.result.reinitialize();
    }
}

