/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.resourcemanagement.client.widgets.taskbar;

import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.ToolButton;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import org.gcube.portlets.admin.resourcemanagement.client.widgets.console.ConsoleMessageBroker;
import org.gcube.portlets.admin.resourcemanagement.client.widgets.taskbar.TaskbarItem;
import org.gcube.portlets.admin.resourcemanagement.client.widgets.taskbar.TaskbarRegister;
import org.gcube.portlets.admin.resourcemanagement.shared.Configuration;

public class TaskbarWindow
extends Window {
    private TaskbarItem relatedItem = null;
    private boolean isMinimized = false;

    protected TaskbarWindow(TaskbarItem relatedItem) {
        this.setModal(false);
        this.setClosable(false);
        this.setLayout((Layout)new FitLayout());
        this.relatedItem = relatedItem;
        this.setWidth(800);
        this.setHeight(500);
        this.getHeader().addTool((Component)new ToolButton("x-tool-minimize", (SelectionListener)new /* Unavailable Anonymous Inner Class!! */));
        if (Configuration.openProfileOnLoad) {
            this.show();
        }
    }

    protected final void doClose() {
        ConsoleMessageBroker.trace((Object)this, (String)("Closing taskbar item: " + this.relatedItem.getResourceID()));
        this.relatedItem.destroy();
        this.hide();
    }

    protected final void doMinimize() {
        if (this.isMinimized) {
            if (!Configuration.allowMultipleProfiles) {
                TaskbarRegister.minimizeAll();
            }
            this.show();
            this.relatedItem.activate();
        } else {
            this.hide();
            this.relatedItem.disactivate();
        }
        this.isMinimized = !this.isMinimized;
    }

    public final void setIsMinimized(boolean minimized) {
        this.isMinimized = minimized;
    }

    public final boolean isMinimized() {
        return this.isMinimized;
    }

    public final void setMainWidget(Component widget) {
        this.removeAll();
        this.add(widget);
        this.layout(true);
    }
}

