/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.resourcemanagement.server;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.QueryParameter;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.portlets.admin.resourcemanagement.client.remote.ServiceProxy;
import org.gcube.portlets.admin.resourcemanagement.server.ResourceCommands;
import org.gcube.portlets.admin.resourcemanagement.server.gcube.services.StatusHandler;
import org.gcube.portlets.admin.resourcemanagement.server.gcube.services.configuration.ConfigurationLoader;
import org.gcube.resourcemanagement.support.client.utils.CurrentStatus;
import org.gcube.resourcemanagement.support.client.views.ResourceTypeDecorator;
import org.gcube.resourcemanagement.support.server.gcube.CacheManager;
import org.gcube.resourcemanagement.support.server.gcube.ISClientRequester;
import org.gcube.resourcemanagement.support.server.gcube.queries.QueryLoader;
import org.gcube.resourcemanagement.support.server.gcube.queries.QueryLocation;
import org.gcube.resourcemanagement.support.server.managers.resources.GenericResourceManager;
import org.gcube.resourcemanagement.support.server.managers.resources.ManagementUtils;
import org.gcube.resourcemanagement.support.server.managers.resources.ResourceFactory;
import org.gcube.resourcemanagement.support.server.managers.scope.ScopeManager;
import org.gcube.resourcemanagement.support.server.types.AllowedResourceTypes;
import org.gcube.resourcemanagement.support.server.utils.ServerConsole;
import org.gcube.resourcemanagement.support.shared.exceptions.InvalidPermissionsException;
import org.gcube.resourcemanagement.support.shared.operations.SupportedOperations;
import org.gcube.resourcemanagement.support.shared.plugins.GenericResourcePlugin;
import org.gcube.resourcemanagement.support.shared.types.Tuple;
import org.gcube.resourcemanagement.support.shared.types.UserGroup;
import org.gcube.resourcemanagement.support.shared.types.datamodel.CompleteResourceProfile;
import org.gcube.resourcemanagement.support.shared.types.datamodel.ResourceDescriptor;
import org.gcube.resourcemanagement.support.shared.util.Assertion;
import org.gcube.vremanagement.resourcemanager.stubs.reporting.ReportingPortType;

public class ServiceProxyImpl
extends RemoteServiceServlet
implements ServiceProxy {
    private static final String LOG_PREFIX = "[SERVICE-IMPL]";

    public final void emptyCache() {
        ISClientRequester.emptyCache();
    }

    public final void setUseCache(boolean flag) {
        this.getCurrentStatus().setUseCache(flag);
    }

    public final void setSuperUser(boolean superUser) {
        if (superUser && this.getCurrentStatus().getCredentials() == UserGroup.DEBUG) {
            this.getCurrentStatus().setCredentials(UserGroup.ADMIN);
        } else {
            this.getCurrentStatus().setCredentials(UserGroup.DEBUG);
        }
        this.initScopes(true);
    }

    public final CurrentStatus initStatus() {
        ServerConsole.trace((String)LOG_PREFIX, (String)"[INIT-STATUS] initializing config parameters");
        ServerConsole.info((String)LOG_PREFIX, (String)"Clearing status");
        StatusHandler.clearStatus((HttpSession)this.getHttpSession());
        ConfigurationLoader.setConfigurationFile((String)(this.getPropertiesFSPath() + File.separator + "resourcemanagement.properties"));
        return this.getCurrentStatus();
    }

    private HttpSession getHttpSession() {
        return this.getThreadLocalRequest().getSession();
    }

    public final void initScopes(boolean doClean) {
        ServerConsole.trace((String)LOG_PREFIX, (String)("[INIT-SCOPES] initializing scopes from: " + this.getScopeDataPath()));
        try {
            ScopeManager.setScopeConfigFile((String)this.getScopeDataPath());
            if (doClean) {
                ScopeManager.clear();
            }
            ScopeManager.update();
        }
        catch (Exception e) {
            ServerConsole.error((String)LOG_PREFIX, (String)"During scope caching", (Throwable)e);
        }
    }

    private String getServletFSPath() {
        return this.getServletContext().getRealPath("") + File.separator + "WEB-INF";
    }

    private String getPropertiesFSPath() {
        return this.getServletContext().getRealPath("") + File.separator + "conf";
    }

    private String getScopeDataPath() {
        String startDirectory = this.getServletFSPath();
        return startDirectory + File.separator + "xml" + File.separator + (this.getCurrentStatus().getCredentials() == UserGroup.ADMIN ? "scopedata_admin.xml" : "scopedata.xml");
    }

    private String getXML2HTMLMapping() {
        String startDirectory = this.getServletFSPath();
        return startDirectory + File.separator + "xml" + File.separator + "xmlverbatim.xsl";
    }

    public final Tuple<String> addResourcesToScope(String resType, List<String> resourceIDs, String scope) throws Exception {
        Assertion checker = new Assertion();
        CurrentStatus status = this.getCurrentStatus();
        checker.validate(SupportedOperations.ADD_TO_SCOPE.isAllowed(status.getCredentials()), (Throwable)new Exception("User not allowed to request this operation"));
        checker.validate(resType != null && resType.trim().length() > 0, (Throwable)new Exception("Invalid parameter type"));
        checker.validate(resourceIDs != null && resourceIDs.size() > 0, (Throwable)new Exception("Invalid parameter type"));
        checker.validate(scope != null && scope.trim().length() > 0, (Throwable)new Exception("Invalid parameter type"));
        AllowedResourceTypes type = AllowedResourceTypes.valueOf((String)resType);
        GCUBEScope targetScope = ScopeManager.getScope((String)scope);
        GCUBEScope sourceScope = ScopeManager.getScope((String)status.getCurrentScope());
        String reportID = ManagementUtils.addToExistingScope((AllowedResourceTypes)type, (String[])resourceIDs.toArray(new String[0]), (GCUBEScope)sourceScope, (GCUBEScope)targetScope);
        ReportingPortType manager = ResourceFactory.createResourceManager((AllowedResourceTypes)type).getReportResourceManager(targetScope);
        String xmlReport = manager.getReport(reportID);
        String mappingPath = this.getXML2HTMLMapping();
        String htmlReport = ISClientRequester.XML2HTML((String)xmlReport, (String)mappingPath);
        return new Tuple((Object[])new String[]{reportID, resType, xmlReport, htmlReport});
    }

    public final Tuple<String> removeResourcesFromScope(String resType, List<String> resourceIDs, String scope) throws Exception {
        Assertion checker = new Assertion();
        CurrentStatus status = this.getCurrentStatus();
        checker.validate(SupportedOperations.ADD_TO_SCOPE.isAllowed(status.getCredentials()), (Throwable)new Exception("User not allowed to request this operation"));
        checker.validate(resType != null && resType.trim().length() > 0, (Throwable)new Exception("Invalid parameter type"));
        checker.validate(resourceIDs != null && resourceIDs.size() > 0, (Throwable)new Exception("Invalid parameter type"));
        checker.validate(scope != null && scope.trim().length() > 0, (Throwable)new Exception("Invalid parameter type"));
        AllowedResourceTypes type = AllowedResourceTypes.valueOf((String)resType);
        GCUBEScope targetScope = ScopeManager.getScope((String)scope);
        GCUBEScope sourceScope = ScopeManager.getScope((String)status.getCurrentScope());
        return new Tuple((Object[])new String[]{ManagementUtils.removeFromExistingScope((AllowedResourceTypes)type, (String[])resourceIDs.toArray(new String[0]), (GCUBEScope)sourceScope, (GCUBEScope)targetScope)});
    }

    public final String deploy(List<String> ghnsID, List<String> servicesID) throws Exception {
        try {
            GCUBEScope sourceScope = ScopeManager.getScope((String)this.getCurrentStatus().getCurrentScope());
            String[] param1 = ghnsID.toArray(new String[0]);
            String[] param2 = servicesID.toArray(new String[0]);
            return ManagementUtils.deploy((GCUBEScope)sourceScope, (String[])param1, (String[])param2);
        }
        catch (Exception e) {
            ServerConsole.error((String)LOG_PREFIX, (String)"During service deployment", (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    public final Tuple<String> checkDeployStatus(String scope, String deployID) throws Exception {
        if (SupportedOperations.SERVICE_GET_REPORT.isAllowed(this.getCurrentStatus().getCredentials())) {
            GCUBEScope sourceScope = ScopeManager.getScope((String)scope);
            ReportingPortType manager = ResourceFactory.createResourceManager((AllowedResourceTypes)AllowedResourceTypes.Service).getReportResourceManager(sourceScope);
            String xmlReport = manager.getReport(deployID);
            String mappingPath = this.getXML2HTMLMapping();
            String htmlReport = ISClientRequester.XML2HTML((String)xmlReport, (String)mappingPath);
            return new Tuple((Object[])new String[]{deployID, xmlReport, htmlReport});
        }
        throw new Exception("The current user is not allowed to request the operation");
    }

    public final List<String> getAvailableScopes() {
        ServerConsole.trace((String)LOG_PREFIX, (String)"[GET-SCOPES] getting available scopes");
        GWT.log((String)("The CONTEXT PATH is: " + this.getScopeDataPath()));
        Vector<String> retval = new Vector<String>();
        try {
            Map scopes = ScopeManager.getAvailableScopes();
            for (GCUBEScope scope : scopes.values()) {
                retval.add(scope.toString());
            }
            return retval;
        }
        catch (Exception e) {
            retval.add("/gcube");
            retval.add("/gcube/devsec");
            return retval;
        }
    }

    public final List<String> getAvailableAddScopes() {
        Vector<String> retval = new Vector<String>();
        try {
            GCUBEScope currScope = ScopeManager.getScope((String)this.getCurrentStatus().getCurrentScope());
            List scopes = this.getAvailableScopes();
            for (String scope : scopes) {
                GCUBEScope trgScope = ScopeManager.getScope((String)scope);
                if (!trgScope.isEnclosedIn(currScope)) continue;
                retval.add(trgScope.toString());
            }
            return retval;
        }
        catch (Exception e) {
            ServerConsole.error((String)LOG_PREFIX, (Throwable)e);
            return null;
        }
    }

    public final HashMap<String, ArrayList<String>> getResourceTypeTree(String scope) throws Exception {
        try {
            GCUBEScope gscope = ScopeManager.getScope((String)scope);
            HashMap results = ISClientRequester.getResourcesTree((CacheManager)this.getCacheManager(this.getCurrentStatus()), (GCUBEScope)gscope);
            return results;
        }
        catch (Exception e) {
            ServerConsole.error((String)LOG_PREFIX, (String)"applying resource get", (Throwable)e);
            throw e;
        }
    }

    public final List<String> getRelatedResources(String type, String id, String scope) {
        try {
            return ISClientRequester.getRelatedResources((CacheManager)this.getCacheManager(this.getCurrentStatus()), (String)type, (String)id, (GCUBEScope)ScopeManager.getScope((String)scope));
        }
        catch (Exception e) {
            ServerConsole.error((String)LOG_PREFIX, (Throwable)e);
            return null;
        }
    }

    public final List<String> getResourcesByType(String scope, String type) {
        try {
            return ISClientRequester.getResourcesByType((CacheManager)this.getCacheManager(this.getCurrentStatus()), (GCUBEScope)ScopeManager.getScope((String)scope), (String)type, null);
        }
        catch (Exception e) {
            ServerConsole.error((String)LOG_PREFIX, (Throwable)e);
            return null;
        }
    }

    public final ResourceDescriptor getGenericResourceDescriptor(String scope, String resID) throws Exception {
        return this.getDescriptor(ScopeManager.getScope((String)scope), resID);
    }

    private ResourceDescriptor getDescriptor(GCUBEScope scope, String resID) throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBEGenericQuery isQuery = null;
        isQuery = (GCUBEGenericQuery)client.getQuery(GCUBEGenericQuery.class);
        isQuery.setExpression(QueryLoader.getQuery((QueryLocation)QueryLocation.GET_RESOURCE_BYID));
        isQuery.addParameters(new QueryParameter[]{new QueryParameter("RES_ID", resID), new QueryParameter("RES_TYPE", ResourceTypeDecorator.GenericResource.name())});
        List results = client.execute((ISQuery)isQuery, scope);
        if (results != null && results.size() > 0) {
            ResourceDescriptor retval = new ResourceDescriptor();
            XMLResult node = (XMLResult)results.get(0);
            List currValue = null;
            currValue = node.evaluate("/Resource/ID/text()");
            if (currValue != null && currValue.size() > 0) {
                retval.setID((String)currValue.get(0));
            }
            if ((currValue = node.evaluate("/Resource/Profile/Name/text()")) != null && currValue.size() > 0) {
                retval.setName((String)currValue.get(0));
            }
            if ((currValue = node.evaluate("/Resource/Profile/Body/node()")) != null && currValue.size() > 0) {
                StringBuilder bodytext = new StringBuilder();
                for (String line : currValue) {
                    bodytext.append(line);
                }
                retval.set("Body", (Object)bodytext.toString().trim());
            } else {
                retval.set("Body", (Object)"");
            }
            currValue = node.evaluate("/Resource/Profile/Description/text()");
            if (currValue != null && currValue.size() > 0) {
                retval.set("Description", currValue.get(0));
            } else {
                retval.set("Description", (Object)"");
            }
            currValue = node.evaluate("/Resource/Profile/SecondaryType/text()");
            if (currValue != null && currValue.size() > 0) {
                retval.set("SecondaryType", currValue.get(0));
            } else {
                retval.set("SecondaryType", (Object)"");
            }
            return retval;
        }
        return null;
    }

    public final List<ResourceDescriptor> getResourcesModel(String scope, String type, String subType, List<Tuple<String>> additionalMaps) throws Exception {
        if (scope == null || type == null) {
            return null;
        }
        return ISClientRequester.getResourceModels((GCUBEScope)ScopeManager.getScope((String)scope), (String)type, (String)subType, additionalMaps);
    }

    public final List<String> getWSResources(String scope) {
        try {
            return ISClientRequester.getWSResources((GCUBEScope)ScopeManager.getScope((String)scope));
        }
        catch (Exception e) {
            ServerConsole.error((String)LOG_PREFIX, (Throwable)e);
            return null;
        }
    }

    public final List<String> getResourcesBySubType(String scope, String type, String subtype) {
        try {
            return ISClientRequester.getResourcesByType((CacheManager)this.getCacheManager(this.getCurrentStatus()), (GCUBEScope)ScopeManager.getScope((String)scope), (String)type, (String)subtype);
        }
        catch (Exception e) {
            ServerConsole.error((String)LOG_PREFIX, (Throwable)e);
            return null;
        }
    }

    public final CompleteResourceProfile getResourceByID(String scope, String type, String resID) {
        try {
            CompleteResourceProfile profile = ISClientRequester.getResourceByID((String)this.getXML2HTMLMapping(), (GCUBEScope)ScopeManager.getScope((String)scope), (String)type, (String)resID);
            return profile;
        }
        catch (Exception e) {
            ServerConsole.error((String)LOG_PREFIX, (Throwable)e);
            return null;
        }
    }

    public final String createGenericResource(String ID, String name, String description, String body, String subType) throws Exception {
        Assertion checker = new Assertion();
        checker.validate(SupportedOperations.GENERIC_RESOURCE_CREATE.isAllowed(this.getCurrentStatus().getCredentials()), (Throwable)new InvalidPermissionsException("The user is not allowed to execute the following operation"));
        return GenericResourceManager.create((String)ID, (GCUBEScope)ScopeManager.getScope((String)this.getCurrentStatus().getCurrentScope()), (String)name, (String)description, (String)body, (String)subType);
    }

    public final void updateGenericResource(String ID, String name, String description, String body, String subType) throws Exception {
        Assertion checker = new Assertion();
        checker.validate(SupportedOperations.GENERIC_RESOURCE_EDIT.isAllowed(this.getCurrentStatus().getCredentials()), (Throwable)new InvalidPermissionsException("The user is not allowed to execute the following operation"));
        GCUBEScope sourceScope = ScopeManager.getScope((String)this.getCurrentStatus().getCurrentScope());
        GenericResourceManager resource = new GenericResourceManager(ID);
        resource.update(name, description, body, subType, sourceScope);
    }

    public final void setCurrentScope(String scope) {
        this.getCurrentStatus().setCurrentScope(scope);
    }

    public final Map<String, GenericResourcePlugin> getGenericResourcePlugins() throws Exception {
        return ISClientRequester.getGenericResourcePlugins((GCUBEScope)ScopeManager.getScope((String)this.getCurrentStatus().getCurrentScope()));
    }

    private CurrentStatus getCurrentStatus() {
        return StatusHandler.getStatus((HttpSession)this.getHttpSession());
    }

    private CacheManager getCacheManager(CurrentStatus status) {
        CacheManager cm = new CacheManager();
        cm.setUseCache(status.useCache());
        return cm;
    }

    public final void doOperation(SupportedOperations opCode, String scope, List<ResourceDescriptor> resources) throws Exception {
        try {
            ResourceCommands.doOperation((CurrentStatus)this.getCurrentStatus(), (SupportedOperations)opCode, (String)scope, resources);
        }
        catch (Exception e) {
            ServerConsole.error((String)LOG_PREFIX, (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }
}

