/****************************************************************************
 *  This software is part of the gCube Project.
 *  Site: http://www.gcube-system.org/
 ****************************************************************************
 * The gCube/gCore software is licensed as Free Open Source software
 * conveying to the EUPL (http://ec.europa.eu/idabc/eupl).
 * The software and documentation is provided by its authors/distributors
 * "as is" and no expressed or
 * implied warranty is given for its use, quality or fitness for a
 * particular case.
 ****************************************************************************
 * Filename: TaskbarButton.java
 ****************************************************************************
 * @author <a href="mailto:daniele.strollo@isti.cnr.it">Daniele Strollo</a>
 ***************************************************************************/

package org.gcube.portlets.admin.resourcemanagement.client.widgets.taskbar;

import org.gcube.portlets.admin.resourcemanagement.client.utils.FWSTranslate;

import com.extjs.gxt.ui.client.core.El;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.util.IconHelper;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.IconSupport;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.AbstractImagePrototype;

/**
 * @author Massimiliano Assante (ISTI-CNR)
 * 
 * A selectable icon (post-it styled) and text added to the pinned resources (TaskbarWindow). 
 */
public class TaskbarButton extends Component implements IconSupport {
  private String type;
  private String text;
  private AbstractImagePrototype icon;
  private El iconEl;

  /**
   * Creates a new shortcut.
   */
  public TaskbarButton() {

  }

  /**
   * Creates a new shortcut.
   *
   * @param id the shortcut id
   * @param text the shortcut text
   */
  public TaskbarButton(final String id, final String type, final String text) {
    setId(id);
    setText(text);
    this.type = type;
  }

  /**
   * Adds a selection listener.
   *
   * @param listener the listener to add
   */
  public final void addSelectionListener(final SelectionListener<? extends ComponentEvent> listener) {
    addListener(Events.Select, listener);
  }

  public final AbstractImagePrototype getIcon() {
    return icon;
  }

  /**
   * Returns the shortcuts text.
   *
   * @return the text
   */
  public final String getText() {
    return text;
  }

  @Override
  public final void onComponentEvent(final ComponentEvent ce) {
    super.onComponentEvent(ce);
    if (ce.getEventTypeInt() == Event.ONCLICK) {
      onClick(ce);
    }
  }

  /**
   * Removes a previously added listener.
   *
   * @param listener the listener to be removed
   */
  public final void removeSelectionListener(final SelectionListener<? extends ComponentEvent> listener) {
    removeListener(Events.Select, listener);
  }

  public final void setIcon(final AbstractImagePrototype icon) {
    if (rendered) {
      iconEl.setInnerHtml("");
      iconEl.appendChild((Element) icon.createElement().cast());
    }
    this.icon = icon;

  }

  public final void setIconStyle(final String icon) {
    setIcon(IconHelper.create(icon, 48, 48));

  }

  /**
   * Sets the shortcuts text.
   *
   * @param text the text
   */
  public final void setText(final String text) {
    this.text = text;
  }

  protected void onClick(final ComponentEvent ce) {
    ce.stopEvent();
    fireEvent(Events.Select, ce);
  }

  @Override
  protected final void onRender(final Element target, final int index) {
    super.onRender(target, index);
    int splitTextTo = 16;
    String style = "background:#ffc;  display:block; margin-left: 15px; margin-top: 10px; " +
    		"padding:3px; width: 120px; height: 120px;font-family:'Reenie Beanie',arial,sans-serif; font-size:19px;line-height:1;" +
    		"-moz-box-shadow:5px 5px 7px rgba(33,33,33,1);"+  
    		"-webkit-box-shadow: 5px 5px 7px rgba(33,33,33,.7);"+  
            "box-shadow: 5px 5px 7px rgba(33,33,33,.7); " +
    		"";
    
    //add the (fake) randomly tilted effect
    int rd = index + 1;
    if (rd % 2 == 0) { //even
    	style += "-o-transform:rotate(5deg); -webkit-transform:rotate(5deg); -moz-transform:rotate(5deg); position:relative;";  
    } else if (rd % 3 == 0) { // 3 times
    	style += "-o-transform:rotate(-3deg); -webkit-transform:rotate(-3deg); -moz-transform:rotate(-3deg);  position:relative; top: -5px; "; 
    } else { //antyhing else
    	style += "-o-transform:rotate(2deg); -webkit-transform:rotate(2deg); -moz-transform:rotate(2deg); position:relative;"; 
    }
    
    
    String fontStyle = "font-family:'Reenie Beanie',arial,sans-serif; font-size:20px; padding: 5px; overflow-x: hidden; overflow-y: hidden;";
    setElement(DOM.createElement("dt"), target, index);
    El a = el().createChild("<div style=\""+ style +"\"><a href='#'></a></div>");
    iconEl = a.createChild("<h2>"+FWSTranslate.getFWSNameFromLabel(type)+"</h2>");
    El txt = a.createChild("<div style=\""+fontStyle+"\" align=\"center\"></div>");
    String toShow = "";
    if (text.length() / splitTextTo > 0) {
       	int iterateTo = ((text.length() / splitTextTo) < 4) ? (text.length() / splitTextTo) : 3;
    	for (int i = 0; i < iterateTo; i++) 
    		toShow += text.substring(i*splitTextTo, (i+1)*splitTextTo) + " ";
    	
    	if (iterateTo < 4)
    		toShow += text.substring((text.length() / splitTextTo)*splitTextTo,text.length());
    }
    else 
    	toShow = text;

    if (txt != null) {
      txt.setInnerHtml(toShow);
    }
    el().updateZIndex(0);
    sinkEvents(Event.ONCLICK);
    if (icon != null) {
      setIcon(icon);
    }
  }

}
