/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.resourcemanagement.shared.resource;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.utils.ElementMapper;
import org.gcube.portlets.admin.resourcemanagement.shared.resource.CacheList;
import org.gcube.portlets.admin.resourcemanagement.shared.resource.GcoreEndPointObject;
import org.gcube.portlets.admin.resourcemanagement.shared.resource.GenericResourceObject;
import org.gcube.portlets.admin.resourcemanagement.shared.resource.HostingNodeObject;
import org.gcube.portlets.admin.resourcemanagement.shared.resource.ResourceObject;
import org.gcube.resourcemanagement.model.reference.entities.facets.AccessPointFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.MemoryFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.NetworkingFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.SimplePropertyFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.SoftwareFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.StateFacet;
import org.gcube.resourcemanagement.model.reference.entities.resources.Configuration;
import org.gcube.resourcemanagement.model.reference.entities.resources.EService;
import org.gcube.resourcemanagement.model.reference.entities.resources.HostingNode;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.HasPersistentMemory;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.HasVolatileMemory;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.IsIdentifiedBy;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtilityResource {
    private static Logger logger = LoggerFactory.getLogger(UtilityResource.class);

    public static ArrayList<String> getSubResourcesTree(ResourceRegistryClient resourceRegistryClient, String entity, String scope) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        String s = resourceRegistryClient.getInstances(entity, Boolean.valueOf(true));
        List resources = ElementMapper.unmarshalList(Resource.class, (String)s);
        for (Resource r : resources) {
            List iibs = r.getConsistsOf(IsIdentifiedBy.class);
            block11: for (IsIdentifiedBy iib : iibs) {
                Facet f = (Facet)iib.getTarget();
                switch (entity) {
                    case "HostingNode": {
                        if (!(f instanceof NetworkingFacet)) break;
                        NetworkingFacet nf = (NetworkingFacet)f;
                        if (list.contains(nf.getDomainName())) continue block11;
                        list.add(nf.getDomainName());
                        break;
                    }
                    case "Configuration": {
                        if (!(f instanceof SoftwareFacet)) break;
                        SoftwareFacet sf = (SoftwareFacet)f;
                        if (list.contains(sf.getGroup())) continue block11;
                        list.add(sf.getGroup());
                        break;
                    }
                    case "EService": {
                        if (!(f instanceof SoftwareFacet)) break;
                        logger.info("------------EService--SoftwareFacet-- identified by Gcore End point and Service End Point");
                        SoftwareFacet sf = (SoftwareFacet)f;
                        if (list.contains(sf.getGroup())) break;
                        list.add(sf.getGroup());
                    }
                }
            }
        }
        return list;
    }

    public static ArrayList<String> getSubResourcesTreeQuery(ResourceRegistryClient resourceRegistryClient, String entity) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        String field = null;
        String identifiedFacet = null;
        switch (entity) {
            case "HostingNode": {
                field = "domainName";
                identifiedFacet = "NetworkingFacet";
                break;
            }
            case "Configuration": {
                field = "group";
                identifiedFacet = "SoftwareFacet";
                break;
            }
            case "EService": {
                field = "group";
                identifiedFacet = "SoftwareFacet";
                break;
            }
            default: {
                return new ArrayList<String>(0);
            }
        }
        try {
            String query = "SELECT DISTINCT(" + field + ") AS " + field + " FROM (TRAVERSE outE('IsIdentifiedBy'),inV('" + identifiedFacet + "') FROM " + entity + ")";
            logger.info("------------query----------->" + query);
            String result = resourceRegistryClient.rawQuery(query, true);
            if (result != null && !result.isEmpty()) {
                logger.info("--------result-------->" + result);
                JSONArray jsonArray = new JSONArray(result);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    list.add(jsonArray.getJSONObject(i).get(field).toString());
                }
            } else {
                logger.info("--------result-------->Attention invalid result!");
            }
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return list;
    }

    public static List<String> createListConfigurationQuery(ResourceRegistryClient resourceRegistryClient, String typeC, String subTypeC) throws Exception {
        ArrayList<String> resource;
        block8: {
            String query = null;
            query = subTypeC == null ? "SELECT header,name, description  FROM (TRAVERSE outE('IsIdentifiedBy'),inV('SoftwareFacet') \t\tFROM Configuration WHILE $depth<=0)" : "SELECT header,name, description  FROM (TRAVERSE outE('IsIdentifiedBy'),inV('SoftwareFacet') \t\tFROM Configuration ) where group='" + subTypeC + "'";
            logger.info("------------query list configuration----------->" + query);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GenericResourceObject.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.setProperty("jaxb.fragment", (Object)true);
            resource = new ArrayList<String>();
            String id = "";
            String type = "GenericResource";
            String subType = "";
            String name = "";
            String description = "";
            String result = resourceRegistryClient.rawQuery(query, true);
            try {
                if (result != null && !result.isEmpty()) {
                    logger.info("--------result-------->" + result);
                    JSONArray jsonArray = new JSONArray(result);
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        JSONObject header = new JSONObject(jsonArray.getJSONObject(i).get("header").toString());
                        id = (String)header.get("uuid");
                        logger.info("------------id----------->" + id);
                        try {
                            name = jsonArray.getJSONObject(i).getString("name");
                        }
                        catch (Exception e) {
                            name = "";
                        }
                        try {
                            description = jsonArray.getJSONObject(i).getString("description");
                        }
                        catch (Exception e) {
                            description = "";
                        }
                        GenericResourceObject temp = new GenericResourceObject(id, type, subType, name, description, ScopeProvider.instance.get());
                        StringWriter sw = new StringWriter();
                        m.marshal((Object)temp, (Writer)sw);
                        resource.add(sw.toString());
                    }
                    break block8;
                }
                logger.info("--------result-------->Attention invalid result!");
            }
            catch (Exception e) {
                logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return resource;
    }

    public static List<String> createListEservice(ResourceRegistryClient resourceRegistryClient, String typeC, String subTypeC) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GcoreEndPointObject.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.fragment", (Object)true);
        ArrayList<String> resource = new ArrayList<String>();
        String id = "";
        String type = "EService";
        String subType = "";
        String serviceClass = "";
        String serviceName = "";
        String version = "";
        String status = "";
        String ghnName = "";
        List eservices = resourceRegistryClient.getInstances(EService.class, Boolean.valueOf(false));
        for (EService et : eservices) {
            Object f2;
            id = et.getHeader().getUUID().toString();
            List facets = et.getIdentificationFacets();
            for (Object f2 : facets) {
                if (!(f2 instanceof SoftwareFacet)) continue;
                SoftwareFacet sf = (SoftwareFacet)f2;
                version = sf.getVersion();
                serviceName = sf.getName();
                serviceClass = sf.getGroup();
                subType = sf.getGroup();
                version = sf.getVersion();
            }
            CacheList.resourceid.put(id, new ResourceObject(serviceName, et.toString()));
            ghnName = "";
            status = "";
            List consist = et.getConsistsOf();
            f2 = consist.iterator();
            while (f2.hasNext()) {
                ConsistsOf c = (ConsistsOf)f2.next();
                if (!(c instanceof ConsistsOf)) continue;
                if (c.getTarget() instanceof AccessPointFacet) {
                    AccessPointFacet af = (AccessPointFacet)c.getTarget();
                    try {
                        ghnName = af.getEndpoint().getHost().toString();
                    }
                    catch (Exception e) {
                        ghnName = "";
                    }
                }
                if (!(c.getTarget() instanceof StateFacet)) continue;
                StateFacet stf = (StateFacet)c.getTarget();
                try {
                    status = stf.getValue().toLowerCase();
                }
                catch (Exception e) {
                    status = "";
                }
            }
            GcoreEndPointObject temp = new GcoreEndPointObject(id, type, subType, ScopeProvider.instance.get(), serviceClass, serviceName, version, status, ghnName);
            StringWriter sw = new StringWriter();
            m.marshal((Object)temp, (Writer)sw);
            if (subTypeC != null) {
                if (!subType.equals(subTypeC)) continue;
                resource.add(sw.toString());
                continue;
            }
            resource.add(sw.toString());
        }
        return resource;
    }

    public static List<String> createListConfiguration(ResourceRegistryClient resourceRegistryClient, String typeC, String subTypeC) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GenericResourceObject.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.fragment", (Object)true);
        ArrayList<String> resource = new ArrayList<String>();
        String id = "";
        String type = "GenericResource";
        String subType = "";
        String name = "";
        String description = "";
        List econfiguration = resourceRegistryClient.getInstances(Configuration.class, Boolean.valueOf(false));
        for (Configuration et : econfiguration) {
            id = et.getHeader().getUUID().toString();
            List facets = et.getIdentificationFacets();
            for (Facet f : facets) {
                if (!(f instanceof SoftwareFacet)) continue;
                SoftwareFacet sf = (SoftwareFacet)f;
                name = sf.getName();
                subType = sf.getGroup();
                description = sf.getDescription();
            }
            CacheList.resourceid.put(id, new ResourceObject(name, et.toString()));
            GenericResourceObject temp = new GenericResourceObject(id, type, subType, name, description, ScopeProvider.instance.get());
            StringWriter sw = new StringWriter();
            m.marshal((Object)temp, (Writer)sw);
            if (subTypeC != null) {
                if (!subType.equals(subTypeC)) continue;
                resource.add(sw.toString());
                continue;
            }
            resource.add(sw.toString());
        }
        return resource;
    }

    public static List<String> createListHostingNode(ResourceRegistryClient resourceRegistryClient, String typeC, String subTypeC) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{HostingNodeObject.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.fragment", (Object)true);
        ArrayList<String> resource = new ArrayList<String>();
        String id = "";
        String type = "GHN";
        String subType = "";
        String status = "";
        String name = "";
        String upTime = "-";
        String lastUpdate = "-";
        long localAvailableSpace = 0L;
        long virtualSize = 0L;
        long virtualAvailable = 0L;
        String loadLast1Min = "-";
        String loadLast5Min = "-";
        String loadLast15Min = "-";
        String gcfVersion = "";
        String ghnVersion = "";
        List ehosting = resourceRegistryClient.getInstances(HostingNode.class, Boolean.valueOf(false));
        for (HostingNode eh : ehosting) {
            Object f2;
            id = eh.getHeader().getUUID().toString();
            lastUpdate = eh.getHeader().getLastUpdateTime().toString();
            List facets = eh.getIdentificationFacets();
            for (Object f2 : facets) {
                if (!(f2 instanceof NetworkingFacet)) continue;
                NetworkingFacet nf = (NetworkingFacet)f2;
                subType = nf.getDomainName();
                name = nf.getHostName();
            }
            CacheList.resourceid.put(id, new ResourceObject(name, eh.toString()));
            List consist = eh.getConsistsOf();
            f2 = consist.iterator();
            while (f2.hasNext()) {
                ConsistsOf c = (ConsistsOf)f2.next();
                if (!(c instanceof ConsistsOf)) continue;
                if (c.getTarget() instanceof SimplePropertyFacet) {
                    SimplePropertyFacet sp = (SimplePropertyFacet)c.getTarget();
                    try {
                        gcfVersion = sp.getAdditionalProperty("SmartGearsDistribution").toString();
                        ghnVersion = sp.getAdditionalProperty("SmartGears").toString();
                    }
                    catch (Exception e) {
                        gcfVersion = "";
                        ghnVersion = "";
                    }
                }
                if (c instanceof HasPersistentMemory) {
                    HasPersistentMemory hpm = (HasPersistentMemory)c;
                    try {
                        MemoryFacet mfh = (MemoryFacet)hpm.getTarget();
                        localAvailableSpace = mfh.getSize() - mfh.getUsed();
                    }
                    catch (Exception e) {
                        localAvailableSpace = 0L;
                    }
                }
                if (c instanceof HasVolatileMemory) {
                    HasVolatileMemory hvm = (HasVolatileMemory)c;
                    try {
                        if (hvm.getAdditionalProperty("memoryType").equals("RAM")) {
                            MemoryFacet mf = (MemoryFacet)hvm.getTarget();
                            virtualAvailable = mf.getSize() - mf.getUsed();
                            virtualSize = mf.getSize();
                        }
                    }
                    catch (Exception e) {
                        virtualAvailable = 0L;
                        virtualSize = 0L;
                    }
                }
                if (!(c.getTarget() instanceof StateFacet)) continue;
                StateFacet st = (StateFacet)c.getTarget();
                try {
                    status = st.getValue();
                }
                catch (Exception e) {
                    status = "";
                }
            }
            HostingNodeObject temp = new HostingNodeObject(id, type, subType, status, name, upTime, lastUpdate, localAvailableSpace, virtualSize, virtualAvailable, loadLast1Min, loadLast5Min, loadLast15Min, gcfVersion, ghnVersion, ScopeProvider.instance.get());
            StringWriter sw = new StringWriter();
            m.marshal((Object)temp, (Writer)sw);
            if (subTypeC != null) {
                if (!subType.equals(subTypeC)) continue;
                resource.add(sw.toString());
                continue;
            }
            resource.add(sw.toString());
        }
        return resource;
    }
}

