/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.resourcemanagement.server;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gcube.common.authorization.library.provider.AccessTokenProvider;
import org.gcube.common.keycloak.KeycloakClient;
import org.gcube.common.keycloak.KeycloakClientFactory;
import org.gcube.common.keycloak.model.TokenResponse;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCache;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClientFactory;
import org.gcube.informationsystem.types.reference.Type;
import org.gcube.portlets.admin.resourcemanagement.shared.resource.CacheList;
import org.gcube.portlets.admin.resourcemanagement.shared.resource.ResourceObject;
import org.gcube.portlets.admin.resourcemanagement.shared.resource.UtilityResource;
import org.gcube.resourcemanagement.support.client.views.ResourceTypeDecorator;
import org.gcube.resourcemanagement.support.shared.types.datamodel.CompleteResourceProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RegistryClientRequester {
    private static Logger logger = LoggerFactory.getLogger(RegistryClientRequester.class);
    private static ResourceRegistryClient resourceRegistryClient;
    private static KeycloakClient client;
    private static final String endpoint = "https://accounts.dev.d4science.org/auth/realms/d4science/protocol/openid-connect/token";
    private static final String clientID = "resource-registry-portlet-expieve";
    private static final String secret = "179bd3bc-5cc4-11ec-bf63-0242ac130001";
    private static final String rootScope = "/gcube";

    public static final Set<String> getAvailableContexts() throws Exception {
        HashSet<String> contextList = new HashSet();
        ScopeProvider.instance.set("/gcube");
        AccessTokenProvider.instance.set(RegistryClientRequester.getTokenForContext((String)"/gcube"));
        try {
            resourceRegistryClient = ResourceRegistryClientFactory.create();
            ContextCache contextCache = ContextCache.getInstance();
            contextList = contextCache.getContextFullNameToUUIDAssociation().keySet();
        }
        catch (Exception e) {
            Set<String> set = Collections.emptySet();
            return set;
        }
        finally {
            AccessTokenProvider.instance.reset();
            ScopeProvider.instance.reset();
        }
        return contextList;
    }

    private static String getTokenForContext(String context) {
        try {
            TokenResponse response = client.queryUMAToken(new URL("https://accounts.dev.d4science.org/auth/realms/d4science/protocol/openid-connect/token"), "resource-registry-portlet-expieve", "179bd3bc-5cc4-11ec-bf63-0242ac130001", context, null);
            return response.getAccessToken();
        }
        catch (Exception e) {
            throw new RuntimeException("error getting access token for context " + context, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final HashMap<String, ArrayList<String>> getResourcesTree(String scope) throws Exception {
        HashMap<String, ArrayList> retval = new HashMap<String, ArrayList>();
        ScopeProvider.instance.set(scope);
        AccessTokenProvider.instance.set(RegistryClientRequester.getTokenForContext((String)scope));
        try {
            logger.info("GetResourcesTree: [Scope: {}]", (Object)scope);
            resourceRegistryClient = ResourceRegistryClientFactory.create();
            List types = resourceRegistryClient.getType(Resource.class, Boolean.valueOf(true));
            logger.info("Resources Types: {}", (Object)types.size());
            for (Type t : types) {
                logger.info("Resource Type: {} in {} ", (Object)t.getName(), (Object)scope);
                if (t.getName() == null) continue;
                String val = null;
                switch (t.getName()) {
                    case "Actor": {
                        val = "Actor";
                        break;
                    }
                    case "LegalBody": {
                        val = "LegalBody";
                        break;
                    }
                    case "Person": {
                        val = "Person";
                        break;
                    }
                    case "ConfigurationTemplate": {
                        val = "ConfigurationTemplate";
                        break;
                    }
                    case "Configuration": {
                        val = "GenericResource";
                        break;
                    }
                    case "Dataset": {
                        val = "Dataset";
                        break;
                    }
                    case "ConcreteDataset": {
                        val = "ConcreteDataset";
                        break;
                    }
                    case "Schema": {
                        val = "Schema";
                        break;
                    }
                    case "EService": {
                        val = "RunningInstance";
                        break;
                    }
                    case "RunningPlugin": {
                        val = "RunningPlugin";
                        break;
                    }
                    case "HostingNode": {
                        val = "GHN";
                        break;
                    }
                    case "VirtualService": {
                        val = "VirtualService";
                        break;
                    }
                    case "Site": {
                        val = "Site";
                        break;
                    }
                    case "Software": {
                        val = "Software";
                        break;
                    }
                    case "Plugin": {
                        val = "Plugin";
                        break;
                    }
                }
                if (val == null) continue;
                ArrayList subtrees = new ArrayList();
                try {
                    subtrees = UtilityResource.getSubResourcesTreeQuery((ResourceRegistryClient)resourceRegistryClient, (String)t.getName());
                }
                catch (Exception e) {
                    logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
                retval.put(val, subtrees);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            AccessTokenProvider.instance.reset();
            ScopeProvider.instance.reset();
        }
        LinkedList list = new LinkedList(retval.keySet());
        Collections.sort(list, new /* Unavailable Anonymous Inner Class!! */);
        logger.info("Sorted Key: {}", list);
        LinkedHashMap<String, ArrayList<String>> sortedretval = new LinkedHashMap<String, ArrayList<String>>();
        for (String k : list) {
            sortedretval.put(k, (ArrayList<String>)retval.get(k));
        }
        return sortedretval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<String> getResourcesByTypeSubType(String scope, String type, String subType) throws Exception {
        ScopeProvider.instance.set(scope);
        AccessTokenProvider.instance.set(RegistryClientRequester.getTokenForContext((String)scope));
        try {
            logger.info("GetResourcesByTypeSubType: [Scope:{}, Type:{}]", (Object)scope, (Object)type);
            resourceRegistryClient = ResourceRegistryClientFactory.create();
            List resources = new ArrayList();
            switch (type) {
                case "Actor": {
                    logger.info("---------------->Actor");
                    resources = UtilityResource.createListActor((ResourceRegistryClient)resourceRegistryClient, (String)type, (String)subType);
                    break;
                }
                case "LegalBody": {
                    logger.info("---------------->LegalBody");
                    resources = UtilityResource.createListLegalBody((ResourceRegistryClient)resourceRegistryClient, (String)type, (String)subType);
                    break;
                }
                case "Person": {
                    logger.info("---------------->Person");
                    resources = UtilityResource.createListPerson((ResourceRegistryClient)resourceRegistryClient, (String)type, (String)subType);
                    break;
                }
                case "ConfigurationTemplate": {
                    logger.info("---------------->ConfigurationTemplate");
                    resources = UtilityResource.createListConfigurationTemplate((ResourceRegistryClient)resourceRegistryClient, (String)type, (String)subType);
                    break;
                }
                case "GenericResource": {
                    logger.info("---------------->Configuration");
                    resources = UtilityResource.createListConfiguration((ResourceRegistryClient)resourceRegistryClient, (String)type, (String)subType);
                    break;
                }
                case "Dataset": {
                    logger.info("---------------->Dataset");
                    resources = UtilityResource.createListDataset((ResourceRegistryClient)resourceRegistryClient, (String)type, (String)subType);
                    break;
                }
                case "ConcreteDataset": {
                    logger.info("---------------->ConcreteDataset");
                    resources = UtilityResource.createListConcreteDataset((ResourceRegistryClient)resourceRegistryClient, (String)type, (String)subType);
                    break;
                }
                case "Schema": {
                    logger.info("---------------->Schema");
                    resources = UtilityResource.createListSchema((ResourceRegistryClient)resourceRegistryClient, (String)type, (String)subType);
                    break;
                }
                case "RunningInstance": {
                    logger.info("---------------->EService");
                    resources = UtilityResource.createListEservice((ResourceRegistryClient)resourceRegistryClient, (String)type, (String)subType);
                    break;
                }
                case "RunningPlugin": {
                    logger.info("---------------->RunningPlugin");
                    resources = UtilityResource.createListRunningPlugin((ResourceRegistryClient)resourceRegistryClient, (String)type, (String)subType);
                    break;
                }
                case "GHN": {
                    logger.info("---------------->HostingNode");
                    resources = UtilityResource.createListHostingNode((ResourceRegistryClient)resourceRegistryClient, (String)type, (String)subType);
                    break;
                }
                case "VirtualService": {
                    logger.info("---------------->VirtualService");
                    resources = UtilityResource.createListVirtualService((ResourceRegistryClient)resourceRegistryClient, (String)type, (String)subType);
                    break;
                }
                case "Site": {
                    logger.info("---------------->Site");
                    resources = UtilityResource.createListSite((ResourceRegistryClient)resourceRegistryClient, (String)type, (String)subType);
                    break;
                }
                case "Software": {
                    logger.info("---------------->Software");
                    resources = UtilityResource.createListSoftware((ResourceRegistryClient)resourceRegistryClient, (String)type, (String)subType);
                    break;
                }
                case "Plugin": {
                    logger.info("---------------->Plugin");
                    resources = UtilityResource.createListPlugin((ResourceRegistryClient)resourceRegistryClient, (String)type, (String)subType);
                    break;
                }
            }
            Object object = resources;
            return object;
        }
        finally {
            AccessTokenProvider.instance.reset();
            ScopeProvider.instance.reset();
        }
    }

    public static CompleteResourceProfile getResourceByID(String xml2htmlMapping, String scope, String type, String resID) {
        String representation = ((ResourceObject)CacheList.resourceid.get(resID)).getBody();
        String title = ((ResourceObject)CacheList.resourceid.get(resID)).getTitle();
        String xmlRepresentation = "<Resource><ID>" + resID + "</ID><Type>" + type + "</Type><Scope>" + scope + "</Scope>" + representation + "</Resource>";
        String htmlRepresentation = representation;
        ScopeProvider.instance.set(scope);
        return new CompleteResourceProfile(resID, ResourceTypeDecorator.valueOf((String)type), title, xmlRepresentation, htmlRepresentation);
    }

    static {
        client = KeycloakClientFactory.newInstance();
    }
}

