<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	
	<xsl:output method="html"/>

	<xsl:template match="Report">
		<html>
			<head>
				<meta http-equiv="Cache-Control" content="No-cache"/>
				<meta http-equiv="Expires" content="0"/>
				<meta http-equiv="Pragma" content="No-cache"/>
				<meta http-equiv="Cache-Control" content="no-store"/>
				<meta http-equiv="Cache-Control" content="max-age=0"/>
			</head>
			<body>
				<div>
					<xsl:for-each select="./*">
						<ul>
							<xsl:call-template name="ReportContent"/>
						</ul>
					</xsl:for-each>
				</div>
			</body>
		</html>
	</xsl:template>

	<xsl:template name="ReportContent">
		<li>
			<xsl:choose>
				<xsl:when test="name() = 'Element'">
					<xsl:call-template name="formatElement"/>
				</xsl:when>
				<xsl:otherwise>
					<strong><xsl:value-of select="name()"/> : </strong>
					<xsl:value-of select="."/>
					<xsl:for-each select="@*">
						<xsl:choose>
							<xsl:when test="name() = 'status'">
								<xsl:if test=". = 'ERROR'">
									<font color="#ff0000">
										<b> <xsl:value-of select="."/> : </b>
									</font>
								</xsl:if>
							</xsl:when>
							<xsl:otherwise>
								<i>
									<strong>
										<xsl:value-of select="."/>
									</strong>
								</i>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each> 
				</xsl:otherwise>
			</xsl:choose>
		</li>
	</xsl:template>
	
	<xsl:template name="formatElement">
		<xsl:choose>
			<xsl:when test="count(child::*) > '0'">
				<xsl:for-each select="child::*">
					<xsl:call-template name="formatElement"/>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:for-each select="@*">
					<xsl:choose>
						<xsl:when test="name() = 'xPath'">
							<i> <xsl:value-of select="."/> : </i>
						</xsl:when>
										
						<xsl:when test="name() = 'name'">
							<strong> <xsl:value-of select="."/> : </strong>
						</xsl:when>
						
						<xsl:when test="name() = 'status'">
							<xsl:if test=". = 'ERROR'">
								<font color="#ff0000">
									<b> <xsl:value-of select="."/> : </b>
								</font>
							</xsl:if>
							<xsl:if test=". = 'WARNING'">
								<font color="#FFCC00">
									<b> <xsl:value-of select="."/> : </b>
								</font>
							</xsl:if>
							<xsl:if test=". = 'INFO'">
								<font color="#99CC33">
									<b> <xsl:value-of select="."/> : </b>
								</font>
							</xsl:if>
						</xsl:when>
						
						<xsl:otherwise>
							<xsl:value-of select="."/>
						</xsl:otherwise>

					</xsl:choose>
				</xsl:for-each>
				<xsl:value-of select="."/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


</xsl:stylesheet>
