/****************************************************************************
 *  This software is part of the gCube Project.
 *  Site: http://www.gcube-system.org/
 ****************************************************************************
 * The gCube/gCore software is licensed as Free Open Source software
 * conveying to the EUPL (http://ec.europa.eu/idabc/eupl).
 * The software and documentation is provided by its authors/distributors
 * "as is" and no expressed or
 * implied warranty is given for its use, quality or fitness for a
 * particular case.
 ****************************************************************************
 * Filename: CollectionManager.java
 ****************************************************************************
 * @author <a href="mailto:daniele.strollo@isti.cnr.it">Daniele Strollo</a>
 ***************************************************************************/

package org.gcube.resourcemanagement.support.managers.resources;

import java.io.StringReader;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.GCUBECollection;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.resourcemanagement.support.exceptions.AbstractResourceException;
import org.gcube.resourcemanagement.support.exceptions.ResourceAccessException;
import org.gcube.resourcemanagement.support.exceptions.ResourceParameterException;
import org.gcube.resourcemanagement.support.types.AllowedResourceTypes;

/**
 * @author Daniele Strollo (ISTI-CNR)
 *
 */
public class CollectionManager extends AbstractResourceManager {
	/**
	 * @deprecated discouraged use. With no ID some operations cannot be accessed.
	 */
	public CollectionManager()
	throws ResourceParameterException, ResourceAccessException {
		super(AllowedResourceTypes.Collection);
	}

	public CollectionManager(final String id)
	throws ResourceParameterException, ResourceAccessException {
		super(id, AllowedResourceTypes.Collection);
	}

	/**
	 * @param id
	 * @param name
	 * @throws ResourceParameterException
	 * @throws ResourceAccessException
	 */
	public CollectionManager(final String id, final String name)
	throws ResourceParameterException, ResourceAccessException {
		super(id, name, AllowedResourceTypes.Collection);
	}

	/**
	 * @param id
	 * @param name
	 * @param subtype
	 * @throws ResourceParameterException
	 * @throws ResourceAccessException
	 */
	public CollectionManager(final String id, final String name, final String subtype)
	throws ResourceParameterException, ResourceAccessException {
		super(id, name, AllowedResourceTypes.Collection, subtype);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected final GCUBEResource buildGCUBEResource(final String xmlRepresentation)
	throws AbstractResourceException {
		try {
			GCUBECollection impl =	GHNContext.getImplementation(GCUBECollection.class);
			impl.load(new StringReader(xmlRepresentation));
			return impl;
		} catch (Exception e) {
			throw new ResourceAccessException("Cannot load the stub for resource " + this.getType(), e);
		}
	}

}
