<!--
 PARAMETS:
    RES_ID the ID of the Service
 -->
let $service := collection('/db/Profiles/Service')//Resource//Resource[ID/text() eq '<RES_ID/>']
let $ServiceClass := $service/Profile/Class
let $ServiceName := $service/Profile/Name
let $ServiceVersion := $service/Profile/Version
let $riloop := collection('/db/Profiles/RunningInstance')//Resource[Profile/ServiceClass/string() eq $ServiceClass and Profile/ServiceName/string() eq $ServiceName]
let $relatedris := 
    for $ri in $riloop
        let $ghn-id := $ri/Profile/GHN/@UniqueID/string()
        let $ghn := collection('/db/Profiles/GHN')//Resource[ID/string() eq $ghn-id]
    <!-- and $ri//Profile/Version/string() eq $ServiceVersion -->
    return 
      <Resource>
        <!-- INFORMATION ABOUT THE RI -->
        <RIID>{$ri/ID/string()}</RIID>
        <ServiceStatus>{$ri/Profile/DeploymentData/Status/string()}</ServiceStatus>
        <ActivationTime>{$ri/Profile/DeploymentData/ActivationTime/@value/string()}</ActivationTime>
        <RIVersion>{$ri/Profile/Version/string()}</RIVersion>
        <!-- INFORMATION about GHN -->
        <GHNID>{$ghn-id}</GHNID>
        <GHNName>{$ghn/Profile/GHNDescription/Name/string()}</GHNName>
        <GHNSite>{$ghn/Profile/Site/Domain/string()}</GHNSite>
        <GHNStatus>{$ghn/Profile/GHNDescription/Status/string()}</GHNStatus>
        <GHNLoad15Min>{$ghn/Profile/GHNDescription/Load/@Last15Min/string()}</GHNLoad15Min>
        <GHNLoad5Min>{$ghn/Profile/GHNDescription/Load/@Last15Min/string()}</GHNLoad5Min>
        <GHNLoad1Min>{$ghn/Profile/GHNDescription/Load/@Last15Min/string()}</GHNLoad1Min>
        <GHNActivationTime>{$ghn/Profile/GHNDescription/ActivationTime/string()}</GHNActivationTime>
        <GHNLastUpdate>{$ghn/Profile/GHNDescription/LastUpdate/string()}</GHNLastUpdate>
      </Resource>
return
<Resources>
    {$relatedris}
</Resources> 