/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.support.server.managers.resources;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.resourcemanagement.support.server.exceptions.AbstractResourceException;
import org.gcube.resourcemanagement.support.server.exceptions.ResourceAccessException;
import org.gcube.resourcemanagement.support.server.exceptions.ResourceParameterException;
import org.gcube.resourcemanagement.support.server.managers.resources.AbstractResourceManager;
import org.gcube.resourcemanagement.support.server.types.AllowedResourceTypes;
import org.gcube.resourcemanagement.support.server.utils.Assertion;
import org.gcube.resourcemanagement.support.server.utils.ServerConsole;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GenericResourceManager
extends AbstractResourceManager {
    private static GenericResourceManager singleton = null;
    private static final String LOG_PREFIX = "[GenericResource-MGR]";

    public GenericResourceManager() throws ResourceParameterException, ResourceAccessException {
        super(AllowedResourceTypes.GenericResource);
    }

    public GenericResourceManager(String id) throws ResourceParameterException, ResourceAccessException {
        super(id, AllowedResourceTypes.GenericResource);
    }

    public GenericResourceManager(String id, String name) throws ResourceParameterException, ResourceAccessException {
        super(id, name, AllowedResourceTypes.GenericResource);
    }

    public GenericResourceManager(String id, String name, String subtype) throws ResourceParameterException, ResourceAccessException {
        super(id, name, AllowedResourceTypes.GenericResource, subtype);
    }

    public final void update(String name, String description, String body, String subType, ScopeBean scope) throws Exception {
        Assertion<ResourceParameterException> checker = new Assertion<ResourceParameterException>();
        checker.validate(name != null && name.trim().length() != 0, new ResourceParameterException("Invalid field name. Null or empty value not allowed"));
        ServerConsole.trace(LOG_PREFIX, "[RES-UPDATE] updating resource " + (Object)((Object)this.getType()) + " " + this.getID());
        GenericResource resource = this.getResourceToEditById(this.getID(), scope);
        resource.profile().name(name.trim());
        if (description != null) {
            resource.profile().description(description.trim());
        }
        if (body != null) {
            GenericResourceManager.appendXmlFragment(resource.profile(), body);
        }
        if (subType != null) {
            resource.profile().type(subType.trim());
        }
        ScopeProvider.instance.set(scope.toString());
        RegistryPublisher publisher = this.getRegistryPublisher();
        String id = ((GenericResource)publisher.update((Resource)resource)).id();
        if (id == null || id.length() == 0) {
            throw new Exception("The GenericResource has not been updated");
        }
        ServerConsole.info(LOG_PREFIX, "Resource Updated with ID: " + id);
    }

    private GenericResource getResourceToEditById(String id, ScopeBean scope) throws Exception {
        ScopeProvider.instance.set(scope.toString());
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/ID/text() eq '" + id + "'");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List r = client.submit((Query)query);
        if (r == null || r.isEmpty()) {
            throw new Exception("Could not retrieve GenericResource profile with id " + id + " in scope + " + scope);
        }
        return (GenericResource)r.get(0);
    }

    public static final synchronized String create(String ID, ScopeBean scope, String name, String description, String body, String subType) throws Exception {
        Assertion<ResourceParameterException> checker = new Assertion<ResourceParameterException>();
        checker.validate(name != null && name.trim().length() != 0, new ResourceParameterException("Invalid field name. Null or empty value not allowed"));
        checker.validate(subType != null && subType.trim().length() != 0, new ResourceParameterException("Invalid field subType. Null or empty value not allowed"));
        GenericResource resource = new GenericResource();
        resource.newProfile().name(name.trim());
        if (description != null) {
            resource.profile().description(description.trim());
        }
        if (body != null) {
            GenericResourceManager.appendXmlFragment(resource.profile(), body);
        }
        resource.profile().type(subType.trim());
        GenericResourceManager gm = new GenericResourceManager();
        ScopeProvider.instance.set(scope.toString());
        RegistryPublisher publisher = gm.getRegistryPublisher();
        String id = ((GenericResource)publisher.create((Resource)resource)).id();
        if (id == null || id.length() == 0) {
            throw new Exception("The GenericResource has not been created");
        }
        ServerConsole.info(LOG_PREFIX, "Resource Created with ID: " + id);
        return id;
    }

    @Override
    protected final Resource buildResource(String xmlRepresentation) throws AbstractResourceException {
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{GenericResource.class});
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            StringReader reader = new StringReader(xmlRepresentation);
            GenericResource deserialised = (GenericResource)unmarshaller.unmarshal((Reader)reader);
            return deserialised;
        }
        catch (Exception e) {
            throw new ResourceAccessException("Cannot load the resource " + (Object)((Object)this.getType()), e);
        }
    }

    public static void appendXmlFragment(GenericResource.Profile profile, String fragment) throws IOException, ParserConfigurationException {
        ServerConsole.debug(LOG_PREFIX, "Appending to <Body> " + fragment);
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Element elem = profile.newBody();
        try {
            Node fragmentNode = docBuilder.parse(new InputSource(new StringReader(fragment))).getDocumentElement();
            fragmentNode = elem.getOwnerDocument().importNode(fragmentNode, true);
            elem.appendChild(fragmentNode);
        }
        catch (SAXException e) {
            ServerConsole.warn("no valid xml appending this:" + fragment);
            profile.newBody(fragment);
        }
    }

    static {
        if (singleton == null) {
            try {
                singleton = new GenericResourceManager("dummyservice", "dummyservice");
            }
            catch (Exception e) {
                ServerConsole.error(LOG_PREFIX, e);
            }
        }
    }
}

