/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.support.server.gcube;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.gcube.common.resources.gcore.utils.XPathHelper;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.resourcemanagement.support.client.views.ResourceTypeDecorator;
import org.gcube.resourcemanagement.support.server.gcube.CacheManager;
import org.gcube.resourcemanagement.support.server.gcube.ISQueryCache;
import org.gcube.resourcemanagement.support.server.gcube.ISQueryCacheKeyT;
import org.gcube.resourcemanagement.support.server.gcube.queries.QueryLoader;
import org.gcube.resourcemanagement.support.server.gcube.queries.QueryLocation;
import org.gcube.resourcemanagement.support.server.managers.scope.ScopeManager;
import org.gcube.resourcemanagement.support.server.utils.ServerConsole;
import org.gcube.resourcemanagement.support.shared.plugins.GenericResourcePlugin;
import org.gcube.resourcemanagement.support.shared.plugins.TMPluginFormField;
import org.gcube.resourcemanagement.support.shared.types.Tuple;
import org.gcube.resourcemanagement.support.shared.types.datamodel.CompleteResourceProfile;
import org.gcube.resourcemanagement.support.shared.types.datamodel.ResourceDescriptor;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.QueryBox;
import org.gcube.resources.discovery.client.queries.impl.QueryTemplate;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ISClientRequester {
    private static final ISQueryCache CACHE = new ISQueryCache();
    private static final String LOG_PREFIX = "[ISCLIENT-REQS]";

    public static void emptyCache() {
        CACHE.empty();
    }

    private static final ArrayList<String> getResourceTypes(CacheManager status, ScopeBean queryScope) throws Exception {
        List<String> resultz = null;
        String currScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(queryScope.toString());
        QueryBox isQuery = new QueryBox(QueryLoader.getQuery(QueryLocation.GET_TREE_TYPES));
        DiscoveryClient client = ICFactory.client();
        ISQueryCacheKeyT cacheKey = new ISQueryCacheKeyT(queryScope.toString(), isQuery.expression(), "getResourcesTypes");
        if (status.isUsingCache() && CACHE.contains(cacheKey) && CACHE.get(cacheKey) != null) {
            resultz = CACHE.get(cacheKey);
        } else {
            try {
                resultz = client.submit((Query)isQuery);
                if (status.isUsingCache()) {
                    CACHE.insert(cacheKey, resultz);
                }
            }
            catch (Exception e) {
                throw new Exception(e.getMessage());
            }
        }
        if (resultz == null || resultz.size() == 0) {
            return null;
        }
        String type = null;
        ArrayList<String> types = new ArrayList<String>();
        try {
            for (String elem : resultz) {
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Element node = docBuilder.parse(new InputSource(new StringReader(elem))).getDocumentElement();
                XPathHelper helper = new XPathHelper((Node)node);
                type = (String)helper.evaluate("/type/text()").get(0);
                if (type == null || type.trim().length() <= 0) continue;
                types.add(type.trim());
            }
            types.remove("MetadataCollection");
            isQuery = new QueryBox("declare namespace vm = 'http://gcube-system.org/namespaces/contentmanagement/viewmanager';declare namespace gc = 'http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider';declare namespace is = 'http://gcube-system.org/namespaces/informationsystem/registry';for $data in collection(\"/db/Properties\")//Document, $view in $data/Data where $view/gc:ServiceName/string() eq \"ViewManager\"  and $view/gc:ServiceClass/string() eq \"ContentManagement\" and count($view//vm:View)>0 return <a>true</a>");
            if (client.submit((Query)isQuery).size() > 0) {
                types.add("VIEW");
            }
            if (client.submit((Query)(isQuery = new QueryBox("declare namespace gc = 'http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider';declare namespace is = 'http://gcube-system.org/namespaces/informationsystem/registry';for $data in collection(\"/db/Profiles/GenericResource\")//Document/Data/is:Profile/Resource where $data/Profile/SecondaryType eq \"GCUBECollection\"  return <a>true</a>"))).size() > 0) {
                types.add("Collection");
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        ScopeProvider.instance.set(currScope);
        return types;
    }

    private static final ArrayList<String> getResourceSubTypes(CacheManager status, ScopeBean queryScope, String resourceType) throws Exception {
        ArrayList<String> subtypes = new ArrayList<String>();
        if (resourceType.equals("Collection")) {
            subtypes.add("System");
            subtypes.add("User");
            return subtypes;
        }
        if (resourceType.equals("VIEW")) {
            subtypes.add("Not supported");
            return subtypes;
        }
        List<String> resultz = null;
        String currScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(queryScope.toString());
        QueryTemplate isQuery = new QueryTemplate(QueryLoader.getQuery(QueryLocation.GET_TREE_SUBTYPES));
        DiscoveryClient client = ICFactory.client();
        isQuery.addParameter("RES_TYPE", resourceType);
        isQuery.addParameter("SUBTYPE", "<subtype>{$subtype}</subtype>");
        ISQueryCacheKeyT cacheKey = new ISQueryCacheKeyT(queryScope.toString(), isQuery.expression(), "getResourcesSubTypes");
        if (status.isUsingCache() && CACHE.contains(cacheKey) && CACHE.get(cacheKey) != null) {
            resultz = CACHE.get(cacheKey);
        } else {
            try {
                resultz = client.submit((Query)isQuery);
                if (status.isUsingCache()) {
                    CACHE.insert(cacheKey, resultz);
                }
            }
            catch (Exception e) {
                throw new Exception(e.getMessage());
            }
        }
        if (resultz == null || resultz.size() == 0) {
            return null;
        }
        for (String elem : resultz) {
            try {
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Element node = docBuilder.parse(new InputSource(new StringReader(elem))).getDocumentElement();
                XPathHelper helper = new XPathHelper((Node)node);
                String subtype = (String)helper.evaluate("/subtype/text()").get(0);
                if (subtype == null || subtype.trim().length() <= 0) continue;
                subtypes.add(subtype.trim());
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
        ScopeProvider.instance.set(currScope);
        return subtypes;
    }

    public static final HashMap<String, ArrayList<String>> getResourcesTree(CacheManager status, ScopeBean queryScope) throws Exception {
        HashMap<String, ArrayList<String>> retval = new HashMap<String, ArrayList<String>>();
        ArrayList<String> types = ISClientRequester.getResourceTypes(status, queryScope);
        ArrayList<String> subtypes = null;
        for (String type : types) {
            try {
                subtypes = ISClientRequester.getResourceSubTypes(status, queryScope, type);
                if (subtypes == null || subtypes.size() <= 0) continue;
                retval.put(type, subtypes);
            }
            catch (Exception e) {
                ServerConsole.error(LOG_PREFIX, e);
            }
        }
        List resultz = null;
        String currScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(queryScope.toString());
        QueryBox isQuery = new QueryBox(QueryLoader.getQuery(QueryLocation.GET_WSRES_TYPES));
        DiscoveryClient client = ICFactory.client();
        resultz = client.submit((Query)isQuery);
        if (resultz == null || resultz.size() == 0) {
            return retval;
        }
        subtypes = new ArrayList();
        for (String elem : resultz) {
            subtypes.add(elem.toString());
        }
        retval.put("WSResource", subtypes);
        ScopeProvider.instance.set(currScope);
        return retval;
    }

    public static final List<String> getRelatedResources(CacheManager status, String type, String id, ScopeBean queryScope) throws Exception {
        QueryLocation queryPath = null;
        try {
            queryPath = QueryLocation.valueOf("LIST_RELATED_" + type);
        }
        catch (Exception e) {
            ServerConsole.error(LOG_PREFIX, "Getting the resource query.", e);
            throw new Exception(e.getMessage());
        }
        String currScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(queryScope.toString());
        QueryTemplate isQuery = new QueryTemplate(QueryLoader.getQuery(queryPath));
        DiscoveryClient client = ICFactory.client();
        isQuery.addParameter("RES_ID", id.trim());
        isQuery.addParameter("RESOURCE", QueryLoader.getQuery(QueryLocation.valueOf("LIST_RELATED_RETURN_" + type)));
        ISQueryCacheKeyT cacheKey = new ISQueryCacheKeyT(queryScope.toString(), isQuery.expression(), "getResourceRelated");
        List<String> resultz = null;
        if (status.isUsingCache() && CACHE.contains(cacheKey) && CACHE.get(cacheKey) != null) {
            resultz = CACHE.get(cacheKey);
        } else {
            resultz = client.submit((Query)isQuery);
            if (status.isUsingCache()) {
                CACHE.insert(cacheKey, resultz);
            }
        }
        if (resultz == null || resultz.size() == 0) {
            ServerConsole.debug(LOG_PREFIX, "[getResourcesRelated] Got No Results");
            return null;
        }
        ArrayList<String> retval = new ArrayList<String>();
        for (String elem : resultz) {
            try {
                String toAdd = elem.toString();
                if (toAdd != null) {
                    toAdd = toAdd.replace("<Resources>", "");
                    toAdd = toAdd.replace("</Resources>", "");
                }
                retval.add(toAdd);
            }
            catch (Exception e) {
                ServerConsole.debug(LOG_PREFIX, "[getResourcesRelated] found and invalid resource");
            }
        }
        ScopeProvider.instance.set(currScope);
        ServerConsole.trace(LOG_PREFIX, "Retrieved (" + retval.size() + ") ServiceDetails for type: " + type);
        return retval;
    }

    public static final List<String> getResourcesByType(CacheManager status, ScopeBean queryScope, String type, String subType) throws Exception {
        QueryLocation queryPath = null;
        QueryLocation returnPath = null;
        try {
            if (type.equals(ResourceTypeDecorator.WSResource.name())) {
                queryPath = QueryLocation.GET_WSRES_DETAILS_BYSUBTYPE;
                returnPath = QueryLocation.valueOf("RETURN_" + (Object)((Object)QueryLocation.GET_WSRES_DETAILS_BYSUBTYPE));
            } else {
                queryPath = QueryLocation.valueOf("LIST_" + type);
                returnPath = QueryLocation.valueOf("RETURN_" + type);
            }
        }
        catch (Exception e) {
            ServerConsole.error(LOG_PREFIX, "Getting the resource query.", e);
            throw new Exception(e.getMessage());
        }
        String currScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(queryScope.toString());
        QueryTemplate isQuery = new QueryTemplate(QueryLoader.getQuery(queryPath));
        DiscoveryClient client = ICFactory.client();
        if (type.equals(ResourceTypeDecorator.WSResource.name())) {
            if (subType != null && subType.length() > 0) {
                isQuery.addParameter("RES_SUBTYPE", subType.trim());
            }
        } else if (subType != null && subType.length() > 0) {
            if (subType.equalsIgnoreCase("User") || subType.equalsIgnoreCase("System")) {
                isQuery.addParameter("RES_SUBTYPE", " and $profiles/Profile/Body/CollectionInfo/user/text() = \"" + (subType.trim().equals("User") ? "true" : "false") + "\"");
            } else {
                isQuery.addParameter("RES_SUBTYPE", "where $subtype = \"" + subType.trim() + "\"");
            }
        }
        String retParam = type.equals(ResourceTypeDecorator.WSResource.name()) ? "WSRESOURCE" : "RESOURCE";
        isQuery.addParameter(retParam, QueryLoader.getQuery(returnPath));
        ISQueryCacheKeyT cacheKey = new ISQueryCacheKeyT(queryScope.toString(), isQuery.expression(), "getResourcesTypes");
        List<String> resultz = null;
        if (status.isUsingCache() && CACHE.contains(cacheKey) && CACHE.get(cacheKey) != null) {
            resultz = CACHE.get(cacheKey);
        } else {
            resultz = client.submit((Query)isQuery);
            if (status.isUsingCache()) {
                CACHE.insert(cacheKey, resultz);
            }
        }
        if (resultz == null || resultz.size() == 0) {
            return null;
        }
        Vector<String> retval = new Vector<String>();
        for (String elem : resultz) {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Element node = docBuilder.parse(new InputSource(new StringReader(elem))).getDocumentElement();
            XPathHelper helper = new XPathHelper((Node)node);
            try {
                if (helper.evaluate("//ID").get(0) != null && ((String)helper.evaluate("//ID").get(0)).trim().length() > 0) {
                    retval.add(elem.toString());
                    continue;
                }
                ServerConsole.debug(LOG_PREFIX, "*** Found an invalid element with no ID");
            }
            catch (Exception e) {
                ServerConsole.debug(LOG_PREFIX, "[getResourcesByType] found a resource with empty ID");
            }
        }
        ScopeProvider.instance.set(currScope);
        return retval;
    }

    public static final List<ResourceDescriptor> getResourceModels(ScopeBean queryScope, String type, String subType, List<Tuple<String>> additionalMaps) throws Exception {
        String currScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(queryScope.toString());
        QueryTemplate isQuery = null;
        DiscoveryClient client = ICFactory.client();
        if (subType != null && subType.trim().length() > 0) {
            isQuery = new QueryTemplate(QueryLoader.getQuery(QueryLocation.GET_RES_DETAILS_BYSUBTYPE));
            isQuery.addParameter("RES_TYPE", type.trim());
            isQuery.addParameter("RES_SUBTYPE", subType.trim());
            isQuery.addParameter("RESOURCE", QueryLoader.getQuery(QueryLocation.RETURN_GET_RES_DETAILS_BYSUBTYPE));
        } else {
            isQuery = new QueryTemplate(QueryLoader.getQuery(QueryLocation.GET_RES_DETAILS_BYTYPE));
            isQuery.addParameter("RES_TYPE", type);
            isQuery.addParameter("RESOURCE", QueryLoader.getQuery(QueryLocation.RETURN_GET_RES_DETAILS_BYTYPE));
        }
        List resultz = client.submit((Query)isQuery);
        Vector<ResourceDescriptor> retval = new Vector<ResourceDescriptor>();
        ResourceDescriptor toAdd = null;
        for (String elem : resultz) {
            try {
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Element node = docBuilder.parse(new InputSource(new StringReader(elem))).getDocumentElement();
                XPathHelper helper = new XPathHelper((Node)node);
                if (helper.evaluate("//ID").get(0) == null) continue;
                toAdd = new ResourceDescriptor((String)helper.evaluate("//Type/text()").get(0), (String)helper.evaluate("//SubType/text()").get(0), (String)helper.evaluate("//ID/text()").get(0), (String)helper.evaluate("//Name/text()").get(0));
                if (additionalMaps != null && additionalMaps.size() > 0) {
                    for (Tuple<String> map : additionalMaps) {
                        try {
                            toAdd.addProperty(map.get(0), helper.evaluate(map.get(1)).get(0));
                        }
                        catch (Exception e) {
                            toAdd.addProperty(map.get(0), "");
                        }
                    }
                }
                retval.add(toAdd);
            }
            catch (Exception e) {
                ServerConsole.debug(LOG_PREFIX, "[getResourcesByType] found a resource with empty ID");
            }
        }
        ScopeProvider.instance.set(currScope);
        return retval;
    }

    public static final List<String> getWSResources(ScopeBean queryScope) throws Exception {
        List resultz = null;
        String currScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(queryScope.toString());
        QueryBox isQuery = new QueryBox(QueryLoader.getQuery(QueryLocation.GET_WSRES_DETAILS_BYTYPE));
        DiscoveryClient client = ICFactory.client();
        Vector<String> retval = new Vector<String>();
        resultz = client.submit((Query)isQuery);
        for (String elem : resultz) {
            retval.add(elem.toString());
        }
        ScopeProvider.instance.set(currScope);
        return retval;
    }

    public static final CompleteResourceProfile getResourceByID(String xmlFilePath, ScopeBean queryScope, String resType, String resID) throws Exception {
        String currScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(queryScope.toString());
        QueryTemplate isQuery = null;
        DiscoveryClient client = ICFactory.client();
        if (resType == null) {
            isQuery = new QueryTemplate(QueryLoader.getQuery(QueryLocation.GET_RESOURCE_BYID));
            isQuery.addParameter("RES_ID", resID);
        } else if (resType.equalsIgnoreCase(ResourceTypeDecorator.WSResource.name())) {
            isQuery = new QueryTemplate(QueryLoader.getQuery(QueryLocation.GET_WSRESOURCE_BYID));
            isQuery.addParameter("RES_ID", resID);
        } else {
            isQuery = new QueryTemplate(QueryLoader.getQuery(QueryLocation.GET_RESOURCE_BYID));
            isQuery.addParameter("RES_ID", resID);
            isQuery.addParameter("RES_TYPE", resType);
        }
        List results = client.submit((Query)isQuery);
        if (results != null && results.size() > 0) {
            String type = null;
            if (resType == null) {
                try {
                    DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Element node = docBuilder.parse(new InputSource(new StringReader((String)results.get(0)))).getDocumentElement();
                    XPathHelper helper = new XPathHelper((Node)node);
                    type = (String)helper.evaluate("/Resource/Type/text()").get(0);
                }
                catch (Exception e) {
                    ServerConsole.error(LOG_PREFIX, e);
                }
            } else {
                type = resType;
            }
            String xmlRepresentation = ((String)results.get(0)).toString();
            String htmlRepresentation = ISClientRequester.XML2HTML(xmlRepresentation, xmlFilePath);
            ScopeProvider.instance.set(currScope);
            return new CompleteResourceProfile(resID, ResourceTypeDecorator.valueOf(type), ISClientRequester.getResourceName(type, resID, (String)results.get(0)), xmlRepresentation, htmlRepresentation);
        }
        ScopeProvider.instance.set(currScope);
        return null;
    }

    public static Map<String, GenericResourcePlugin> getGenericResourcePlugins(ScopeBean scope) throws Exception {
        ScopeProvider.instance.set(scope.toString());
        QueryBox isQuery = new QueryBox(QueryLoader.getQuery(QueryLocation.GET_GENERIC_RESOURCE_PLUGINS));
        DiscoveryClient client = ICFactory.client();
        List resultz = client.submit((Query)isQuery);
        HashMap<String, GenericResourcePlugin> retval = new HashMap<String, GenericResourcePlugin>();
        for (String plugin : resultz) {
            try {
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Element node = docBuilder.parse(new InputSource(new StringReader(plugin))).getDocumentElement();
                XPathHelper helper = new XPathHelper((Node)node);
                for (String entry : helper.evaluate("/CMPlugins/Plugin/Entry")) {
                    Document doc = ScopeManager.getDocumentGivenXML(entry);
                    String name = doc.getElementsByTagName("name").item(0).getFirstChild().getNodeValue();
                    ServerConsole.trace("[LOAD-PLUGIN] found: *** name " + name);
                    String pluginType = doc.getElementsByTagName("Type").item(0).getFirstChild().getNodeValue();
                    ServerConsole.trace("[LOAD-PLUGIN] found: *** type " + pluginType);
                    String description = doc.getElementsByTagName("description").item(0).getFirstChild().getNodeValue();
                    ServerConsole.trace("[LOAD-PLUGIN] found: *** description " + description);
                    String namespace = null;
                    try {
                        namespace = doc.getElementsByTagName("namespace").item(0).getFirstChild().getNodeValue();
                        ServerConsole.debug("[LOAD-PLUGIN] found: *** namespace " + namespace);
                    }
                    catch (Exception e) {
                        ServerConsole.warn("[LOAD-PLUGIN] namespace not found");
                    }
                    GenericResourcePlugin toAdd = new GenericResourcePlugin(name, namespace, description, pluginType);
                    NodeList params = doc.getElementsByTagName("param");
                    for (int i = 0; i < params.getLength(); ++i) {
                        NodeList paramTree = params.item(i).getChildNodes();
                        String paramName = null;
                        String paramDefinition = null;
                        for (int j = 0; j < paramTree.getLength(); ++j) {
                            if (paramTree.item(j).getNodeName().equals("param-name")) {
                                paramName = paramTree.item(j).getFirstChild().getNodeValue();
                            }
                            if (!paramTree.item(j).getNodeName().equals("param-definition")) continue;
                            paramDefinition = paramTree.item(j).getFirstChild().getNodeValue();
                        }
                        ServerConsole.trace("[LOAD-PLUGIN] found: param " + paramName);
                        GenericResourcePlugin.Field paramField = new GenericResourcePlugin.Field(paramName, GenericResourcePlugin.FieldType.string);
                        if (paramDefinition != null) {
                            StringTokenizer parser = new StringTokenizer(paramDefinition, ";");
                            while (parser.hasMoreTokens()) {
                                try {
                                    String currElem = parser.nextToken();
                                    String key = currElem.substring(0, currElem.indexOf("="));
                                    String value = currElem.substring(currElem.indexOf("=") + 1, currElem.length()).trim();
                                    if (key.equals("type")) {
                                        paramField.setType(GenericResourcePlugin.FieldType.valueOf(value));
                                    }
                                    if (key.equals("opt")) {
                                        paramField.setIsRequired(!Boolean.parseBoolean(value));
                                    }
                                    if (key.equals("label")) {
                                        if (value.startsWith("'")) {
                                            value = value.substring(1, value.length());
                                        }
                                        if (value.endsWith("'")) {
                                            value = value.substring(0, value.length() - 1);
                                        }
                                        paramField.setLabel(value);
                                    }
                                    if (!key.equals("default")) continue;
                                    if (value.startsWith("'")) {
                                        value = value.substring(1, value.length());
                                    }
                                    if (value.endsWith("'")) {
                                        value = value.substring(0, value.length() - 1);
                                    }
                                    paramField.setDefaultValue(value);
                                }
                                catch (Exception exception) {}
                            }
                        }
                        toAdd.addParam(paramField);
                    }
                    retval.put(name + "::" + pluginType, toAdd);
                }
            }
            catch (RuntimeException e) {
            }
        }
        return retval;
    }

    public static HashMap<String, ArrayList<TMPluginFormField>> getGenericResourceTreeManagerPlugins(ScopeBean scope) throws Exception {
        ScopeProvider.instance.set(scope.toString());
        QueryBox isQuery = new QueryBox(QueryLoader.getQuery(QueryLocation.GET_GENERIC_RESOURCE_TREE_MANAGER_PLUGINS));
        DiscoveryClient client = ICFactory.client();
        List resultz = client.submit((Query)isQuery);
        HashMap<String, ArrayList<TMPluginFormField>> retval = new HashMap<String, ArrayList<TMPluginFormField>>();
        for (String plugin : resultz) {
            try {
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Element node = docBuilder.parse(new InputSource(new StringReader(plugin))).getDocumentElement();
                XPathHelper helper = new XPathHelper((Node)node);
                for (String entry : helper.evaluate("/TMPlugins/Plugin/Entry")) {
                    String requestName = null;
                    boolean foundRequest = false;
                    Document doc = ScopeManager.getDocumentGivenXML(entry);
                    String name = doc.getElementsByTagName("name").item(0).getFirstChild().getNodeValue();
                    ServerConsole.trace("[LOAD-TMPLUGIN] found: *** name " + name);
                    String pluginType = doc.getElementsByTagName("Type").item(0).getFirstChild().getNodeValue();
                    ServerConsole.trace("[LOAD-TMPLUGIN] found: *** type " + pluginType);
                    String description = doc.getElementsByTagName("description").item(0).getFirstChild().getNodeValue();
                    ServerConsole.trace("[LOAD-TMPLUGIN] found: *** description " + description);
                    String namespace = null;
                    try {
                        namespace = doc.getElementsByTagName("namespace").item(0).getFirstChild().getNodeValue();
                        ServerConsole.trace("[LOAD-TMPLUGIN] found: *** namespace " + namespace);
                    }
                    catch (Exception e) {
                        ServerConsole.warn("[LOAD-TMPLUGIN] namespace not found");
                    }
                    NodeList params = doc.getElementsByTagName("param");
                    ArrayList<Object> formFields = new ArrayList();
                    for (int i = 0; i < params.getLength(); ++i) {
                        NodeList paramTree = params.item(i).getChildNodes();
                        String paramName = null;
                        String xmlToParse = null;
                        boolean foundSample = false;
                        for (int j = 0; j < paramTree.getLength(); ++j) {
                            if (paramTree.item(j).getNodeName().equals("param-name") && (paramName = paramTree.item(j).getFirstChild().getNodeValue()).compareTo("requestSample") == 0) {
                                foundSample = true;
                                foundRequest = true;
                            }
                            if (!paramTree.item(j).getNodeName().equals("param-definition") || !foundSample) continue;
                            xmlToParse = paramTree.item(j).getFirstChild().getNodeValue();
                            xmlToParse = xmlToParse.replaceAll("&lt;", "<");
                            xmlToParse = xmlToParse.replaceAll("&gt;", "<");
                            foundSample = false;
                            requestName = ISClientRequester.getRequestName(xmlToParse);
                            formFields = ISClientRequester.getPluginFormFromXml(xmlToParse);
                        }
                        retval.put(name + ":" + requestName, formFields);
                    }
                    if (foundRequest) continue;
                    retval.put(name, formFields);
                }
            }
            catch (RuntimeException e) {
            }
        }
        return retval;
    }

    private static String getRequestName(String xmlToParse) {
        Document doc = ScopeManager.getDocumentGivenXML(xmlToParse);
        return doc.getDocumentElement().getNodeName();
    }

    private static ArrayList<TMPluginFormField> getPluginFormFromXml(String xmlToParse) {
        ArrayList<TMPluginFormField> toReturn = new ArrayList<TMPluginFormField>();
        Document doc = ScopeManager.getDocumentGivenXML(xmlToParse);
        Element root = doc.getDocumentElement();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String label = children.item(i).getNodeName();
            String defaultValue = children.item(i).getFirstChild().getNodeValue();
            boolean repeatable = false;
            boolean required = false;
            if (children.item(i).hasAttributes()) {
                NamedNodeMap attributes = children.item(i).getAttributes();
                if (children.item(i).getAttributes().getNamedItem("repeatable") != null) {
                    repeatable = attributes.getNamedItem("repeatable").getNodeValue().equalsIgnoreCase("true");
                }
                if (children.item(i).getAttributes().getNamedItem("required") != null) {
                    required = attributes.getNamedItem("required").getNodeValue().equalsIgnoreCase("true");
                }
            }
            toReturn.add(new TMPluginFormField(label, defaultValue, required, repeatable));
        }
        return toReturn;
    }

    private static String getResourceName(String type, String ID, String node) throws Exception {
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Element xnode = docBuilder.parse(new InputSource(new StringReader(node))).getDocumentElement();
        XPathHelper helper = new XPathHelper((Node)xnode);
        if (type.equalsIgnoreCase(ResourceTypeDecorator.GHN.name())) {
            try {
                return (String)helper.evaluate("/Resource/Profile/GHNDescription/Name/text()").get(0);
            }
            catch (Exception e) {
                return ID;
            }
        }
        if (type.equalsIgnoreCase(ResourceTypeDecorator.Collection.name())) {
            try {
                return (String)helper.evaluate("/Resource/Profile/Name/text()").get(0);
            }
            catch (Exception e) {
                return ID;
            }
        }
        if (type.equalsIgnoreCase(ResourceTypeDecorator.Service.name())) {
            try {
                return (String)helper.evaluate("/Resource/Profile/Name/text()").get(0);
            }
            catch (Exception e) {
                return ID;
            }
        }
        if (type.equalsIgnoreCase(ResourceTypeDecorator.RunningInstance.name())) {
            try {
                return (String)helper.evaluate("/Resource/Profile/ServiceName/text()").get(0);
            }
            catch (Exception e) {
                return ID;
            }
        }
        if (type.equalsIgnoreCase(ResourceTypeDecorator.EService.name())) {
            try {
                return (String)helper.evaluate("/Resource/Profile/ServiceName/text()").get(0);
            }
            catch (Exception e) {
                return ID;
            }
        }
        if (type.equalsIgnoreCase(ResourceTypeDecorator.VIEW.name())) {
            try {
                return (String)helper.evaluate("/Resource/Profile/Name/text()").get(0);
            }
            catch (Exception e) {
                return ID;
            }
        }
        if (type.equalsIgnoreCase(ResourceTypeDecorator.RuntimeResource.name())) {
            try {
                return (String)helper.evaluate("/Resource/Profile/Name/text()").get(0);
            }
            catch (Exception e) {
                return ID;
            }
        }
        if (type.equalsIgnoreCase(ResourceTypeDecorator.GenericResource.name())) {
            try {
                return (String)helper.evaluate("/Resource/Profile/Name/text()").get(0);
            }
            catch (Exception e) {
                return ID;
            }
        }
        if (type.equalsIgnoreCase(ResourceTypeDecorator.WSResource.name())) {
            try {
                return (String)helper.evaluate("/Document/Data/child::*[local-name()='ServiceName']/text()").get(0);
            }
            catch (Exception e) {
                return ID;
            }
        }
        return null;
    }

    public static String XML2HTML(String xml, String xslt) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        FileInputStream stream = new FileInputStream(xslt);
        BufferedReader in = new BufferedReader(new InputStreamReader(stream));
        StringBuilder retval = new StringBuilder();
        String currLine = null;
        while ((currLine = in.readLine()) != null) {
            if (currLine.trim().length() > 0 && currLine.trim().startsWith("#") || currLine.trim().length() == 0) continue;
            retval.append(currLine + System.getProperty("line.separator"));
        }
        in.close();
        StreamSource source = new StreamSource(new ByteArrayInputStream(retval.toString().getBytes()));
        Templates compiledXSLT = tf.newTemplates(source);
        Transformer t = compiledXSLT.newTransformer();
        t.setOutputProperty("omit-xml-declaration", "true");
        StringWriter w = new StringWriter();
        t.transform(new StreamSource(new StringReader(xml)), new StreamResult(w));
        return w.toString();
    }
}

