/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.support.server.managers.report;

import org.gcube.resourcemanagement.support.server.exceptions.AbstractResourceException;
import org.gcube.resourcemanagement.support.server.managers.report.ReportOperation;
import org.gcube.resourcemanagement.support.server.managers.resources.AbstractResourceManager;

public class ReportEntry {
    private ReportOperation operation = null;
    private AbstractResourceManager resource = null;
    private boolean success = false;
    private String message = null;

    public ReportEntry(ReportOperation operation, AbstractResourceManager resource) throws AbstractResourceException {
        this(operation, resource, null, false);
    }

    public ReportEntry(ReportOperation operation, AbstractResourceManager resource, boolean success) throws AbstractResourceException {
        this(operation, resource, null, success);
    }

    public ReportEntry(ReportOperation operation, AbstractResourceManager resource, String message, boolean success) throws AbstractResourceException {
        this.operation = operation;
        this.resource = resource;
        this.success = success;
        this.message = message;
    }

    public final ReportOperation getOperation() {
        return this.operation;
    }

    public final AbstractResourceManager getResource() {
        return this.resource;
    }

    public final boolean isSuccess() {
        return this.success;
    }

    public final void setSuccess(boolean success) {
        this.success = success;
    }

    public final void setMessage(String message) {
        this.message = message;
    }

    public final void setMessage(Throwable ex) {
        this.message = ex.getMessage();
    }

    public final String toString() {
        return this.toXML();
    }

    public final String toXML() {
        return "\t<Operation type=\"" + this.getOperation().getLabel() + "\">\n\t\t<Status>" + (this.isSuccess() ? "SUCCESS" : "FAILURE") + "</Status>\n\t\t<Resource>\n\t\t\t<ID>" + this.getResource().getID() + "</ID>\n" + (this.getResource().getName() != null ? "\t\t\t<Name>" + this.getResource().getName() + "</Name>\n" : "") + "\t\t\t<Type>" + (Object)((Object)this.getResource().getType()) + "</Type>\n" + (this.message != null ? "\t\t\t<Message>\n\t\t\t\t" + this.message.trim() + "\n\t\t\t</Message>\n" : "") + "\t\t</Resource>\n\t</Operation>\n";
    }
}

