/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.support.server.managers.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.Software;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.resourcemanagement.support.server.exceptions.AbstractResourceException;
import org.gcube.resourcemanagement.support.server.exceptions.ResourceAccessException;
import org.gcube.resourcemanagement.support.server.exceptions.ResourceOperationException;
import org.gcube.resourcemanagement.support.server.exceptions.ResourceParameterException;
import org.gcube.resourcemanagement.support.server.managers.resources.AbstractResourceManager;
import org.gcube.resourcemanagement.support.server.managers.resources.ResourceFactory;
import org.gcube.resourcemanagement.support.server.managers.scope.ScopeManager;
import org.gcube.resourcemanagement.support.server.types.AllowedResourceTypes;
import org.gcube.resourcemanagement.support.server.utils.Assertion;
import org.gcube.resourcemanagement.support.server.utils.ServerConsole;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.vremanagement.resourcemanager.client.RMBinderLibrary;
import org.gcube.vremanagement.resourcemanager.client.fws.Types;

public class ManagementUtils {
    private static final String LOG_PREFIX = "[MANAGEMENT-UTILS]";

    public static final synchronized String addToExistingScope(AllowedResourceTypes type, String[] resourceIDs, ScopeBean sourceScope, ScopeBean targetScope) throws Exception {
        ServerConsole.trace(LOG_PREFIX, "[ADD-ToExistingScope] Adding from scope [" + sourceScope.toString() + "] to existing scope [" + targetScope.toString() + "] resources having type " + type.name());
        if (type != AllowedResourceTypes.GHN && type != AllowedResourceTypes.RunningInstance && sourceScope.type() == ScopeBean.Type.VO && targetScope.type() == ScopeBean.Type.VO) {
            String retval = ManagementUtils.bindToScope(type, resourceIDs, targetScope);
            try {
                for (String id : resourceIDs) {
                    AbstractResourceManager res = ResourceFactory.createResourceManager(type, id);
                    Resource resStub = res.getResource(sourceScope);
                    ScopeProvider.instance.set(targetScope.toString());
                    res.getRegistryPublisher().update(resStub);
                }
            }
            catch (Exception e) {
                throw new ResourceAccessException(e.getMessage());
            }
            return retval;
        }
        if (sourceScope.toString().contains(targetScope.toString())) {
            throw new ResourceOperationException("You are not allowed to apply to this scope. Target scope is not enclosed in the source one.");
        }
        return ManagementUtils.bindToScope(type, resourceIDs, targetScope);
    }

    public static final synchronized String removeFromExistingScope(AllowedResourceTypes type, String[] resourceIDs, ScopeBean sourceScope, ScopeBean targetScope) throws Exception {
        ServerConsole.trace(LOG_PREFIX, "[REMOVE-FromExistingScope] Removing scope [" + targetScope.toString() + "] from existing scope [" + sourceScope.toString() + "] resources having type " + type.name());
        if (targetScope.toString().compareTo(sourceScope.toString()) == 0) {
            return "You are not allowed to remove this scope. Current and Target scope are the same.";
        }
        String toReturn = "";
        AbstractResourceManager manager = ResourceFactory.createResourceManager(type);
        for (String id : resourceIDs) {
            try {
                manager.setID(id);
                toReturn = manager.delete(targetScope);
            }
            catch (AbstractResourceException e) {
                ServerConsole.error(LOG_PREFIX, e);
            }
        }
        return toReturn;
    }

    private static synchronized String bindToScope(AllowedResourceTypes type, String[] resourceIDs, ScopeBean targetScope) throws AbstractResourceException {
        Types.AddResourcesParameters addParam = new Types.AddResourcesParameters();
        RMBinderLibrary manager = ResourceFactory.createResourceManager(type).getResourceManager(targetScope.toString());
        ArrayList<Types.ResourceItem> resToBind = new ArrayList<Types.ResourceItem>();
        for (String id : resourceIDs) {
            Types.ResourceItem toAdd = new Types.ResourceItem();
            toAdd.id = id;
            toAdd.setType(type.name());
            resToBind.add(toAdd);
        }
        Types.ResourceList r = new Types.ResourceList();
        r.setResource(resToBind);
        addParam.setResources(r);
        addParam.setTargetScope(targetScope.toString());
        try {
            String reportID = manager.addResources(addParam);
            ServerConsole.trace(LOG_PREFIX, "[BIND-SCOPE-EXIT] Applyed Adding of resources " + type.name() + " to scope [" + targetScope.toString() + "]... reportID: " + reportID);
            return reportID;
        }
        catch (Exception e) {
            ServerConsole.trace(LOG_PREFIX, "[BIND-SCOPE-EXIT] [FAILURE]");
            throw new ResourceOperationException("During resource::addToScope: " + e.getMessage());
        }
    }

    public static synchronized void delete(AllowedResourceTypes type, String[] resourceIDs, ScopeBean scope) throws AbstractResourceException {
        AbstractResourceManager resource = ResourceFactory.createResourceManager(type);
        for (String id : resourceIDs) {
            try {
                resource.setID(id);
                resource.delete(scope);
            }
            catch (AbstractResourceException e) {
                ServerConsole.error(LOG_PREFIX, e);
            }
        }
    }

    public static final synchronized String deploy(ScopeBean scope, String[] ghnsID, String[] servicesID) throws Exception {
        Assertion<Exception> checker = new Assertion<Exception>();
        checker.validate(ghnsID != null && ghnsID.length != 0, new ResourceParameterException("Invalid ghnsID parameter. It cannot be null or empty."));
        checker.validate(servicesID != null && servicesID.length != 0, new ResourceParameterException("Invalid servicesID parameter. It cannot be null or empty."));
        checker.validate(scope != null, new Exception("Cannot retrieve the scope."));
        RMBinderLibrary manager = ResourceFactory.createResourceManager(AllowedResourceTypes.Service).getResourceManager(scope.toString());
        System.out.println("\n\n**** These are the service ids to deploy on SCOPE " + scope);
        for (String string : servicesID) {
            System.out.println(string);
        }
        System.out.println("\n\n**** These are the gHNs ids to deploy on SCOPE " + scope);
        for (String string : ghnsID) {
            System.out.println(string);
        }
        ArrayList<Types.PackageItem> serviceProfiles = new ArrayList<Types.PackageItem>();
        XQuery query = null;
        DiscoveryClient client = ICFactory.clientFor(Software.class);
        for (String serviceID : servicesID) {
            System.out.println("\n\n**** Query the ICClient to get the profile");
            query = ICFactory.queryFor(Software.class);
            query.addCondition("$resource/ID/text() eq '" + serviceID + "'");
            System.out.println("**** Query : " + query.toString());
            String curr = ScopeProvider.instance.get();
            ScopeProvider.instance.set(scope.toString());
            List results = client.submit((Query)query);
            ScopeProvider.instance.set(curr);
            System.out.println("**** results received : " + results.size());
            Software ret = null;
            if (results == null || results.size() <= 0) continue;
            ret = (Software)results.get(0);
            if (ret == null || ret.profile() == null || ret.profile().softwareClass() == null || ret.profile().softwareName() == null) {
                ServerConsole.error(LOG_PREFIX, "found an invalid service profile");
                continue;
            }
            Types.PackageItem toAdd = new Types.PackageItem();
            toAdd.serviceClass = ret.profile().softwareClass();
            toAdd.serviceName = ret.profile().softwareName();
            toAdd.serviceVersion = "1.0.0";
            if (ret.profile().packages().size() == 1) {
                toAdd.packageName = ((Software.Profile.SoftwarePackage)ret.profile().packages().iterator().next()).name();
                toAdd.packageVersion = ((Software.Profile.SoftwarePackage)ret.profile().packages().iterator().next()).version();
            } else {
                for (Software.Profile.SoftwarePackage p : ret.profile().packages()) {
                    if (!p.getClass().isAssignableFrom(Software.Profile.ServicePackage.class)) continue;
                    toAdd.packageName = p.name();
                    toAdd.packageVersion = p.version();
                    break;
                }
            }
            serviceProfiles.add(toAdd);
        }
        Types.SoftwareList softwareList = new Types.SoftwareList();
        ArrayList<String> arrayGHNSids = new ArrayList<String>();
        for (int i = 0; i < ghnsID.length; ++i) {
            arrayGHNSids.add(ghnsID[i]);
        }
        softwareList.suggestedTargetGHNNames = arrayGHNSids;
        softwareList.software = serviceProfiles;
        Types.AddResourcesParameters addResourcesParameters = new Types.AddResourcesParameters();
        addResourcesParameters.softwareList = softwareList;
        addResourcesParameters.setTargetScope(scope.toString());
        System.out.println("\n\n**** These is the ServiceList i pass to ResourceManagerPortType: ");
        for (int i = 0; i < softwareList.software.size(); ++i) {
            System.out.println(softwareList.software.get(i));
        }
        String id = "";
        id = manager.addResources(addResourcesParameters);
        ServerConsole.debug(LOG_PREFIX, "Report ID = " + id);
        System.out.println("Returning.... no exceptions");
        return id;
    }

    public static final void main(String[] args) {
        Vector<String> ids = new Vector<String>();
        ids.add(null);
        ids.add("id2");
        ids.add(null);
        ScopeManager.setScopeConfigFile("test-suite" + File.separator + "scopes" + File.separator + "scopedata.xml");
        try {
            ManagementUtils.delete(AllowedResourceTypes.GenericResource, new String[]{"3f7384a0-d51c-11df-80cc-ece35605c26c", "975419b0-d2e1-11df-b0ed-f8e6e669b8ad", null, "test"}, new ScopeBean("/gcube/devsec/devVRE"));
        }
        catch (Exception e) {
            ServerConsole.error(LOG_PREFIX, e);
        }
    }
}

